/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient.utils;

import com.avaya.generic.channel.testclient.PropertyKey;
import com.avaya.generic.channel.testclient.utils.ExternalException;
import com.avaya.generic.channel.testclient.utils.RestResponse;
import com.avaya.generic.channel.testclient.utils.Utils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class Rest {
    private static CloseableHttpClient httpClientInstance = null;
    private static CloseableHttpClient httpSecureClientInstance = null;

    public static RestResponse get(String url) throws UnsupportedEncodingException, ExternalException, IOException {
        Rest.printRequest("GET", url, null);
        return Rest.execute(new HttpGet(url));
    }

    public static RestResponse put(String url) throws UnsupportedEncodingException, ExternalException, IOException {
        Rest.printRequest("PUT", url, null);
        return Rest.execute(new HttpPut(url));
    }

    public static RestResponse delete(String url) throws UnsupportedEncodingException, ExternalException, IOException {
        Rest.printRequest("DELETE", url, null);
        return Rest.execute(new HttpDelete(url));
    }

    public static RestResponse post(String url, JSONObject json) throws UnsupportedEncodingException, ExternalException, IOException {
        Rest.printRequest("POST", url, json);
        if (json == null) {
            return new RestResponse(400, "");
        }
        HttpPost request = new HttpPost(url);
        request.addHeader("content-type", "application/json");
        StringEntity stringEntity = new StringEntity(json.toString());
        request.setEntity(stringEntity);
        return Rest.execute(request);
    }

    public static void shutdown() {
        HttpClientUtils.closeQuietly(httpClientInstance);
        HttpClientUtils.closeQuietly(httpSecureClientInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RestResponse execute(HttpRequestBase request) throws IOException, ExternalException {
        RestResponse restResponse;
        CloseableHttpResponse httpResponse = null;
        HttpEntity entity = null;
        try {
            httpResponse = request.getURI().toString().toLowerCase().startsWith("https:") ? Rest.getHttpSecureClient().execute(request) : Rest.getHttpClient().execute(request);
            int code = 0;
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine == null) {
                throw new ExternalException("No status code found in the response");
            }
            code = statusLine.getStatusCode();
            String content = "";
            entity = httpResponse.getEntity();
            if (entity != null) {
                try {
                    content = EntityUtils.toString(entity);
                }
                catch (Exception ex) {
                    content = "";
                }
            }
            restResponse = new RestResponse(code, content);
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            RestResponse restResponse2;
            try {
                restResponse2 = new RestResponse(501, "");
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(entity);
                HttpClientUtils.closeQuietly(httpResponse);
                throw throwable;
            }
            EntityUtils.consumeQuietly(entity);
            HttpClientUtils.closeQuietly(httpResponse);
            return restResponse2;
        }
        EntityUtils.consumeQuietly(entity);
        HttpClientUtils.closeQuietly(httpResponse);
        return restResponse;
    }

    private static void printRequest(String method, String url, JSONObject json) {
        Utils.printSeparator();
        Utils.print("%s %s", method, url);
        if (json != null) {
            JSONObject jsonCopy = json;
            if (json.has(PropertyKey.ssoToken.name())) {
                jsonCopy = new JSONObject(json, JSONObject.getNames(json));
                String ssoToken = jsonCopy.getString(PropertyKey.ssoToken.name());
                jsonCopy.put(PropertyKey.ssoToken.name(), Utils.trimTo16chars(ssoToken));
            }
            Utils.println(" %s", jsonCopy.toString());
        } else {
            Utils.println();
        }
        Utils.printSeparator();
    }

    private static synchronized CloseableHttpClient getHttpClient() {
        if (httpClientInstance == null) {
            httpClientInstance = HttpClients.createDefault();
        }
        return httpClientInstance;
    }

    private static synchronized CloseableHttpClient getHttpSecureClient() throws NoSuchAlgorithmException, KeyManagementException {
        if (httpSecureClientInstance == null) {
            SSLContext sslcontext = SSLContexts.custom().useSSL().build();
            sslcontext.init(null, new X509TrustManager[]{new HttpsTrustManager()}, new SecureRandom());
            SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            httpSecureClientInstance = HttpClients.custom().setSSLSocketFactory(factory).build();
        }
        return httpSecureClientInstance;
    }

    private static class HttpsTrustManager
    implements X509TrustManager {
        private HttpsTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

