/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient;

import com.avaya.generic.channel.testclient.PropertyKey;
import com.avaya.generic.channel.testclient.utils.ExternalException;
import com.avaya.generic.channel.testclient.utils.Utils;
import java.io.File;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.ReloadingDetectorFactory;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.reloading.ManagedReloadingDetector;
import org.apache.commons.configuration2.reloading.ReloadingDetector;

class Configuration {
    private final ManagedReloadingDetector myReloadingDetector = new ManagedReloadingDetector();
    private final ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> builder;
    private final Map<PropertyKey, String> actualKeys = new EnumMap<PropertyKey, String>(PropertyKey.class);

    Configuration(File propertiesFile) {
        this.builder = new ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration>(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setFile(propertiesFile)).setThrowExceptionOnMissing(true)).setListDelimiterHandler(new DisabledListDelimiterHandler())).setIncludesAllowed(false)).setReloadingDetectorFactory(new MyReloadingDetectorFactory())).setLogger(ConfigurationLogger.newDummyLogger())});
    }

    File getPropertiesFile() {
        return this.builder.getFileHandler().getFile();
    }

    void reload() throws ExternalException {
        this.myReloadingDetector.refresh();
        this.builder.getReloadingController().checkForReloading(null);
        this.actualKeys.clear();
        try {
            Iterator<String> iterator = ((PropertiesConfiguration)this.builder.getConfiguration()).getKeys();
            while (iterator.hasNext()) {
                String actualKey = iterator.next();
                try {
                    if (((PropertiesConfiguration)this.builder.getConfiguration()).getList(actualKey).size() > 1) {
                        throw new ExternalException("Property %s duplicated", actualKey);
                    }
                }
                catch (ConversionException conversionException) {
                    // empty catch block
                }
                PropertyKey key = PropertyKey.byStringIgnoreCase(actualKey);
                if (key == null) {
                    StringBuilder sb = new StringBuilder().append("Unknown property ").append(actualKey).append("\n\n").append("Supported properties:");
                    for (PropertyKey supportedPropertyKey : PropertyKey.values()) {
                        sb.append("\n    ").append((Object)supportedPropertyKey);
                    }
                    throw new ExternalException(sb.toString());
                }
                if (this.actualKeys.get((Object)key) != null) {
                    throw new ExternalException("Property %s duplicated", new Object[]{key});
                }
                this.actualKeys.put(key, actualKey);
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    String getAuthorizationHost() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.authorizationHost);
    }

    String getApiHost() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.apiHost);
    }

    String getCoreDataServiceHost() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.coreDataServiceHost);
    }

    String getClientId() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.clientId);
    }

    String getKeyStore() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.keyStore);
    }

    String getKeyStorePassword() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.keyStorePassword);
    }

    String getKeyAlias() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.keyAlias);
    }

    String getTrustStore() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.trustStore);
    }

    String getTrustStorePassword() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.trustStorePassword);
    }

    String getEventConnectorHost() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.eventConnectorHost);
    }

    String getEventFamily() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.eventFamily);
    }

    String getEventCallbackHost() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.eventCallbackHost);
    }

    String getEventCallbackPort() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.eventCallbackPort);
    }

    String getEventSubscription() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.eventSubscription);
    }

    String getUesrname() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.username);
    }

    String getPassword() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.password);
    }

    String getAuthPort() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.authPort);
    }

    void setSsoToken(String ssoToken) throws ExternalException, ConfigurationException {
        this.set(PropertyKey.ssoToken, ssoToken);
    }

    void setEventSubscription(String eventSubscription) throws ExternalException, ConfigurationException {
        this.set(PropertyKey.eventSubscription, eventSubscription);
    }

    String getNumContactsForClosing() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.numContactsForClosing);
    }

    String getNumContactsForShowing() throws ExternalException, ConfigurationException {
        return this.get(PropertyKey.numContactsForShowing);
    }

    String opt(PropertyKey key) throws ConfigurationException {
        return ((PropertiesConfiguration)this.builder.getConfiguration()).getString(this.actualKeyFor(key), null);
    }

    private String get(PropertyKey key) throws ExternalException, ConfigurationException {
        String value = this.opt(key);
        if (Utils.isNotEmpty(value)) {
            return value;
        }
        throw new ExternalException("Property %s %s", new Object[]{key, value != null ? "is empty" : "not specified"});
    }

    private void set(PropertyKey key, String newValue) throws ConfigurationException {
        ((PropertiesConfiguration)this.builder.getConfiguration()).setProperty(this.actualKeyFor(key), newValue != null ? newValue : "");
        this.builder.save();
        Utils.println("Property %s %s", new Object[]{key, Utils.isNotEmpty(newValue) ? "updated" : "cleared"});
    }

    private String actualKeyFor(PropertyKey key) {
        String actualKey = this.actualKeys.get((Object)key);
        if (actualKey == null) {
            actualKey = key.name();
        }
        return actualKey;
    }

    private class MyReloadingDetectorFactory
    implements ReloadingDetectorFactory {
        private MyReloadingDetectorFactory() {
        }

        @Override
        public ReloadingDetector createReloadingDetector(FileHandler fileHandler, FileBasedBuilderParametersImpl fileBasedBuilderParameters) throws ConfigurationException {
            return Configuration.this.myReloadingDetector;
        }
    }
}

