/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient;

import com.avaya.generic.channel.testclient.Configuration;
import com.avaya.generic.channel.testclient.PropertyKey;
import com.avaya.generic.channel.testclient.utils.Rest;
import com.avaya.generic.channel.testclient.utils.RestResponse;
import com.avaya.generic.channel.testclient.utils.Utils;
import org.json.JSONObject;

public class GenericChannelAPIClient {
    private final Configuration configuration;

    GenericChannelAPIClient(Configuration configuration) {
        this.configuration = configuration;
    }

    boolean createContact(String contactID, String workRequestID, String extraData) throws Exception {
        JSONObject json = new JSONObject();
        json.putOpt("contactID", contactID);
        json.putOpt("workRequestID", workRequestID);
        json.putOpt("extraData", extraData);
        for (PropertyKey key : PropertyKey.createContactParamsGroup()) {
            this.jsonPutOpt(json, key);
        }
        return this.postToApi("/createcontact", json);
    }

    boolean dropContact(String contactID) throws Exception {
        JSONObject json = new JSONObject();
        json.putOpt("contactID", contactID);
        this.jsonPutOpt(json, PropertyKey.ssoToken);
        return this.postToApi("/dropcontact", json);
    }

    boolean dropAllContacts() throws Exception {
        JSONObject json = new JSONObject();
        json.putOpt("numContactsForClosing", this.configuration.getNumContactsForClosing());
        json.putOpt("numContactsForShowing", this.configuration.getNumContactsForShowing());
        this.jsonPutOpt(json, PropertyKey.ssoToken);
        return this.postToApi("/closeactivecontacts", json);
    }

    boolean getAttributes() throws Exception {
        JSONObject json = new JSONObject();
        this.jsonPutOpt(json, PropertyKey.ssoToken);
        return this.postToApi("/getlistofattributes", json);
    }

    boolean getRoutePoints() throws Exception {
        JSONObject json = new JSONObject();
        this.jsonPutOpt(json, PropertyKey.ssoToken);
        return this.postToApi("/getlistofroutepoints", json);
    }

    boolean getActiveContacts() throws Exception {
        JSONObject json = new JSONObject();
        this.jsonPutOpt(json, PropertyKey.ssoToken);
        json.putOpt("numContactsForClosing", this.configuration.getNumContactsForClosing());
        json.putOpt("numContactsForShowing", this.configuration.getNumContactsForShowing());
        return this.postToApi("/getactivecontacts", json);
    }

    private void jsonPutOpt(JSONObject json, PropertyKey key) throws Exception {
        json.putOpt(key.name(), this.configuration.opt(key));
    }

    private boolean postToApi(String urlSuffix, JSONObject json) throws Exception {
        String url = Utils.buildUrl(this.configuration.getApiHost(), "/services/GenericChannelAPI/api/", urlSuffix);
        RestResponse response = Rest.post(url, json);
        Utils.println(response.toString());
        return response.isOK();
    }
}

