/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient.utils;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;

public class SynchronousTimer {
    private Semaphore semaphore = new Semaphore(0);
    private Timer timer = new Timer();

    public void start(Integer rate) {
        TickTimerTask ttt = new TickTimerTask(this.semaphore);
        int periodInMs = (int)(1000.0 / (double)rate.intValue());
        this.timer.scheduleAtFixedRate((TimerTask)ttt, 0L, (long)periodInMs);
    }

    public void waitForTick() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.timer.cancel();
        this.timer.purge();
    }

    private static class TickTimerTask
    extends TimerTask {
        private Semaphore semaphore;

        public TickTimerTask(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        @Override
        public void run() {
            this.semaphore.release();
        }
    }
}

