/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxws;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.jaxws.JaxWsSoapFaultException;
import org.springframework.remoting.jaxws.LocalJaxWsServiceFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JaxWsPortClientInterceptor
extends LocalJaxWsServiceFactory
implements MethodInterceptor,
BeanClassLoaderAware,
InitializingBean {
    private Service jaxWsService;
    private String portName;
    private String username;
    private String password;
    private String endpointAddress;
    private boolean maintainSession;
    private boolean useSoapAction;
    private String soapActionUri;
    private Map<String, Object> customProperties;
    private WebServiceFeature[] portFeatures;
    private Object[] webServiceFeatures;
    private Class<?> serviceInterface;
    private boolean lookupServiceOnStartup = true;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private QName portQName;
    private Object portStub;
    private final Object preparationMonitor = new Object();

    public void setJaxWsService(Service jaxWsService) {
        this.jaxWsService = jaxWsService;
    }

    public Service getJaxWsService() {
        return this.jaxWsService;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setMaintainSession(boolean maintainSession) {
        this.maintainSession = maintainSession;
    }

    public boolean isMaintainSession() {
        return this.maintainSession;
    }

    public void setUseSoapAction(boolean useSoapAction) {
        this.useSoapAction = useSoapAction;
    }

    public boolean isUseSoapAction() {
        return this.useSoapAction;
    }

    public void setSoapActionUri(String soapActionUri) {
        this.soapActionUri = soapActionUri;
    }

    public String getSoapActionUri() {
        return this.soapActionUri;
    }

    public void setCustomProperties(Map<String, Object> customProperties) {
        this.customProperties = customProperties;
    }

    public Map<String, Object> getCustomProperties() {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, Object>();
        }
        return this.customProperties;
    }

    public void addCustomProperty(String name, Object value) {
        this.getCustomProperties().put(name, value);
    }

    public void setPortFeatures(WebServiceFeature ... features) {
        this.portFeatures = features;
    }

    @Deprecated
    public void setWebServiceFeatures(Object[] webServiceFeatures) {
        this.webServiceFeatures = webServiceFeatures;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("'serviceInterface' must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class<?> getServiceInterface() {
        return this.serviceInterface;
    }

    public void setLookupServiceOnStartup(boolean lookupServiceOnStartup) {
        this.lookupServiceOnStartup = lookupServiceOnStartup;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void afterPropertiesSet() {
        if (this.lookupServiceOnStartup) {
            this.prepare();
        }
    }

    public void prepare() {
        Service serviceToUse;
        Class<?> ifc = this.getServiceInterface();
        if (ifc == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        WebService ann = ifc.getAnnotation(WebService.class);
        if (ann != null) {
            this.applyDefaultsFromAnnotation(ann);
        }
        if ((serviceToUse = this.getJaxWsService()) == null) {
            serviceToUse = this.createJaxWsService();
        }
        this.portQName = this.getQName(this.getPortName() != null ? this.getPortName() : this.getServiceInterface().getName());
        Object stub = this.getPortStub(serviceToUse, this.getPortName() != null ? this.portQName : null);
        this.preparePortStub(stub);
        this.portStub = stub;
    }

    protected void applyDefaultsFromAnnotation(WebService ann) {
        String pn;
        String sn;
        String ns;
        String wsdl;
        if (this.getWsdlDocumentUrl() == null && StringUtils.hasText((String)(wsdl = ann.wsdlLocation()))) {
            try {
                this.setWsdlDocumentUrl(new URL(wsdl));
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Encountered invalid @Service wsdlLocation value [" + wsdl + "]", ex);
            }
        }
        if (this.getNamespaceUri() == null && StringUtils.hasText((String)(ns = ann.targetNamespace()))) {
            this.setNamespaceUri(ns);
        }
        if (this.getServiceName() == null && StringUtils.hasText((String)(sn = ann.serviceName()))) {
            this.setServiceName(sn);
        }
        if (this.getPortName() == null && StringUtils.hasText((String)(pn = ann.portName()))) {
            this.setPortName(pn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPrepared() {
        Object object = this.preparationMonitor;
        synchronized (object) {
            return this.portStub != null;
        }
    }

    protected final QName getPortQName() {
        return this.portQName;
    }

    protected Object getPortStub(Service service, QName portQName) {
        if (this.portFeatures != null || this.webServiceFeatures != null) {
            WebServiceFeature[] portFeaturesToUse = this.portFeatures;
            if (portFeaturesToUse == null) {
                portFeaturesToUse = new WebServiceFeature[this.webServiceFeatures.length];
                for (int i = 0; i < this.webServiceFeatures.length; ++i) {
                    portFeaturesToUse[i] = this.convertWebServiceFeature(this.webServiceFeatures[i]);
                }
            }
            return portQName != null ? service.getPort(portQName, this.getServiceInterface(), portFeaturesToUse) : service.getPort(this.getServiceInterface(), portFeaturesToUse);
        }
        return portQName != null ? service.getPort(portQName, this.getServiceInterface()) : service.getPort(this.getServiceInterface());
    }

    private WebServiceFeature convertWebServiceFeature(Object feature) {
        Assert.notNull((Object)feature, (String)"WebServiceFeature specification object must not be null");
        if (feature instanceof WebServiceFeature) {
            return (WebServiceFeature)feature;
        }
        if (feature instanceof Class) {
            return (WebServiceFeature)BeanUtils.instantiate((Class)((Class)feature));
        }
        if (feature instanceof String) {
            try {
                Class<?> featureClass = this.getBeanClassLoader().loadClass((String)feature);
                return (WebServiceFeature)BeanUtils.instantiate(featureClass);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Could not load WebServiceFeature class [" + feature + "]");
            }
        }
        throw new IllegalArgumentException("Unknown WebServiceFeature specification type: " + feature.getClass());
    }

    protected void preparePortStub(Object stub) {
        String soapActionUri;
        String endpointAddress;
        String password;
        HashMap<String, Object> stubProperties = new HashMap<String, Object>();
        String username = this.getUsername();
        if (username != null) {
            stubProperties.put("javax.xml.ws.security.auth.username", username);
        }
        if ((password = this.getPassword()) != null) {
            stubProperties.put("javax.xml.ws.security.auth.password", password);
        }
        if ((endpointAddress = this.getEndpointAddress()) != null) {
            stubProperties.put("javax.xml.ws.service.endpoint.address", endpointAddress);
        }
        if (this.isMaintainSession()) {
            stubProperties.put("javax.xml.ws.session.maintain", Boolean.TRUE);
        }
        if (this.isUseSoapAction()) {
            stubProperties.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        }
        if ((soapActionUri = this.getSoapActionUri()) != null) {
            stubProperties.put("javax.xml.ws.soap.http.soapaction.uri", soapActionUri);
        }
        stubProperties.putAll(this.getCustomProperties());
        if (!stubProperties.isEmpty()) {
            if (!(stub instanceof BindingProvider)) {
                throw new RemoteLookupFailureException("Port stub of class [" + stub.getClass().getName() + "] is not a customizable JAX-WS stub: it does not implement interface [javax.xml.ws.BindingProvider]");
            }
            ((BindingProvider)stub).getRequestContext().putAll(stubProperties);
        }
    }

    protected Object getPortStub() {
        return this.portStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (AopUtils.isToStringMethod((Method)invocation.getMethod())) {
            return "JAX-WS proxy for port [" + this.getPortName() + "] of service [" + this.getServiceName() + "]";
        }
        Object object = this.preparationMonitor;
        synchronized (object) {
            if (!this.isPrepared()) {
                this.prepare();
            }
        }
        return this.doInvoke(invocation);
    }

    protected Object doInvoke(MethodInvocation invocation) throws Throwable {
        try {
            return this.doInvoke(invocation, this.getPortStub());
        }
        catch (SOAPFaultException ex) {
            throw new JaxWsSoapFaultException(ex);
        }
        catch (ProtocolException ex) {
            throw new RemoteConnectFailureException("Could not connect to remote service [" + this.getEndpointAddress() + "]", (Throwable)ex);
        }
        catch (WebServiceException ex) {
            throw new RemoteAccessException("Could not access remote service at [" + this.getEndpointAddress() + "]", (Throwable)ex);
        }
    }

    protected Object doInvoke(MethodInvocation invocation, Object portStub) throws Throwable {
        Method method = invocation.getMethod();
        try {
            return method.invoke(portStub, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (Throwable ex) {
            throw new RemoteProxyFailureException("Invocation of stub method failed: " + method, ex);
        }
    }
}

