/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient;

import com.avaya.generic.channel.testclient.utils.ExternalException;
import com.avaya.generic.channel.testclient.utils.FileIO;
import com.avaya.generic.channel.testclient.utils.Rest;
import com.avaya.generic.channel.testclient.utils.RestResponse;
import com.avaya.generic.channel.testclient.utils.Utils;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ExceptionLogger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class EventListener {
    private final ServerBootstrap serverBootstrap;
    private HttpServer server = null;
    private final AtomicBoolean eventsVisible = new AtomicBoolean(false);
    private final AtomicReference<FileIO> fileIO = new AtomicReference<Object>(null);
    private final AtomicReference<String> subscriptionId = new AtomicReference<Object>(null);
    private final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("HH:mm:ss");

    public EventListener() {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(5000).setTcpNoDelay(true).build();
        this.serverBootstrap = ServerBootstrap.bootstrap().setServerInfo("GenericChannelAPITestClient/2.0").setSocketConfig(socketConfig).setSslContext(null).setExceptionLogger(new ExceptionLoggerImpl()).registerHandler("*", new HttpRequestHandlerImpl());
    }

    synchronized void start(String host, int port) throws IOException, ExternalException, NoSuchAlgorithmException, KeyManagementException {
        String url;
        RestResponse response;
        this.hideEvents();
        if (this.server != null && this.server.getLocalPort() != port) {
            Utils.println("Shutting down EventListener on port %d...", this.server.getLocalPort());
            this.shutdown();
            this.server = null;
        }
        if (this.server == null) {
            Utils.println("Starting EventListener on port %d...", port);
            this.server = this.serverBootstrap.setListenerPort(port).create();
            this.server.start();
        }
        if (!(response = Rest.execute(new HttpPost(url = Utils.buildUrl(host + ":" + port)))).isOK()) {
            throw new ExternalException("EventListener check failed. Check your firewall or try another port.");
        }
        if (!this.getSignature().equals(response.getContent())) {
            throw new ExternalException("Port %d is used by another program", port);
        }
    }

    void showEvents(FileIO fileIO, String subscriptionId) {
        this.eventsVisible.set(true);
        this.fileIO.set(fileIO);
        this.subscriptionId.set(subscriptionId);
    }

    void hideEvents() {
        this.eventsVisible.set(false);
        this.fileIO.set(null);
        this.subscriptionId.set(null);
    }

    synchronized void shutdown() {
        this.hideEvents();
        if (this.server != null) {
            this.server.shutdown(10L, TimeUnit.SECONDS);
            this.server = null;
        }
    }

    private void printEvent(String event) {
        String formattedEvent;
        String publicationTimeStamp;
        block11: {
            publicationTimeStamp = "";
            formattedEvent = "";
            try {
                JSONObject json = new JSONObject(event);
                String subscriptionId = this.subscriptionId.get();
                if (Utils.isNotEmpty(subscriptionId) && !subscriptionId.equals(json.optString("subscriptionId", ""))) {
                    return;
                }
                try {
                    publicationTimeStamp = this.DATEFORMAT.format(new Date(json.getLong("publicationTimestamp")));
                }
                catch (Exception ex) {
                    publicationTimeStamp = "";
                }
                String family = json.getString("family");
                String type = json.getString("type");
                String theContactId = json.getJSONObject("eventBody").getString("ContactId");
                String theResourceID = "";
                theResourceID = "";
                if (type.equalsIgnoreCase("CONTACT_ANSWERED")) {
                    try {
                        theResourceID = json.getJSONObject("eventBody").getString("NativeResourceId");
                    }
                    catch (Exception e) {
                        theResourceID = event;
                    }
                    formattedEvent = String.format("%s.%s ContactId = %s  ResourceID = %s", family, type, theContactId, theResourceID);
                    break block11;
                }
                formattedEvent = String.format("%s.%s ContactId = %s", family, type, theContactId);
            }
            catch (Exception ex) {
                formattedEvent = event;
            }
        }
        String arrivalTimeStamp = this.DATEFORMAT.format(new Date());
        String line = "";
        line = Utils.isNotEmpty(publicationTimeStamp) ? String.format("[pub %s, arr %s] %s", publicationTimeStamp, arrivalTimeStamp, formattedEvent) : String.format("[arr %s] %s", arrivalTimeStamp, formattedEvent);
        Utils.println(line);
        FileIO fileIO = this.fileIO.get();
        if (fileIO != null) {
            try {
                fileIO.writeLine(line);
            }
            catch (Exception ex) {
                Utils.printException(EventListener.class.getSimpleName(), ex);
            }
        }
    }

    private String getSignature() {
        return String.format("~~~ EventListener %s OK ~~~", Integer.toHexString(this.hashCode()));
    }

    private class HttpRequestHandlerImpl
    implements HttpRequestHandler {
        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            if (EventListener.this.eventsVisible.get() && request instanceof HttpEntityEnclosingRequest) {
                String entityContent = "";
                HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
                if (entity != null) {
                    try {
                        entityContent = EntityUtils.toString(entity);
                    }
                    catch (Exception ex) {
                        entityContent = "";
                    }
                    if (entityContent == null) {
                        entityContent = "";
                    }
                    EventListener.this.printEvent(entityContent);
                }
            }
            response.setStatusCode(200);
            response.setEntity(new StringEntity(EventListener.this.getSignature()));
        }
    }

    private static class ExceptionLoggerImpl
    implements ExceptionLogger {
        private ExceptionLoggerImpl() {
        }

        @Override
        public void log(Exception ex) {
            if (!(ex instanceof SocketTimeoutException || ex instanceof ConnectionClosedException || ex instanceof SocketException && Utils.isNotEmpty(ex.getMessage()) && ex.getMessage().toLowerCase().contains("socket closed"))) {
                Utils.printException(EventListener.class.getSimpleName(), ex);
            }
        }
    }
}

