/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public enum PropertyKey {
    authorizationHost(0),
    clientId(0),
    keyStore(0),
    keyStorePassword(0),
    keyAlias(0),
    trustStore(0),
    trustStorePassword(0),
    username(0),
    password(0),
    authPort(0),
    eventConnectorHost(1),
    eventFamily(1),
    eventTypes(1),
    eventCallbackHost(1),
    eventCallbackPort(1),
    eventMetadata(1),
    eventSubscription(1),
    apiHost(2),
    contactIdPrefix(2),
    coreDataServiceHost(2),
    ssoToken(3),
    emailAddress(3),
    telephoneNumber(3),
    socialHandle(3),
    socialPlatform(3),
    crmId(3),
    identifier(3),
    attributes(3),
    routePoint(3),
    priority(3),
    firstName(3),
    lastName(3),
    destinationAddress(3),
    isUseRPAsCalledParty(3),
    overwriteContextDetails(3),
    pageTopic(3),
    numContactsForClosing(3),
    numContactsForShowing(3),
    accountId(3),
    accountType(3);

    private final Integer groupId;

    private PropertyKey(int groupId) {
        this.groupId = groupId;
    }

    static PropertyKey byStringIgnoreCase(String stringPropertyKey) {
        for (PropertyKey propertyKey : PropertyKey.values()) {
            if (!propertyKey.name().equalsIgnoreCase(stringPropertyKey)) continue;
            return propertyKey;
        }
        return null;
    }

    static EnumSet<PropertyKey> authorizationGroup() {
        return PropertyKey.group(0);
    }

    static EnumSet<PropertyKey> eventingGroup() {
        return PropertyKey.group(1);
    }

    static EnumSet<PropertyKey> createContactGroup() {
        return PropertyKey.group(2, 3);
    }

    static EnumSet<PropertyKey> createContactParamsGroup() {
        return PropertyKey.group(3);
    }

    private static EnumSet<PropertyKey> group(Integer ... groupId) {
        List<Integer> groupIdList = Arrays.asList(groupId);
        EnumSet<PropertyKey> result = EnumSet.noneOf(PropertyKey.class);
        for (PropertyKey propertyKey : PropertyKey.values()) {
            if (!groupIdList.contains(propertyKey.groupId)) continue;
            result.add(propertyKey);
        }
        return result;
    }
}

