/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient;

import com.avaya.generic.channel.testclient.Authorization;
import com.avaya.generic.channel.testclient.CommandName;
import com.avaya.generic.channel.testclient.Configuration;
import com.avaya.generic.channel.testclient.CoreDataServiceClient;
import com.avaya.generic.channel.testclient.EventListener;
import com.avaya.generic.channel.testclient.EventingConnectorClient;
import com.avaya.generic.channel.testclient.GenericChannelAPIClient;
import com.avaya.generic.channel.testclient.PropertyKey;
import com.avaya.generic.channel.testclient.utils.ExternalException;
import com.avaya.generic.channel.testclient.utils.FileIO;
import com.avaya.generic.channel.testclient.utils.Rest;
import com.avaya.generic.channel.testclient.utils.RestResponse;
import com.avaya.generic.channel.testclient.utils.SynchronousTimer;
import com.avaya.generic.channel.testclient.utils.Utils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.json.JSONObject;

class CommandProcessor {
    private final GenericChannelAPIClient gcapiClient;
    private final CoreDataServiceClient \u0441oreDataServiceClientClient;
    private final EventingConnectorClient eventingConnectorClient;
    private final EventListener eventListener;
    private final Configuration configuration;
    private static final Option numberOption = Option.builder("n").hasArg().argName("number").desc("Number of contacts to create").build();
    private static final Option rateOption = Option.builder("r").hasArg().argName("rate").desc("Request rate in contacts per second, default is 1").build();
    private static final Option contactIDOption = Option.builder("i").hasArg().argName("contactID").desc("contactID prefix").build();
    private static final Option contextIDOption = Option.builder("c").hasArg().argName("contextID").desc("Context ID").build();
    private static final Option dataOption = Option.builder("d").hasArg().argName("extraData").desc("extra Data field").build();

    CommandProcessor(Configuration configuration, EventListener eventListener) {
        this.eventListener = eventListener;
        this.gcapiClient = new GenericChannelAPIClient(configuration);
        this.\u0441oreDataServiceClientClient = new CoreDataServiceClient(configuration);
        this.eventingConnectorClient = new EventingConnectorClient(configuration);
        this.configuration = configuration;
    }

    void execute(String line) throws Exception {
        String[] splittedLine = line.split("\\s+");
        if (splittedLine.length == 0) {
            return;
        }
        CommandName commandName = CommandName.byStringIgnoreCase(splittedLine[0]);
        if (commandName == null) {
            Utils.println("Unknown command");
            return;
        }
        String[] args = new String[splittedLine.length - 1];
        for (int i = 1; i < splittedLine.length; ++i) {
            args[i - 1] = splittedLine[i];
        }
        this.configuration.reload();
        switch (commandName) {
            case STATUS: {
                this.status();
                break;
            }
            case GETTOKEN: {
                this.getToken();
                break;
            }
            case GETBEARERTOKEN: {
                this.getBearerToken();
                break;
            }
            case GETPUBLICTOKEN: {
                this.getPublicToken();
                break;
            }
            case CREATE: {
                this.create(args);
                break;
            }
            case DROP: {
                this.drop(args);
                break;
            }
            case ATTRIBUTES: {
                this.gcapiClient.getAttributes();
                break;
            }
            case ROUTEPOINTS: {
                this.gcapiClient.getRoutePoints();
                break;
            }
            case EVENTS: {
                this.events(args);
                break;
            }
            case CREATECONTEXT: {
                this.get\u0421ontextID(args);
                break;
            }
            case DROPALLCONTACTS: {
                this.dropAllContacts();
                break;
            }
            case GETACTIVECONTACTS: {
                this.getActiveContacts();
                break;
            }
            default: {
                Utils.println("Unknown command");
            }
        }
    }

    void status() throws ConfigurationException {
        ArrayList<EnumSet<PropertyKey>> keySetList = new ArrayList<EnumSet<PropertyKey>>(3);
        keySetList.add(PropertyKey.authorizationGroup());
        keySetList.add(PropertyKey.eventingGroup());
        keySetList.add(PropertyKey.createContactGroup());
        for (EnumSet enumSet : keySetList) {
            int maxLen = 0;
            for (PropertyKey key : enumSet) {
                if (key.name().length() <= maxLen) continue;
                maxLen = key.name().length();
            }
            for (PropertyKey key : enumSet) {
                String value = this.configuration.opt(key);
                if (key == PropertyKey.ssoToken) {
                    value = Utils.trimTo16chars(value);
                }
                Utils.print(key.name());
                for (int i = key.name().length(); i < maxLen; ++i) {
                    Utils.print(" ");
                }
                if (value != null) {
                    Utils.println(" = '%s'", value);
                    continue;
                }
                Utils.println(" not set");
            }
            Utils.printSeparator();
        }
    }

    private void getToken() throws Exception {
        String ssoToken = Authorization.getAccessToken(this.configuration).toString();
        this.configuration.setSsoToken(ssoToken);
    }

    private void getBearerToken() throws Exception {
        String ssoToken = Authorization.getAccessToken(this.configuration).getTokenType() + " " + Authorization.getAccessToken(this.configuration).toString();
        this.configuration.setSsoToken(ssoToken);
    }

    private void getPublicToken() throws Exception {
        String username = this.configuration.getUesrname();
        String password = this.configuration.getPassword();
        StringBuilder stringRequest = new StringBuilder(256).append("grant_type=password&username=").append(username).append("&password=").append(password);
        String url = Utils.buildHttpSecureUrl(this.configuration.getAuthorizationHost() + ":" + this.configuration.getAuthPort(), "/services/AuthorizationService/token");
        HttpPost request = new HttpPost(url);
        request.addHeader("content-type", "application/x-www-form-urlencoded");
        StringEntity stringEntity = new StringEntity(stringRequest.toString());
        request.setEntity(stringEntity);
        try {
            RestResponse response = Rest.execute(request);
            JsonParser parser = new JsonParser();
            JsonObject responseJson = parser.parse(response.getContent()).getAsJsonObject();
            String ssoToken = responseJson.get("access_token").getAsString();
            this.configuration.setSsoToken(ssoToken);
        }
        catch (Exception ex) {
            Utils.println("Incorrect credentials");
        }
    }

    private void create(String[] args) throws Exception {
        Options options = new Options().addOption(contactIDOption).addOption(contextIDOption).addOption(numberOption).addOption(rateOption).addOption(dataOption);
        String[] examples = new String[]{"create -n integer [-r integer] [>|>> file]", "create [-r integer] << file", "create contactId", "create -c contextID -i contactID", "create -d key:value -i contactID -c contextID"};
        try {
            CommandLine cmdLine = new DefaultParser().parse(options, args);
            if (cmdLine.hasOption("n")) {
                this.createTimeStampedImpl(cmdLine);
            } else {
                this.createAndDropImpl(CommandName.CREATE, cmdLine);
            }
        }
        catch (ParseException pe) {
            Utils.println(pe.getMessage());
            this.printUsage(examples, options);
        }
    }

    private void get\u0421ontextID(String[] args) {
        Options options = new Options().addOption(contactIDOption);
        String[] examples = new String[]{"createcontext contextId"};
        try {
            CommandLine cmdLine = new DefaultParser().parse(options, args);
            this.createAndDropImpl(CommandName.CREATECONTEXT, cmdLine);
        }
        catch (ParseException pe) {
            Utils.println(pe.getMessage());
            this.printUsage(examples, options);
        }
        catch (Exception ex) {
            Utils.println("CommandProcessor.class.getName()" + ex.getMessage());
        }
    }

    private void drop(String[] args) throws Exception {
        Options options = new Options().addOption(rateOption);
        String[] examples = new String[]{"drop [-r integer] << file", "drop contactId"};
        try {
            CommandLine cmdLine = new DefaultParser().parse(options, args);
            this.createAndDropImpl(CommandName.DROP, cmdLine);
        }
        catch (ParseException pe) {
            Utils.println(pe.getMessage());
            this.printUsage(examples, options);
        }
    }

    private void dropAllContacts() throws Exception {
        try {
            this.gcapiClient.dropAllContacts();
        }
        catch (Exception e) {
            Utils.println(ExceptionUtils.getStackTrace(e));
        }
    }

    private void getActiveContacts() throws Exception {
        try {
            this.gcapiClient.getActiveContacts();
        }
        catch (Exception e) {
            Utils.println(ExceptionUtils.getStackTrace(e));
        }
    }

    private void createAndDropImpl(CommandName commandName, CommandLine cmdLine) throws Exception {
        block16: {
            SynchronousTimer timer = new SynchronousTimer();
            BufferedReader reader = null;
            try {
                Integer rate = this.getOptionInteger(cmdLine, "r");
                String contactId = null;
                String contextID = null;
                String extraData = null;
                List<String> leftOverArgs = cmdLine.getArgList();
                switch (leftOverArgs.size()) {
                    case 0: {
                        if (cmdLine.hasOption("c") && cmdLine.hasOption("i") && cmdLine.hasOption("d")) {
                            contextID = cmdLine.getOptionValue("c");
                            contactId = cmdLine.getOptionValue("i");
                            extraData = cmdLine.getOptionValue("d");
                            break;
                        }
                        if (!cmdLine.hasOption("i") || !cmdLine.hasOption("c")) break;
                        contactId = cmdLine.getOptionValue("i");
                        contextID = cmdLine.getOptionValue("c");
                        break;
                    }
                    case 1: {
                        contactId = leftOverArgs.get(0);
                        break;
                    }
                    case 2: {
                        this.assertTrue("<<".equals(leftOverArgs.get(0)));
                        reader = new BufferedReader(new FileReader(leftOverArgs.get(1)));
                        break;
                    }
                    default: {
                        throw new ParseException("Too many arguments");
                    }
                }
                if (reader != null) {
                    rate = rate != null ? rate : 1;
                    this.assertTrue(rate > 0);
                    timer.start(rate);
                    int linesCounter = 0;
                    while ((contactId = reader.readLine()) != null) {
                        if (!this.validateContactId(contactId = contactId.trim())) continue;
                        timer.waitForTick();
                        this.finishCreateOrDrop(commandName, contactId, "", "");
                        ++linesCounter;
                    }
                    if (linesCounter == 0) {
                        Utils.println("No contact ID found in the file");
                    }
                    break block16;
                }
                if (contactId != null) {
                    this.assertTrue(rate == null);
                    this.finishCreateOrDrop(commandName, contactId, contextID != null ? contextID : "", extraData != null ? extraData : "");
                    break block16;
                }
                throw new ParseException("Too few arguments");
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(nfe.getMessage());
            }
            finally {
                timer.stop();
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void finishCreateOrDrop(CommandName commandName, String contactId, String contextID, String extraData) throws Exception {
        switch (commandName) {
            case CREATE: {
                this.gcapiClient.createContact(contactId, contextID, extraData);
                break;
            }
            case DROP: {
                this.gcapiClient.dropContact(contactId);
                break;
            }
            case CREATECONTEXT: {
                this.\u0441oreDataServiceClientClient.get\u0421ontextID(contextID, extraData.trim());
            }
            default: {
                Utils.println("Unknown command");
            }
        }
    }

    private void createTimeStampedImpl(CommandLine cmdLine) throws Exception {
        SynchronousTimer timer = new SynchronousTimer();
        BufferedWriter writer = null;
        try {
            Integer number = this.getOptionInteger(cmdLine, "n");
            this.assertTrue(number != null && number > 0);
            Integer rate = this.getOptionInteger(cmdLine, "r");
            rate = rate != null ? rate : 1;
            this.assertTrue(rate > 0);
            String optionalContactIdPrefix = cmdLine.getOptionValue("i");
            List<String> leftOverArgs = cmdLine.getArgList();
            block2 : switch (leftOverArgs.size()) {
                case 0: {
                    break;
                }
                case 2: {
                    switch (leftOverArgs.get(0)) {
                        case ">": {
                            writer = new BufferedWriter(new FileWriter(leftOverArgs.get(1), false));
                            break block2;
                        }
                        case ">>": {
                            writer = new BufferedWriter(new FileWriter(leftOverArgs.get(1), true));
                            break block2;
                        }
                    }
                    this.assertTrue(false);
                    break;
                }
                default: {
                    this.assertTrue(false);
                }
            }
            double expectedTimeInSec = (double)number.intValue() * (1.0 / (double)rate.intValue());
            if (expectedTimeInSec > 10.0) {
                Utils.println("Expected time is %.1f s", expectedTimeInSec);
            }
            timer.start(rate);
            for (int i = 0; i < number; ++i) {
                timer.waitForTick();
                String contactIdPrefix = Utils.isNullOrEmpty(optionalContactIdPrefix) ? this.configuration.opt(PropertyKey.contactIdPrefix) : optionalContactIdPrefix;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMMddHHmmssSSS", Locale.ENGLISH);
                String contactId = (contactIdPrefix != null ? contactIdPrefix : "") + dateFormat.format(new Date());
                if (!this.gcapiClient.createContact(contactId, "", "") || writer == null) continue;
                writer.write(contactId);
                writer.newLine();
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(nfe.getMessage());
        }
        finally {
            timer.stop();
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void events(String[] args) throws Exception {
        Options options = new Options().addOption(Option.builder("s").hasArg().argName("subscription operation").desc("new|del|query|renew").build());
        String[] examples = new String[]{"events", "events >|>> file", "events -s new|del|query|renew"};
        try (FileIO fileIO = new FileIO();){
            String[] argsNoFile = fileIO.openForWriting(args);
            CommandLine cmdLine = new DefaultParser().parse(options, argsNoFile);
            this.assertTrue(cmdLine.getArgList().isEmpty());
            if (cmdLine.hasOption('s')) {
                String operation;
                this.assertFalse(fileIO.hasFile());
                switch (operation = cmdLine.getOptionValue('s').toLowerCase()) {
                    case "new": {
                        this.newSubscription();
                        break;
                    }
                    case "del": {
                        this.eventingConnectorClient.deleteSubscription();
                        break;
                    }
                    case "query": {
                        this.eventingConnectorClient.querySubscription();
                        break;
                    }
                    case "renew": {
                        this.eventingConnectorClient.renewSubscription();
                        break;
                    }
                    default: {
                        throw new ParseException("Illegal argument of the -s option");
                    }
                }
            } else {
                this.listenToEvents(fileIO);
            }
        }
    }

    private void newSubscription() throws ExternalException, IOException, NoSuchAlgorithmException, KeyManagementException, ConfigurationException {
        String eventSubscription = this.configuration.opt(PropertyKey.eventSubscription);
        if (Utils.isNotEmpty(eventSubscription)) {
            throw new ExternalException("Please delete the current subscription first");
        }
        String callbackHost = this.configuration.getEventCallbackHost();
        int callbackPort = Integer.parseInt(this.configuration.getEventCallbackPort());
        this.eventListener.start(callbackHost, callbackPort);
        this.eventingConnectorClient.newSubscription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenToEvents(FileIO fileIO) throws IOException, ExternalException, KeyManagementException, NoSuchAlgorithmException, ConfigurationException {
        try {
            PropertyKey[] keys;
            JSONObject json = new JSONObject(this.configuration.getEventSubscription());
            String subscriptionId = json.getString("id");
            String callbackHost = json.getString(PropertyKey.eventCallbackHost.name());
            int callbackPort = json.getInt(PropertyKey.eventCallbackPort.name());
            this.eventListener.start(callbackHost, callbackPort);
            Utils.println("Listening to events.");
            for (PropertyKey key : keys = new PropertyKey[]{PropertyKey.eventFamily, PropertyKey.eventTypes, PropertyKey.eventMetadata}) {
                String value = json.optString(key.name(), "");
                if (!Utils.isNotEmpty(value)) continue;
                Utils.println("  %s: %s", key.name().substring(5), value);
            }
            Utils.println("Press Enter to stop.");
            this.eventListener.showEvents(fileIO, subscriptionId);
            Utils.readLine();
        }
        finally {
            this.eventListener.hideEvents();
        }
    }

    private Integer getOptionInteger(CommandLine cmdLine, String option) {
        String str = cmdLine.getOptionValue(option);
        return str != null ? Integer.valueOf(Integer.parseInt(str)) : null;
    }

    private void assertTrue(boolean conditionAboutArgs) throws ParseException {
        if (!conditionAboutArgs) {
            throw new ParseException("Illegal arguments");
        }
    }

    private void assertFalse(boolean conditionAboutArgs) throws ParseException {
        if (conditionAboutArgs) {
            throw new ParseException("Illegal arguments");
        }
    }

    private void printUsage(String[] examples, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        StringBuilder sb = new StringBuilder();
        for (String example : examples) {
            if (Utils.isNullOrEmpty(sb.toString())) {
                sb = new StringBuilder();
            } else {
                sb.append("       ");
            }
            sb.append(example).append("\n");
        }
        sb.append("options:");
        formatter.printHelp(sb.toString(), options);
    }

    private boolean validateContactId(String contactId) {
        return !"".equals(contactId);
    }
}

