/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient;

import com.avaya.generic.channel.testclient.Configuration;
import com.avaya.generic.channel.testclient.PropertyKey;
import com.avaya.generic.channel.testclient.utils.ExternalException;
import com.avaya.generic.channel.testclient.utils.Rest;
import com.avaya.generic.channel.testclient.utils.RestResponse;
import com.avaya.generic.channel.testclient.utils.Utils;
import java.io.IOException;
import net.minidev.json.JSONArray;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.json.JSONObject;

public class EventingConnectorClient {
    private final Configuration configuration;
    private static final String SUBSCRIPTIONS_PATH = "/services/EventingConnector/subscriptions";

    EventingConnectorClient(Configuration configuration) {
        this.configuration = configuration;
    }

    void newSubscription() throws ConfigurationException, ExternalException, IOException {
        String connectorHost;
        String requestUrl;
        RestResponse response;
        String callbackHost = this.configuration.getEventCallbackHost();
        int callbackPort = Integer.parseInt(this.configuration.getEventCallbackPort());
        String family = this.configuration.getEventFamily();
        String[] eventTypes = this.optEventTypesAsArray();
        String metadata = this.configuration.opt(PropertyKey.eventMetadata);
        JSONObject filter = new JSONObject();
        JSONArray criteria = new JSONArray();
        int criteriaIndex = 0;
        JSONObject requestJson = new JSONObject().put("family", family).putOpt("eventTypes", eventTypes).put("callbackUrl", Utils.buildUrl(callbackHost + ":" + callbackPort)).put("callbackContentType", "application/json");
        if (Utils.isNotEmpty(metadata)) {
            String[] parts;
            for (String part : parts = metadata.split("\\s*,\\s*")) {
                String[] keyValuePair = part.split("\\s*=\\s*");
                JSONObject criterias = new JSONObject();
                if (keyValuePair.length != 2 || !Utils.isNotEmpty(keyValuePair[0]) || !Utils.isNotEmpty(keyValuePair[1])) {
                    throw new ExternalException("%s: '%s' is not a key=value pair", new Object[]{PropertyKey.eventMetadata, part});
                }
                criterias.put("key", keyValuePair[0]);
                criterias.put("value", keyValuePair[1]);
                criteria.add(criteriaIndex++, criterias);
                filter.putOpt("criteria", criteria);
            }
            requestJson.put("filter", filter);
        }
        if ((response = Rest.post(requestUrl = Utils.buildUrl(connectorHost = this.configuration.getEventConnectorHost(), SUBSCRIPTIONS_PATH), requestJson)).isOK()) {
            String id = new JSONObject(response.getContent()).getString("subscriptionId");
            Utils.println("New subscription created");
            JSONObject subscriptionSnapshotJson = new JSONObject().put("id", id).put(PropertyKey.eventConnectorHost.name(), connectorHost).put(PropertyKey.eventFamily.name(), family).putOpt(PropertyKey.eventTypes.name(), eventTypes).put(PropertyKey.eventCallbackHost.name(), callbackHost).put(PropertyKey.eventCallbackPort.name(), callbackPort);
            if (Utils.isNotEmpty(metadata)) {
                subscriptionSnapshotJson.put(PropertyKey.eventMetadata.name(), metadata);
            }
            this.configuration.setEventSubscription(subscriptionSnapshotJson.toString());
        } else {
            Utils.println(response.toString());
        }
    }

    void deleteSubscription() throws Exception {
        RestResponse response = Rest.delete(this.getSubscriptionControlUrl());
        if (response.isOK()) {
            Utils.println("Subscription deleted");
            this.configuration.setEventSubscription("");
            return;
        }
        if (response.getCode() == 404) {
            try {
                String message = new JSONObject(response.getContent()).getString("message");
                if (Utils.isNotEmpty(message) && message.toLowerCase().contains("not found")) {
                    Utils.println("Subscription not found");
                    this.configuration.setEventSubscription("");
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Utils.println(response.toString());
    }

    void querySubscription() throws Exception {
        RestResponse response = Rest.get(this.getSubscriptionControlUrl());
        Utils.println(response.toString());
    }

    void renewSubscription() throws Exception {
        RestResponse response = Rest.put(this.getSubscriptionControlUrl());
        if (response.isOK()) {
            Utils.println("Subscription renewed");
        } else {
            Utils.println(response.toString());
        }
    }

    private String getSubscriptionControlUrl() throws ExternalException, ConfigurationException {
        JSONObject json = new JSONObject(this.configuration.getEventSubscription());
        String eventConnectorHost = json.getString(PropertyKey.eventConnectorHost.name());
        String id = json.getString("id");
        return Utils.buildUrl(eventConnectorHost, SUBSCRIPTIONS_PATH, id);
    }

    private String[] optEventTypesAsArray() throws ConfigurationException {
        String eventTypes = this.configuration.opt(PropertyKey.eventTypes);
        if (Utils.isNotEmpty(eventTypes)) {
            return eventTypes.split("\\s*,\\s*");
        }
        if (eventTypes != null) {
            return new String[0];
        }
        return null;
    }
}

