/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.throwingproviders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Message;
import com.google.inject.throwingproviders.CheckedProvider;
import com.google.inject.throwingproviders.CheckedProviderMethod;
import com.google.inject.throwingproviders.CheckedProvides;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

final class CheckedProviderMethodsModule
implements Module {
    private static final Key<Logger> LOGGER_KEY = Key.get(Logger.class);
    private final Object delegate;
    private final TypeLiteral<?> typeLiteral;

    private CheckedProviderMethodsModule(Object delegate) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.typeLiteral = TypeLiteral.get(this.delegate.getClass());
    }

    static Module forModule(Module module) {
        if (module instanceof CheckedProviderMethodsModule) {
            return Modules.EMPTY_MODULE;
        }
        return new CheckedProviderMethodsModule(module);
    }

    @Override
    public synchronized void configure(Binder binder) {
        for (CheckedProviderMethod<?> throwingProviderMethod : this.getProviderMethods(binder)) {
            throwingProviderMethod.configure(binder);
        }
    }

    List<CheckedProviderMethod<?>> getProviderMethods(Binder binder) {
        ArrayList<CheckedProviderMethod<?>> result = Lists.newArrayList();
        for (Class<?> c = this.delegate.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                CheckedProvides checkedProvides = method.getAnnotation(CheckedProvides.class);
                if (checkedProvides == null) continue;
                result.add(this.createProviderMethod(binder, method, checkedProvides));
            }
        }
        return result;
    }

    <T> CheckedProviderMethod<T> createProviderMethod(Binder binder, Method method, CheckedProvides checkedProvides) {
        Class<? extends CheckedProvider> throwingProvider = checkedProvides.value();
        binder = binder.withSource(method);
        Errors errors = new Errors(method);
        ArrayList<Dependency<?>> dependencies = Lists.newArrayList();
        ArrayList<Provider<?>> parameterProviders = Lists.newArrayList();
        List<TypeLiteral<?>> parameterTypes = this.typeLiteral.getParameterTypes(method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Key<Object> key = this.getKey(errors, parameterTypes.get(i), method, parameterAnnotations[i]);
            if (key.equals(LOGGER_KEY)) {
                Key<Logger> loggerKey = Key.get(Logger.class, UniqueAnnotations.create());
                binder.bind(loggerKey).toProvider(new LogProvider(method));
                key = loggerKey;
            }
            dependencies.add(Dependency.get(key));
            parameterProviders.add(binder.getProvider(key));
        }
        TypeLiteral<?> returnType = this.typeLiteral.getReturnType(method);
        List<TypeLiteral<?>> exceptionTypes = this.typeLiteral.getExceptionTypes(method);
        Key<?> key = this.getKey(errors, returnType, method, method.getAnnotations());
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, method.getAnnotations());
        for (Message message : errors.getMessages()) {
            binder.addError(message);
        }
        return new CheckedProviderMethod(key, method, this.delegate, ImmutableSet.copyOf(dependencies), parameterProviders, scopeAnnotation, throwingProvider, exceptionTypes, checkedProvides.scopeExceptions());
    }

    <T> Key<T> getKey(Errors errors, TypeLiteral<T> type, Member member, Annotation[] annotations) {
        Annotation bindingAnnotation = Annotations.findBindingAnnotation(errors, member, annotations);
        return bindingAnnotation == null ? Key.get(type) : Key.get(type, bindingAnnotation);
    }

    public boolean equals(Object o) {
        return o instanceof CheckedProviderMethodsModule && ((CheckedProviderMethodsModule)o).delegate == this.delegate;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private static final class LogProvider
    implements Provider<Logger> {
        private final String name;

        public LogProvider(Method method) {
            String string = String.valueOf(String.valueOf(method.getDeclaringClass().getName()));
            String string2 = String.valueOf(String.valueOf(method.getName()));
            this.name = new StringBuilder(1 + string.length() + string2.length()).append(string).append(".").append(string2).toString();
        }

        @Override
        public Logger get() {
            return Logger.getLogger(this.name);
        }
    }
}

