/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.MediaType;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

public class FixedContentNegotiationStrategy
implements ContentNegotiationStrategy {
    private static final Log logger = LogFactory.getLog(FixedContentNegotiationStrategy.class);
    private final MediaType defaultContentType;

    public FixedContentNegotiationStrategy(MediaType defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    @Override
    public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) {
        if (logger.isDebugEnabled()) {
            logger.debug("Requested media types is " + this.defaultContentType + " (based on default MediaType)");
        }
        return Collections.singletonList(this.defaultContentType);
    }
}

