/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient.utils;

import com.avaya.generic.channel.testclient.utils.ExternalException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class Utils {
    private static final Pattern httpPattern = Pattern.compile("^http://", 2);
    private static final Pattern httpSecurePattern = Pattern.compile("^https://", 2);
    private static final AtomicReference<LastCall> lastCall = new AtomicReference<LastCall>(LastCall.NONE);

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static String buildUrl(String ... parts) {
        String url = Utils.joinUrlParts(parts);
        if (httpPattern.matcher(url).lookingAt() || httpSecurePattern.matcher(url).lookingAt()) {
            return url;
        }
        return "http://" + url;
    }

    public static String buildHttpSecureUrl(String ... parts) {
        String url = Utils.joinUrlParts(parts);
        if (httpPattern.matcher(url).lookingAt()) {
            return httpPattern.matcher(url).replaceFirst("https://");
        }
        if (httpSecurePattern.matcher(url).lookingAt()) {
            return url;
        }
        return "https://" + url;
    }

    public static String readLine() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        lastCall.set(LastCall.READ_LINE);
        String line = reader.readLine();
        if (line != null && !line.trim().isEmpty()) {
            return line.trim();
        }
        lastCall.set(LastCall.READ_EMPTY_LINE);
        return "";
    }

    public static synchronized void print(String format, Object ... args) {
        if (format != null) {
            System.out.printf(format, args);
        } else {
            System.out.print("null");
        }
        lastCall.set(LastCall.PRINT);
    }

    public static synchronized void print(String s) {
        if (s != null) {
            System.out.print(s);
        } else {
            System.out.print("null");
        }
        lastCall.set(LastCall.PRINT);
    }

    public static synchronized void println(String format, Object ... args) {
        Utils.print(format, args);
        System.out.println();
        lastCall.set(LastCall.PRINT_LN);
    }

    public static synchronized void println(String s) {
        Utils.print(s);
        System.out.println();
        lastCall.set(LastCall.PRINT_LN);
    }

    public static synchronized void println() {
        System.out.println();
        lastCall.set(LastCall.PRINT_LN);
    }

    public static synchronized void printSeparator() {
        LastCall localLastCall = lastCall.get();
        if (localLastCall != null) {
            switch (localLastCall) {
                case PRINT: {
                    System.out.println();
                    System.out.println();
                    break;
                }
                case PRINT_LN: 
                case READ_LINE: {
                    System.out.println();
                    break;
                }
            }
        }
        lastCall.set(LastCall.NONE);
    }

    public static synchronized void printException(Exception e) {
        Utils.printSeparator();
        if (Utils.isNotEmpty(e.getMessage())) {
            if (e instanceof ExternalException) {
                Utils.println(e.getMessage());
            } else {
                String className = e.getClass().getSimpleName();
                Utils.println("%s: %s", className, e.getMessage());
            }
        } else {
            lastCall.set(LastCall.PRINT_LN);
        }
        Utils.printSeparator();
    }

    public static synchronized void printException(String producer, Exception e) {
        Utils.printSeparator();
        if (Utils.isNotEmpty(e.getMessage())) {
            if (e instanceof ExternalException) {
                Utils.println("%s: %s", producer, e.getMessage());
            } else {
                String className = e.getClass().getSimpleName();
                Utils.println("%s: %s: %s", producer, className, e.getMessage());
            }
        } else {
            Utils.print("%s: ", producer);
            lastCall.set(LastCall.PRINT_LN);
        }
        Utils.printSeparator();
    }

    public static String trimTo16chars(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() > 16) {
            return s.substring(0, 16) + "...";
        }
        return s;
    }

    private static String joinUrlParts(String[] parts) {
        if (parts.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        for (String part : parts) {
            if (!Utils.isNullOrEmpty(sb.toString())) {
                sb.append("/");
            }
            sb.append(part.trim().replaceAll("(\\\\|/)+$", "").replaceAll("^(\\\\|/)+", ""));
        }
        return sb.toString();
    }

    private Utils() {
    }

    private static enum LastCall {
        PRINT,
        PRINT_LN,
        READ_LINE,
        READ_EMPTY_LINE,
        NONE;

    }
}

