/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSA;
import com.nimbusds.jose.crypto.RSASSAProvider;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSASSASigner
extends RSASSAProvider
implements JWSSigner {
    private final RSAPrivateKey privateKey;

    public RSASSASigner(RSAPrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The private RSA key must not be null");
        }
        this.privateKey = privateKey;
    }

    public RSASSASigner(RSAKey rsaJWK) throws JOSEException {
        if (!rsaJWK.isPrivate()) {
            throw new JOSEException("The RSA JWK doesn't contain a private part");
        }
        this.privateKey = rsaJWK.toRSAPrivateKey();
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        Signature signer = RSASSA.getSignerAndVerifier(header.getAlgorithm(), this.getJCAContext().getProvider());
        try {
            signer.initSign(this.privateKey);
            signer.update(signingInput);
            return Base64URL.encode(signer.sign());
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid private RSA key: " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new JOSEException("RSA signature exception: " + e.getMessage(), e);
        }
    }
}

