/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.AssymetricJWK;
import com.nimbusds.jose.jwk.ECParameterTable;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMetadata;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.ThumbprintUtils;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.BigIntegerUtils;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class ECKey
extends JWK
implements AssymetricJWK {
    private static final long serialVersionUID = 1L;
    private final Curve crv;
    private final Base64URL x;
    private final Base64URL y;
    private final Base64URL d;

    public static Base64URL encodeCoordinate(int fieldSize, BigInteger coordinate) {
        int bytesToOutput;
        byte[] unpadded = BigIntegerUtils.toBytesUnsigned(coordinate);
        if (unpadded.length >= (bytesToOutput = (fieldSize + 7) / 8)) {
            return Base64URL.encode(unpadded);
        }
        byte[] padded = new byte[bytesToOutput];
        System.arraycopy(unpadded, 0, padded, bytesToOutput - unpadded.length, unpadded.length);
        return Base64URL.encode(padded);
    }

    public ECKey(Curve crv, Base64URL x, Base64URL y, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URI x5u, Base64URL x5t, List<Base64> x5c) {
        super(KeyType.EC, use, ops, alg, kid, x5u, x5t, x5c);
        if (crv == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        this.crv = crv;
        if (x == null) {
            throw new IllegalArgumentException("The 'x' coordinate must not be null");
        }
        this.x = x;
        if (y == null) {
            throw new IllegalArgumentException("The 'y' coordinate must not be null");
        }
        this.y = y;
        this.d = null;
    }

    public ECKey(Curve crv, Base64URL x, Base64URL y, Base64URL d, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URI x5u, Base64URL x5t, List<Base64> x5c) {
        super(KeyType.EC, use, ops, alg, kid, x5u, x5t, x5c);
        if (crv == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        this.crv = crv;
        if (x == null) {
            throw new IllegalArgumentException("The 'x' coordinate must not be null");
        }
        this.x = x;
        if (y == null) {
            throw new IllegalArgumentException("The 'y' coordinate must not be null");
        }
        this.y = y;
        if (d == null) {
            throw new IllegalArgumentException("The 'd' coordinate must not be null");
        }
        this.d = d;
    }

    public ECKey(Curve crv, ECPublicKey pub, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URI x5u, Base64URL x5t, List<Base64> x5c) {
        this(crv, ECKey.encodeCoordinate(pub.getParams().getCurve().getField().getFieldSize(), pub.getW().getAffineX()), ECKey.encodeCoordinate(pub.getParams().getCurve().getField().getFieldSize(), pub.getW().getAffineY()), use, ops, alg, kid, x5u, x5t, x5c);
    }

    public ECKey(Curve crv, ECPublicKey pub, ECPrivateKey priv, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URI x5u, Base64URL x5t, List<Base64> x5c) {
        this(crv, ECKey.encodeCoordinate(pub.getParams().getCurve().getField().getFieldSize(), pub.getW().getAffineX()), ECKey.encodeCoordinate(pub.getParams().getCurve().getField().getFieldSize(), pub.getW().getAffineY()), ECKey.encodeCoordinate(priv.getParams().getCurve().getField().getFieldSize(), priv.getS()), use, ops, alg, kid, x5u, x5t, x5c);
    }

    public Curve getCurve() {
        return this.crv;
    }

    public Base64URL getX() {
        return this.x;
    }

    public Base64URL getY() {
        return this.y;
    }

    public Base64URL getD() {
        return this.d;
    }

    public ECPublicKey toECPublicKey() throws JOSEException {
        return this.toECPublicKey(null);
    }

    public ECPublicKey toECPublicKey(Provider provider) throws JOSEException {
        ECParameterSpec spec = this.crv.toECParameterSpec();
        if (spec == null) {
            throw new JOSEException("Couldn't get EC parameter spec for curve " + this.crv);
        }
        ECPoint w = new ECPoint(this.x.decodeToBigInteger(), this.y.decodeToBigInteger());
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(w, spec);
        try {
            KeyFactory keyFactory = provider == null ? KeyFactory.getInstance("EC") : KeyFactory.getInstance("EC", provider);
            return (ECPublicKey)keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public ECPrivateKey toECPrivateKey() throws JOSEException {
        return this.toECPrivateKey(null);
    }

    public ECPrivateKey toECPrivateKey(Provider provider) throws JOSEException {
        if (this.d == null) {
            return null;
        }
        ECParameterSpec spec = this.crv.toECParameterSpec();
        if (spec == null) {
            throw new JOSEException("Couldn't get EC parameter spec for curve " + this.crv);
        }
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(this.d.decodeToBigInteger(), spec);
        try {
            KeyFactory keyFactory = provider == null ? KeyFactory.getInstance("EC") : KeyFactory.getInstance("EC", provider);
            return (ECPrivateKey)keyFactory.generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    @Override
    public PublicKey toPublicKey() throws JOSEException {
        return this.toECPublicKey();
    }

    @Override
    public PrivateKey toPrivateKey() throws JOSEException {
        return this.toECPrivateKey();
    }

    @Override
    public KeyPair toKeyPair() throws JOSEException {
        return this.toKeyPair(null);
    }

    public KeyPair toKeyPair(Provider provider) throws JOSEException {
        return new KeyPair(this.toECPublicKey(provider), this.toECPrivateKey(provider));
    }

    @Override
    public LinkedHashMap<String, ?> getRequiredParams() {
        LinkedHashMap<String, String> requiredParams = new LinkedHashMap<String, String>();
        requiredParams.put("crv", this.crv.toString());
        requiredParams.put("kty", this.getKeyType().getValue());
        requiredParams.put("x", this.x.toString());
        requiredParams.put("y", this.y.toString());
        return requiredParams;
    }

    @Override
    public boolean isPrivate() {
        return this.d != null;
    }

    @Override
    public ECKey toPublicJWK() {
        return new ECKey(this.getCurve(), this.getX(), this.getY(), this.getKeyUse(), this.getKeyOperations(), this.getAlgorithm(), this.getKeyID(), this.getX509CertURL(), this.getX509CertThumbprint(), this.getX509CertChain());
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put("crv", this.crv.toString());
        o.put("x", this.x.toString());
        o.put("y", this.y.toString());
        if (this.d != null) {
            o.put("d", this.d.toString());
        }
        return o;
    }

    public static ECKey parse(String s) throws ParseException {
        return ECKey.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static ECKey parse(JSONObject jsonObject) throws ParseException {
        Curve crv = Curve.parse(JSONObjectUtils.getString(jsonObject, "crv"));
        Base64URL x = new Base64URL(JSONObjectUtils.getString(jsonObject, "x"));
        Base64URL y = new Base64URL(JSONObjectUtils.getString(jsonObject, "y"));
        KeyType kty = JWKMetadata.parseKeyType(jsonObject);
        if (kty != KeyType.EC) {
            throw new ParseException("The key type \"kty\" must be EC", 0);
        }
        Base64URL d = null;
        if (jsonObject.get("d") != null) {
            d = new Base64URL(JSONObjectUtils.getString(jsonObject, "d"));
        }
        try {
            if (d == null) {
                return new ECKey(crv, x, y, JWKMetadata.parseKeyUse(jsonObject), JWKMetadata.parseKeyOperations(jsonObject), JWKMetadata.parseAlgorithm(jsonObject), JWKMetadata.parseKeyID(jsonObject), JWKMetadata.parseX509CertURL(jsonObject), JWKMetadata.parseX509CertThumbprint(jsonObject), JWKMetadata.parseX509CertChain(jsonObject));
            }
            return new ECKey(crv, x, y, d, JWKMetadata.parseKeyUse(jsonObject), JWKMetadata.parseKeyOperations(jsonObject), JWKMetadata.parseAlgorithm(jsonObject), JWKMetadata.parseKeyID(jsonObject), JWKMetadata.parseX509CertURL(jsonObject), JWKMetadata.parseX509CertThumbprint(jsonObject), JWKMetadata.parseX509CertChain(jsonObject));
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public static /* bridge */ /* synthetic */ JWK parse(JSONObject jSONObject) throws ParseException {
        return ECKey.parse(jSONObject);
    }

    public static /* bridge */ /* synthetic */ JWK parse(String string) throws ParseException {
        return ECKey.parse(string);
    }

    public static class Builder {
        private final Curve crv;
        private final Base64URL x;
        private final Base64URL y;
        private Base64URL d;
        private KeyUse use;
        private Set<KeyOperation> ops;
        private Algorithm alg;
        private String kid;
        private URI x5u;
        private Base64URL x5t;
        private List<Base64> x5c;

        public Builder(Curve crv, Base64URL x, Base64URL y) {
            if (crv == null) {
                throw new IllegalArgumentException("The curve must not be null");
            }
            this.crv = crv;
            if (x == null) {
                throw new IllegalArgumentException("The 'x' coordinate must not be null");
            }
            this.x = x;
            if (y == null) {
                throw new IllegalArgumentException("The 'y' coordinate must not be null");
            }
            this.y = y;
        }

        public Builder(Curve crv, ECPublicKey pub) {
            this(crv, ECKey.encodeCoordinate(pub.getParams().getCurve().getField().getFieldSize(), pub.getW().getAffineX()), ECKey.encodeCoordinate(pub.getParams().getCurve().getField().getFieldSize(), pub.getW().getAffineY()));
        }

        public Builder d(Base64URL d) {
            this.d = d;
            return this;
        }

        public Builder privateKey(ECPrivateKey priv) {
            if (priv != null) {
                this.d = ECKey.encodeCoordinate(priv.getParams().getCurve().getField().getFieldSize(), priv.getS());
            }
            return this;
        }

        public Builder keyUse(KeyUse use) {
            this.use = use;
            return this;
        }

        public Builder keyOperations(Set<KeyOperation> ops) {
            this.ops = ops;
            return this;
        }

        public Builder algorithm(Algorithm alg) {
            this.alg = alg;
            return this;
        }

        public Builder keyID(String kid) {
            this.kid = kid;
            return this;
        }

        public Builder keyIDFromThumbprint() throws JOSEException {
            return this.keyIDFromThumbprint("SHA-256");
        }

        public Builder keyIDFromThumbprint(String hashAlg) throws JOSEException {
            LinkedHashMap<String, String> requiredParams = new LinkedHashMap<String, String>();
            requiredParams.put("crv", this.crv.toString());
            requiredParams.put("kty", KeyType.EC.getValue());
            requiredParams.put("x", this.x.toString());
            requiredParams.put("y", this.y.toString());
            this.kid = ThumbprintUtils.compute(hashAlg, requiredParams).toString();
            return this;
        }

        public Builder x509CertURL(URI x5u) {
            this.x5u = x5u;
            return this;
        }

        public Builder x509CertThumbprint(Base64URL x5t) {
            this.x5t = x5t;
            return this;
        }

        public Builder x509CertChain(List<Base64> x5c) {
            this.x5c = x5c;
            return this;
        }

        public ECKey build() {
            try {
                if (this.d == null) {
                    return new ECKey(this.crv, this.x, this.y, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5c);
                }
                return new ECKey(this.crv, this.x, this.y, this.d, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5c);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    @Immutable
    public static class Curve
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Curve P_256 = new Curve("P-256", "secp256r1");
        public static final Curve P_384 = new Curve("P-384", "secp384r1");
        public static final Curve P_521 = new Curve("P-521", "secp521r1");
        private final String name;
        private final String stdName;

        public Curve(String name) {
            this(name, null);
        }

        public Curve(String name, String stdName) {
            if (name == null) {
                throw new IllegalArgumentException("The JOSE cryptographic curve name must not be null");
            }
            this.name = name;
            this.stdName = stdName;
        }

        public String getName() {
            return this.name;
        }

        public String getStdName() {
            return this.stdName;
        }

        public ECParameterSpec toECParameterSpec() {
            return ECParameterTable.get(this);
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            return object instanceof Curve && this.toString().equals(object.toString());
        }

        public static Curve parse(String s) {
            if (s == null || s.trim().isEmpty()) {
                throw new IllegalArgumentException("The cryptographic curve string must not be null or empty");
            }
            if (s.equals(P_256.getName())) {
                return P_256;
            }
            if (s.equals(P_384.getName())) {
                return P_384;
            }
            if (s.equals(P_521.getName())) {
                return P_521;
            }
            return new Curve(s);
        }

        public static Curve forStdName(String stdName) {
            if ("secp256r1".equals(stdName) || "prime256v1".equals(stdName)) {
                return P_256;
            }
            if ("secp384r1".equals(stdName)) {
                return P_384;
            }
            if ("secp521r1".equals(stdName)) {
                return P_521;
            }
            return null;
        }

        public static Curve forECParameterSpec(ECParameterSpec spec) {
            return ECParameterTable.get(spec);
        }
    }
}

