package com.avaya.generic.channel.testclient;

import org.json.JSONException;
import org.json.JSONObject;
import com.avaya.generic.channel.testclient.utils.Rest;
import com.avaya.generic.channel.testclient.utils.RestResponse;
import com.avaya.generic.channel.testclient.utils.Utils;
import net.minidev.json.JSONArray;

public class CoreDataServiceClient {

    public CoreDataServiceClient(Configuration configuration) {
        this.configuration = configuration;
    }
    
    

    public void getСontextID(String contextId, String extraData) {

        try {
            int EXTRA_DATA_LIMIT = 1000;

            JSONObject data = new JSONObject();
            if (!Utils.isNullOrEmpty(extraData) && extraData.length() <= EXTRA_DATA_LIMIT) {
                String key = extraData.substring(0, extraData.indexOf(":"));
                String value = extraData.substring(extraData.indexOf(":") + 1, extraData.length());
                data.put(key, value);
            } else {
                Utils.println("Put extra data failed. Data longer than 1000 characters or empty");
            }
            JSONObject schema = new JSONObject();
            JSONObject serviceMap = new JSONObject();
            JSONObject serviceMap1 = new JSONObject();
            JSONObject attributes = new JSONObject();
            JSONArray channel = new JSONArray();
            channel.add(0, "Generic");
            attributes.put("Channel", channel);
            serviceMap1.put("attributes", attributes);
            serviceMap1.put("priority", "5");
            serviceMap1.put("rank", "");
            serviceMap1.put("resourceCount", "");
            serviceMap1.put("minProficiency", "");
            serviceMap1.put("maxProficiency", "");
            
            serviceMap.put("1", serviceMap1);
            
            schema.put("ServiceMap", serviceMap);
            schema.put("Locale", "IRE");
            schema.put("Strategy", "Most Idle");
            schema.put("MatchingService", "CS");
        
            JSONObject raw = new JSONObject();
            raw.put("contextId", contextId);
            raw.put("persistToEDM", "true");
            raw.put("tenantId", "1");
            raw.put("data", data);
            raw.put("schema", schema);


          // execute the request
            final String urlSuffix = "/oceana/data/context/schema";
            postToApi(urlSuffix, raw);
        } catch (Exception ex) {
            Utils.println(ex.getMessage());
        }
    }

    //========================================== private =========================================================

    private void jsonPutOpt(JSONObject json, PropertyKey key) throws Exception {
        json.putOpt(key.name(), configuration.opt(key));
    }

    private boolean postToApi(String urlSuffix, JSONObject json) throws Exception {
        final String url = Utils.buildUrl(configuration.getCoreDataServiceHost(), "/services/OceanaCoreDataService/", urlSuffix);
        final RestResponse response = Rest.post(url, json);
        Utils.println(response.toString());
        return response.isOK();
    }
    
    private String opt(JSONObject json, String key) {
        final String value = json.optString(key);
        return (value != null) ? value : "";
    }    

    private final Configuration configuration;
    
}
