package com.avaya.generic.channel.testclient.utils;

/**
 * A simple timer to support executing requests at fixed rate
 */
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;

public class SynchronousTimer {

    public SynchronousTimer() {
        semaphore = new Semaphore(0);
        timer = new Timer();
    }

    public void start(Integer rate) {
        TickTimerTask ttt = new TickTimerTask(semaphore);
        int periodInMs = (int)(1000.0 / (double)rate);
        timer.scheduleAtFixedRate(ttt, 0, periodInMs);
    }

    public void waitForTick() {
        try {
            semaphore.acquire();
        } catch (InterruptedException ie) {
            // todo: handle this case
        }
    }

    public void stop() {
        timer.cancel();
        timer.purge();
    }

    //=======================================

    private Semaphore semaphore;
    private java.util.Timer timer;

    private static class TickTimerTask extends TimerTask {
        private Semaphore semaphore;
        public TickTimerTask(Semaphore semaphore) {
            this.semaphore = semaphore;
        }
        @Override
        public void run() {
            semaphore.release();
        }
    }
}
