package com.avaya.generic.channel.testclient;

import com.avaya.generic.channel.testclient.utils.Rest;
import com.avaya.generic.channel.testclient.utils.RestResponse;
import com.avaya.generic.channel.testclient.utils.Utils;
import org.json.JSONObject;

/**
 * REST client for GenericChannelAPI.
 * Prints the responses as they are.
 */
public class GenericChannelAPIClient {

    GenericChannelAPIClient(Configuration configuration) {
        this.configuration = configuration;
    }

    boolean createContact(String contactID, String workRequestID, String extraData) throws Exception {
        JSONObject json = new JSONObject();
        json.putOpt("contactID", contactID);
        json.putOpt("workRequestID", workRequestID);
        json.putOpt("extraData", extraData);
        for (PropertyKey key : PropertyKey.createContactParamsGroup()) {
            jsonPutOpt(json, key);
        }
        return postToApi("/createcontact", json);
    }

    boolean dropContact(String contactID) throws Exception {
        JSONObject json = new JSONObject();
        json.putOpt("contactID", contactID);
        jsonPutOpt(json, PropertyKey.ssoToken);
        return postToApi("/dropcontact", json);
    }

    boolean dropAllContacts() throws Exception{
        JSONObject json = new JSONObject();
        json.putOpt("numContactsForClosing", configuration.getNumContactsForClosing());
        json.putOpt("numContactsForShowing", configuration.getNumContactsForShowing());
        jsonPutOpt(json, PropertyKey.ssoToken);
        return postToApi("/closeactivecontacts", json);     
    }
    
    boolean getAttributes() throws Exception {
        JSONObject json = new JSONObject();
        jsonPutOpt(json, PropertyKey.ssoToken);
        return postToApi("/getlistofattributes", json);
    }

    boolean getRoutePoints() throws Exception {
        JSONObject json = new JSONObject();
        jsonPutOpt(json, PropertyKey.ssoToken);
        return postToApi("/getlistofroutepoints", json);
    }
    
    boolean getActiveContacts() throws Exception {
        JSONObject json = new JSONObject();
        jsonPutOpt(json, PropertyKey.ssoToken);
        json.putOpt("numContactsForClosing", configuration.getNumContactsForClosing());
        json.putOpt("numContactsForShowing", configuration.getNumContactsForShowing());
        return postToApi("/getactivecontacts", json);
    }

    //========================================== private =========================================================

    private void jsonPutOpt(JSONObject json, PropertyKey key) throws Exception {
        json.putOpt(key.name(), configuration.opt(key));
    }

    private boolean postToApi(String urlSuffix, JSONObject json) throws Exception {
        final String url = Utils.buildUrl(configuration.getApiHost(), "/services/GenericChannelAPI/api/", urlSuffix);
        final RestResponse response = Rest.post(url, json);
        Utils.println(response.toString());
        return response.isOK();
    }
    
    private final Configuration configuration;
}
