package com.avaya.generic.channel.testclient.utils;

import org.apache.http.HttpStatus;

public class RestResponse {

    public int getCode() {
        return code;
    }

    public String getContent() {
        return content;
    }

    public boolean isOK() {
        return code == HttpStatus.SC_OK;
    }

    public RestResponse(int code, String content) {
        this.code = code;
        this.content = (content != null) ? content : "";
    }

    @Override
    public String toString() {
        return String.format("%d %s", getCode(), getContent());
    }

    private final int code;
    private final String content;
}
