package com.avaya.generic.channel.testclient;

import com.avaya.generic.channel.testclient.utils.Rest;
import com.avaya.generic.channel.testclient.utils.Utils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

import java.io.File;
import java.util.List;

public class TestClient {
    
    private TestClient(){
        //
        //empty private constructor for SONAR
        //
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    public static void main(String[] args) {

        final ShutdownHook shutdownHook = new ShutdownHook();

        try {
            // initialization
            Utils.println("======= Generic Channel API Test Client v.2 =======");
            final File propertiesFile = parseArgsAndReturnPropertiesFile(args);
            final Configuration configuration = new Configuration(propertiesFile);
            final EventListener eventListener = new EventListener();
            final CommandProcessor commandProcessor = new CommandProcessor(configuration, eventListener);
            shutdownHook.setEventListener(eventListener);
            Runtime.getRuntime().addShutdownHook(shutdownHook);

            // command execution
            while (true) {

                Utils.printSeparator();
                Utils.print(" > ");
                final String line = Utils.readLine();

                if (Utils.isNullOrEmpty(line)) {
                    continue;
                }

                if (line.equalsIgnoreCase("exit") || line.equalsIgnoreCase("quit")) {
                    break;
                }

                Utils.printSeparator();
                try {
                    commandProcessor.execute(line);
                } catch (Exception e) {
                    Utils.printException(e);
                }
            }

        } catch (ParseException pe) {
            Utils.printSeparator();
            Utils.println(pe.getMessage());
            Utils.printSeparator();
            Utils.println("Usage:");
            Utils.println("test-client.bat -p <properties_file>");
            Utils.println("test-client.bat <properties_file>");

        } catch (Exception e) {
            Utils.printException(e);

        } finally {
            Thread shutdownHookThread = new Thread();
            shutdownHookThread.start(); // shutdown hook is for Ctrl+C termination, but it is also correct to do the same things here.
        }
    }

    private static File parseArgsAndReturnPropertiesFile(String[] args) throws ParseException {

        final CommandLineParser parser = new DefaultParser();
        final CommandLine cmdLine = parser.parse(options, args);
        final String pArg = cmdLine.getOptionValue("p");
        final List<String> leftOverArgs = cmdLine.getArgList();

        // check the -p option
        if (pArg != null) {
            if (leftOverArgs.isEmpty()) {
                return new File(pArg);
            } else {
                throw new ParseException("Illegal arguments");
            }
        }

        // if there is no -p option, then the properties file is the first argument
        if (leftOverArgs.size() == 1) {
            return new File(leftOverArgs.get(0));
        } else if (leftOverArgs.isEmpty()) {
            throw new ParseException("No arguments");
        } else {
            throw new ParseException("Illegal arguments");
        }
    }


    private static class ShutdownHook extends Thread {

        void setEventListener(EventListener eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void run() {
            try {
                Rest.shutdown();
                if (eventListener != null) {
                    eventListener.shutdown();
                }
            } catch (Exception ex) {
                // nothing
            }
        }

        private EventListener eventListener = null;
    }

    private static final Options options = new Options().addOption(Option.builder("p").hasArg().argName("file").desc("Properties file").build());
}