/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.asm.MethodVisitor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ast.Literal;

public class RealLiteral
extends Literal {
    private final TypedValue value;

    public RealLiteral(String payload, int pos, double value) {
        super(payload, pos);
        this.value = new TypedValue(value);
        this.exitTypeDescriptor = "D";
    }

    @Override
    public TypedValue getLiteralValue() {
        return this.value;
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow codeflow) {
        mv.visitLdcInsn(this.value.getValue());
        codeflow.pushDescriptor(this.getExitDescriptor());
    }
}

