/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.base;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.jaxrs.cfg.AnnotationBundleKey;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.cfg.EndpointConfigBase;
import com.fasterxml.jackson.jaxrs.cfg.JaxRSFeature;
import com.fasterxml.jackson.jaxrs.cfg.MapperConfiguratorBase;
import com.fasterxml.jackson.jaxrs.util.ClassKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

public abstract class ProviderBase<THIS extends ProviderBase<THIS, MAPPER, EP_CONFIG, MAPPER_CONFIG>, MAPPER extends ObjectMapper, EP_CONFIG extends EndpointConfigBase<EP_CONFIG>, MAPPER_CONFIG extends MapperConfiguratorBase<MAPPER_CONFIG, MAPPER>>
implements MessageBodyReader<Object>,
MessageBodyWriter<Object>,
Versioned {
    public static final String HEADER_CONTENT_TYPE_OPTIONS = "X-Content-Type-Options";
    protected static final HashSet<ClassKey> DEFAULT_UNTOUCHABLES = new HashSet();
    public static final Class<?>[] DEFAULT_UNREADABLES;
    public static final Class<?>[] DEFAULT_UNWRITABLES;
    protected HashMap<ClassKey, Boolean> _cfgCustomUntouchables;
    protected boolean _cfgCheckCanSerialize = false;
    protected boolean _cfgCheckCanDeserialize = false;
    protected int _jaxRSFeatures;
    public static final HashSet<ClassKey> _untouchables;
    public static final Class<?>[] _unreadableClasses;
    public static final Class<?>[] _unwritableClasses;
    protected final LRUMap<AnnotationBundleKey, EP_CONFIG> _readers = new LRUMap(16, 120);
    protected final LRUMap<AnnotationBundleKey, EP_CONFIG> _writers = new LRUMap(16, 120);
    protected final MAPPER_CONFIG _mapperConfig;

    protected ProviderBase(MAPPER_CONFIG MAPPER_CONFIG) {
        this._mapperConfig = MAPPER_CONFIG;
    }

    @Deprecated
    protected ProviderBase() {
        this._mapperConfig = null;
    }

    public void checkCanDeserialize(boolean bl) {
        this._cfgCheckCanDeserialize = bl;
    }

    public void checkCanSerialize(boolean bl) {
        this._cfgCheckCanSerialize = bl;
    }

    public void addUntouchable(Class<?> clazz) {
        if (this._cfgCustomUntouchables == null) {
            this._cfgCustomUntouchables = new HashMap();
        }
        this._cfgCustomUntouchables.put(new ClassKey(clazz), Boolean.TRUE);
    }

    public void removeUntouchable(Class<?> clazz) {
        if (this._cfgCustomUntouchables == null) {
            this._cfgCustomUntouchables = new HashMap();
        }
        this._cfgCustomUntouchables.put(new ClassKey(clazz), Boolean.FALSE);
    }

    public void setAnnotationsToUse(Annotations[] annotationsArray) {
        ((MapperConfiguratorBase)this._mapperConfig).setAnnotationsToUse(annotationsArray);
    }

    public void setMapper(MAPPER MAPPER) {
        ((MapperConfiguratorBase)this._mapperConfig).setMapper(MAPPER);
    }

    public THIS configure(JaxRSFeature jaxRSFeature, boolean bl) {
        this._jaxRSFeatures |= jaxRSFeature.getMask();
        return this._this();
    }

    public THIS enable(JaxRSFeature jaxRSFeature) {
        this._jaxRSFeatures |= jaxRSFeature.getMask();
        return this._this();
    }

    public THIS enable(JaxRSFeature jaxRSFeature, JaxRSFeature ... jaxRSFeatureArray) {
        this._jaxRSFeatures |= jaxRSFeature.getMask();
        for (JaxRSFeature jaxRSFeature2 : jaxRSFeatureArray) {
            this._jaxRSFeatures |= jaxRSFeature2.getMask();
        }
        return this._this();
    }

    public THIS disable(JaxRSFeature jaxRSFeature) {
        this._jaxRSFeatures &= ~jaxRSFeature.getMask();
        return this._this();
    }

    public THIS disable(JaxRSFeature jaxRSFeature, JaxRSFeature ... jaxRSFeatureArray) {
        this._jaxRSFeatures &= ~jaxRSFeature.getMask();
        for (JaxRSFeature jaxRSFeature2 : jaxRSFeatureArray) {
            this._jaxRSFeatures &= ~jaxRSFeature2.getMask();
        }
        return this._this();
    }

    public boolean isEnabled(JaxRSFeature jaxRSFeature) {
        return (this._jaxRSFeatures & jaxRSFeature.getMask()) != 0;
    }

    public THIS configure(DeserializationFeature deserializationFeature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(deserializationFeature, bl);
        return this._this();
    }

    public THIS enable(DeserializationFeature deserializationFeature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(deserializationFeature, true);
        return this._this();
    }

    public THIS disable(DeserializationFeature deserializationFeature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(deserializationFeature, false);
        return this._this();
    }

    public THIS configure(SerializationFeature serializationFeature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(serializationFeature, bl);
        return this._this();
    }

    public THIS enable(SerializationFeature serializationFeature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(serializationFeature, true);
        return this._this();
    }

    public THIS disable(SerializationFeature serializationFeature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(serializationFeature, false);
        return this._this();
    }

    public THIS enable(JsonParser.Feature feature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(feature, true);
        return this._this();
    }

    public THIS enable(JsonGenerator.Feature feature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(feature, true);
        return this._this();
    }

    public THIS disable(JsonParser.Feature feature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(feature, false);
        return this._this();
    }

    public THIS disable(JsonGenerator.Feature feature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(feature, false);
        return this._this();
    }

    public THIS configure(JsonParser.Feature feature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(feature, bl);
        return this._this();
    }

    public THIS configure(JsonGenerator.Feature feature, boolean bl) {
        ((MapperConfiguratorBase)this._mapperConfig).configure(feature, bl);
        return this._this();
    }

    protected boolean hasMatchingMediaTypeForReading(MediaType mediaType) {
        return this.hasMatchingMediaType(mediaType);
    }

    protected boolean hasMatchingMediaTypeForWriting(MediaType mediaType) {
        return this.hasMatchingMediaType(mediaType);
    }

    protected abstract boolean hasMatchingMediaType(MediaType var1);

    protected abstract MAPPER _locateMapperViaProvider(Class<?> var1, MediaType var2);

    protected abstract EP_CONFIG _configForReading(MAPPER var1, Annotation[] var2);

    protected abstract EP_CONFIG _configForWriting(MAPPER var1, Annotation[] var2);

    public long getSize(Object object, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        if (!this.hasMatchingMediaType(mediaType)) {
            return false;
        }
        Boolean bl = this._findCustomUntouchable(clazz);
        if (bl != null) {
            return bl == false;
        }
        if (bl == null) {
            if (_untouchables.contains(new ClassKey(clazz))) {
                return false;
            }
            for (Class<?> clazz2 : _unwritableClasses) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return false;
            }
        }
        return !this._cfgCheckCanSerialize || this.locateMapper(clazz, mediaType).canSerialize(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Object object, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException {
        JsonEncoding jsonEncoding;
        EndpointConfigBase<Object> endpointConfigBase;
        AnnotationBundleKey annotationBundleKey = new AnnotationBundleKey(annotationArray, clazz);
        ObjectWriter objectWriter = this._writers;
        synchronized (objectWriter) {
            endpointConfigBase = (EndpointConfigBase)this._writers.get((Object)annotationBundleKey);
        }
        if (endpointConfigBase == null) {
            objectWriter = this.locateMapper(clazz, mediaType);
            endpointConfigBase = this._configForWriting(objectWriter, annotationArray);
            jsonEncoding = this._writers;
            synchronized (jsonEncoding) {
                this._writers.put((Object)annotationBundleKey.immutableKey(), (Object)endpointConfigBase);
            }
        }
        this._modifyHeaders(object, clazz, type, annotationArray, multivaluedMap, endpointConfigBase);
        objectWriter = endpointConfigBase.getWriter();
        jsonEncoding = this.findEncoding(mediaType, multivaluedMap);
        JsonGenerator jsonGenerator = objectWriter.getFactory().createGenerator(outputStream, jsonEncoding);
        try {
            if (objectWriter.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
                jsonGenerator.useDefaultPrettyPrinter();
            }
            JavaType javaType = null;
            if (type != null && object != null && type.getClass() != Class.class && (javaType = objectWriter.getTypeFactory().constructType(type)).getRawClass() == Object.class) {
                javaType = null;
            }
            if (javaType != null) {
                objectWriter = objectWriter.withType(javaType);
            }
            object = endpointConfigBase.modifyBeforeWrite(object);
            objectWriter.writeValue(jsonGenerator, object);
        }
        finally {
            jsonGenerator.close();
        }
    }

    protected JsonEncoding findEncoding(MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap) {
        return JsonEncoding.UTF8;
    }

    protected void _modifyHeaders(Object object, Class<?> clazz, Type type, Annotation[] annotationArray, MultivaluedMap<String, Object> multivaluedMap, EP_CONFIG EP_CONFIG) throws IOException {
        if (this.isEnabled(JaxRSFeature.ADD_NO_SNIFF_HEADER)) {
            multivaluedMap.add((Object)HEADER_CONTENT_TYPE_OPTIONS, (Object)"nosniff");
        }
    }

    public boolean isReadable(Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        if (!this.hasMatchingMediaType(mediaType)) {
            return false;
        }
        Boolean bl = this._findCustomUntouchable(clazz);
        if (bl != null) {
            return bl == false;
        }
        if (bl == null) {
            if (_untouchables.contains(new ClassKey(clazz))) {
                return false;
            }
            for (Class<?> clazz2 : _unreadableClasses) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return false;
            }
        }
        if (this._cfgCheckCanSerialize) {
            if (this._isSpecialReadable(clazz)) {
                return true;
            }
            MAPPER MAPPER = this.locateMapper(clazz, mediaType);
            if (!MAPPER.canDeserialize(MAPPER.constructType(clazz))) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readFrom(Class<Object> clazz, Type type, Annotation[] annotationArray, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) throws IOException {
        LRUMap<AnnotationBundleKey, EP_CONFIG> lRUMap;
        EndpointConfigBase<Object> endpointConfigBase;
        AnnotationBundleKey annotationBundleKey = new AnnotationBundleKey(annotationArray, clazz);
        Object object = this._readers;
        synchronized (object) {
            endpointConfigBase = (EndpointConfigBase)this._readers.get((Object)annotationBundleKey);
        }
        if (endpointConfigBase == null) {
            object = this.locateMapper(clazz, mediaType);
            endpointConfigBase = this._configForReading(object, annotationArray);
            lRUMap = this._readers;
            synchronized (lRUMap) {
                this._readers.put((Object)annotationBundleKey.immutableKey(), (Object)endpointConfigBase);
            }
        }
        if ((lRUMap = this._createParser((ObjectReader)(object = endpointConfigBase.getReader()), inputStream)) == null || lRUMap.nextToken() == null) {
            return null;
        }
        if (clazz == JsonParser.class) {
            return lRUMap;
        }
        return object.withType(type).readValue(lRUMap);
    }

    protected JsonParser _createParser(ObjectReader objectReader, InputStream inputStream) throws IOException {
        return objectReader.getFactory().createParser(inputStream);
    }

    public MAPPER locateMapper(Class<?> clazz, MediaType mediaType) {
        Object MAPPER = ((MapperConfiguratorBase)this._mapperConfig).getConfiguredMapper();
        if (MAPPER == null && (MAPPER = this._locateMapperViaProvider(clazz, mediaType)) == null) {
            MAPPER = ((MapperConfiguratorBase)this._mapperConfig).getDefaultMapper();
        }
        return MAPPER;
    }

    protected boolean _isSpecialReadable(Class<?> clazz) {
        return JsonParser.class == clazz;
    }

    protected static boolean _containedIn(Class<?> clazz, HashSet<ClassKey> hashSet) {
        if (hashSet != null) {
            ClassKey classKey = new ClassKey(clazz);
            if (hashSet.contains(classKey)) {
                return true;
            }
            for (Class<?> clazz2 : ProviderBase.findSuperTypes(clazz, null)) {
                classKey.reset(clazz2);
                if (!hashSet.contains(classKey)) continue;
                return true;
            }
        }
        return false;
    }

    protected Boolean _findCustomUntouchable(Class<?> clazz) {
        if (this._cfgCustomUntouchables != null) {
            ClassKey classKey = new ClassKey(clazz);
            Boolean bl = this._cfgCustomUntouchables.get(classKey);
            if (bl != null) {
                return bl;
            }
            for (Class<?> clazz2 : ProviderBase.findSuperTypes(clazz, null)) {
                classKey.reset(clazz2);
                bl = this._cfgCustomUntouchables.get(classKey);
                if (bl == null) continue;
                return bl;
            }
        }
        return null;
    }

    protected static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2) {
        return ProviderBase.findSuperTypes(clazz, clazz2, new ArrayList(8));
    }

    protected static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2, List<Class<?>> list) {
        ProviderBase._addSuperTypes(clazz, clazz2, list, false);
        return list;
    }

    protected static void _addSuperTypes(Class<?> clazz, Class<?> clazz2, Collection<Class<?>> collection, boolean bl) {
        if (clazz == clazz2 || clazz == null || clazz == Object.class) {
            return;
        }
        if (bl) {
            if (collection.contains(clazz)) {
                return;
            }
            collection.add(clazz);
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            ProviderBase._addSuperTypes(clazz3, clazz2, collection, true);
        }
        ProviderBase._addSuperTypes(clazz.getSuperclass(), clazz2, collection, true);
    }

    private final THIS _this() {
        return (THIS)this;
    }

    static {
        DEFAULT_UNTOUCHABLES.add(new ClassKey(InputStream.class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(Reader.class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(OutputStream.class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(Writer.class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(char[].class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(String.class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(byte[].class));
        DEFAULT_UNREADABLES = new Class[]{InputStream.class, Reader.class};
        DEFAULT_UNWRITABLES = new Class[]{InputStream.class, OutputStream.class, Writer.class, StreamingOutput.class, Response.class};
        _untouchables = DEFAULT_UNTOUCHABLES;
        _unreadableClasses = DEFAULT_UNREADABLES;
        _unwritableClasses = DEFAULT_UNWRITABLES;
    }
}

