/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.text.DateFormat;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class Jackson2ObjectMapperFactoryBean
implements FactoryBean<ObjectMapper>,
BeanClassLoaderAware,
InitializingBean {
    private final Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
    private ObjectMapper objectMapper;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setCreateXmlMapper(boolean createXmlMapper) {
        this.builder.createXmlMapper(createXmlMapper);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.builder.dateFormat(dateFormat);
    }

    public void setSimpleDateFormat(String format) {
        this.builder.simpleDateFormat(format);
    }

    public void setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this.builder.annotationIntrospector(annotationIntrospector);
    }

    public void setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this.builder.propertyNamingStrategy(propertyNamingStrategy);
    }

    public void setSerializationInclusion(JsonInclude.Include serializationInclusion) {
        this.builder.serializationInclusion(serializationInclusion);
    }

    public void setSerializers(JsonSerializer<?> ... serializers) {
        this.builder.serializers(serializers);
    }

    public void setSerializersByType(Map<Class<?>, JsonSerializer<?>> serializers) {
        this.builder.serializersByType(serializers);
    }

    public void setDeserializersByType(Map<Class<?>, JsonDeserializer<?>> deserializers) {
        this.builder.deserializersByType(deserializers);
    }

    public void setAutoDetectFields(boolean autoDetectFields) {
        this.builder.autoDetectFields(autoDetectFields);
    }

    public void setAutoDetectGettersSetters(boolean autoDetectGettersSetters) {
        this.builder.autoDetectGettersSetters(autoDetectGettersSetters);
    }

    public void setDefaultViewInclusion(boolean defaultViewInclusion) {
        this.builder.defaultViewInclusion(defaultViewInclusion);
    }

    public void setFailOnUnknownProperties(boolean failOnUnknownProperties) {
        this.builder.failOnUnknownProperties(failOnUnknownProperties);
    }

    public void setFailOnEmptyBeans(boolean failOnEmptyBeans) {
        this.builder.failOnEmptyBeans(failOnEmptyBeans);
    }

    public void setIndentOutput(boolean indentOutput) {
        this.builder.indentOutput(indentOutput);
    }

    public void setFeaturesToEnable(Object ... featuresToEnable) {
        this.builder.featuresToEnable(featuresToEnable);
    }

    public void setFeaturesToDisable(Object ... featuresToDisable) {
        this.builder.featuresToDisable(featuresToDisable);
    }

    public void setModules(List<Module> modules) {
        this.builder.modules(modules);
    }

    public void setModulesToInstall(Class<? extends Module> ... modules) {
        this.builder.modulesToInstall(modules);
    }

    public void setFindModulesViaServiceLoader(boolean findModules) {
        this.builder.findModulesViaServiceLoader(findModules);
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.builder.moduleClassLoader(beanClassLoader);
    }

    public void afterPropertiesSet() {
        if (this.objectMapper != null) {
            this.builder.configure(this.objectMapper);
        } else {
            this.objectMapper = this.builder.build();
        }
    }

    public ObjectMapper getObject() {
        return this.objectMapper;
    }

    public Class<?> getObjectType() {
        return this.objectMapper != null ? this.objectMapper.getClass() : null;
    }

    public boolean isSingleton() {
        return true;
    }
}

