/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;
import org.springframework.util.ResizableByteArrayOutputStream;
import org.springframework.util.StreamUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.WebUtils;

public class ShallowEtagHeaderFilter
extends OncePerRequestFilter {
    private static final String HEADER_ETAG = "ETag";
    private static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String DIRECTIVE_NO_STORE = "no-store";

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object responseToUse = response;
        if (!this.isAsyncDispatch(request)) {
            responseToUse = new ShallowEtagResponseWrapper(response);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)responseToUse);
        if (!this.isAsyncStarted(request)) {
            this.updateResponse(request, (HttpServletResponse)responseToUse);
        }
    }

    private void updateResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ShallowEtagResponseWrapper responseWrapper = WebUtils.getNativeResponse((ServletResponse)response, ShallowEtagResponseWrapper.class);
        Assert.notNull((Object)((Object)responseWrapper), (String)"ShallowEtagResponseWrapper not found");
        HttpServletResponse rawResponse = (HttpServletResponse)responseWrapper.getResponse();
        int statusCode = responseWrapper.getStatusCode();
        byte[] body = responseWrapper.toByteArray();
        if (rawResponse.isCommitted()) {
            if (body.length > 0) {
                StreamUtils.copy((byte[])body, (OutputStream)rawResponse.getOutputStream());
            }
        } else if (this.isEligibleForEtag(request, (HttpServletResponse)responseWrapper, statusCode, body)) {
            String responseETag = this.generateETagHeaderValue(body);
            rawResponse.setHeader(HEADER_ETAG, responseETag);
            String requestETag = request.getHeader(HEADER_IF_NONE_MATCH);
            if (responseETag.equals(requestETag)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("ETag [" + responseETag + "] equal to If-None-Match, sending 304"));
                }
                rawResponse.setStatus(304);
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("ETag [" + responseETag + "] not equal to If-None-Match [" + requestETag + "], sending normal response"));
                }
                if (body.length > 0) {
                    rawResponse.setContentLength(body.length);
                    StreamUtils.copy((byte[])body, (OutputStream)rawResponse.getOutputStream());
                }
            }
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Response with status code [" + statusCode + "] not eligible for ETag"));
            }
            if (body.length > 0) {
                rawResponse.setContentLength(body.length);
                StreamUtils.copy((byte[])body, (OutputStream)rawResponse.getOutputStream());
            }
        }
    }

    protected boolean isEligibleForEtag(HttpServletRequest request, HttpServletResponse response, int responseStatusCode, byte[] responseBody) {
        String cacheControl;
        return responseStatusCode >= 200 && responseStatusCode < 300 && HttpMethod.GET.name().equals(request.getMethod()) && ((cacheControl = response.getHeader(HEADER_CACHE_CONTROL)) == null || !cacheControl.contains(DIRECTIVE_NO_STORE));
    }

    protected String generateETagHeaderValue(byte[] bytes) {
        StringBuilder builder = new StringBuilder("\"0");
        DigestUtils.appendMd5DigestAsHex((byte[])bytes, (StringBuilder)builder);
        builder.append('\"');
        return builder.toString();
    }

    private static class ShallowEtagResponseWrapper
    extends HttpServletResponseWrapper {
        private final ResizableByteArrayOutputStream content = new ResizableByteArrayOutputStream(1024);
        private final ServletOutputStream outputStream = new ResponseServletOutputStream();
        private PrintWriter writer;
        private int statusCode = 200;

        public ShallowEtagResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int sc) {
            super.setStatus(sc);
            this.statusCode = sc;
        }

        public void setStatus(int sc, String sm) {
            super.setStatus(sc, sm);
            this.statusCode = sc;
        }

        public void sendError(int sc) throws IOException {
            this.copyBodyToResponse();
            super.sendError(sc);
            this.statusCode = sc;
        }

        public void sendError(int sc, String msg) throws IOException {
            this.copyBodyToResponse();
            super.sendError(sc, msg);
            this.statusCode = sc;
        }

        public void sendRedirect(String location) throws IOException {
            this.copyBodyToResponse();
            super.sendRedirect(location);
        }

        public ServletOutputStream getOutputStream() {
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                String characterEncoding = this.getCharacterEncoding();
                this.writer = characterEncoding != null ? new ResponsePrintWriter(characterEncoding) : new ResponsePrintWriter("ISO-8859-1");
            }
            return this.writer;
        }

        public void setContentLength(int len) {
            if (len > this.content.capacity()) {
                this.content.resize(len);
            }
        }

        public void setContentLengthLong(long len) {
            if (len > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Content-Length exceeds ShallowEtagHeaderFilter's maximum (2147483647): " + len);
            }
            if (len > (long)this.content.capacity()) {
                this.content.resize((int)len);
            }
        }

        public void setBufferSize(int size) {
            if (size > this.content.capacity()) {
                this.content.resize(size);
            }
        }

        public void resetBuffer() {
            this.content.reset();
        }

        public void reset() {
            super.reset();
            this.content.reset();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public byte[] toByteArray() {
            return this.content.toByteArray();
        }

        private void copyBodyToResponse() throws IOException {
            if (this.content.size() > 0) {
                this.getResponse().setContentLength(this.content.size());
                StreamUtils.copy((byte[])this.content.toByteArray(), (OutputStream)this.getResponse().getOutputStream());
                this.content.reset();
            }
        }

        private class ResponsePrintWriter
        extends PrintWriter {
            public ResponsePrintWriter(String characterEncoding) throws UnsupportedEncodingException {
                super(new OutputStreamWriter((OutputStream)ShallowEtagResponseWrapper.this.content, characterEncoding));
            }

            @Override
            public void write(char[] buf, int off, int len) {
                super.write(buf, off, len);
                super.flush();
            }

            @Override
            public void write(String s, int off, int len) {
                super.write(s, off, len);
                super.flush();
            }

            @Override
            public void write(int c) {
                super.write(c);
                super.flush();
            }
        }

        private class ResponseServletOutputStream
        extends ServletOutputStream {
            private ResponseServletOutputStream() {
            }

            public void write(int b) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b, off, len);
            }
        }
    }
}

