/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

public class ResponseEntity<T>
extends HttpEntity<T> {
    private final HttpStatus statusCode;

    public ResponseEntity(HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    public ResponseEntity(T body, HttpStatus statusCode) {
        super(body);
        this.statusCode = statusCode;
    }

    public ResponseEntity(MultiValueMap<String, String> headers, HttpStatus statusCode) {
        super(headers);
        this.statusCode = statusCode;
    }

    public ResponseEntity(T body, MultiValueMap<String, String> headers, HttpStatus statusCode) {
        super(body, headers);
        this.statusCode = statusCode;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResponseEntity) || !super.equals(other)) {
            return false;
        }
        ResponseEntity otherEntity = (ResponseEntity)other;
        return ObjectUtils.nullSafeEquals((Object)((Object)this.statusCode), (Object)((Object)otherEntity.statusCode));
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 29 + ObjectUtils.nullSafeHashCode((Object)((Object)this.statusCode));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.statusCode.toString());
        builder.append(' ');
        builder.append(this.statusCode.getReasonPhrase());
        builder.append(',');
        Object body = this.getBody();
        HttpHeaders headers = this.getHeaders();
        if (body != null) {
            builder.append(body);
            if (headers != null) {
                builder.append(',');
            }
        }
        if (headers != null) {
            builder.append(headers);
        }
        builder.append('>');
        return builder.toString();
    }

    public static BodyBuilder status(HttpStatus status) {
        return new DefaultBuilder(status);
    }

    public static BodyBuilder status(int status) {
        return ResponseEntity.status(HttpStatus.valueOf(status));
    }

    public static BodyBuilder ok() {
        return ResponseEntity.status(HttpStatus.OK);
    }

    public static <T> ResponseEntity<T> ok(T body) {
        BodyBuilder builder = ResponseEntity.ok();
        return builder.body(body);
    }

    public static BodyBuilder created(URI location) {
        BodyBuilder builder = ResponseEntity.status(HttpStatus.CREATED);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder accepted() {
        return ResponseEntity.status(HttpStatus.ACCEPTED);
    }

    public static HeadersBuilder<?> noContent() {
        return ResponseEntity.status(HttpStatus.NO_CONTENT);
    }

    public static BodyBuilder badRequest() {
        return ResponseEntity.status(HttpStatus.BAD_REQUEST);
    }

    public static HeadersBuilder<?> notFound() {
        return ResponseEntity.status(HttpStatus.NOT_FOUND);
    }

    private static class DefaultBuilder
    implements BodyBuilder {
        private final HttpStatus status;
        private final HttpHeaders headers = new HttpHeaders();

        public DefaultBuilder(HttpStatus status) {
            this.status = status;
        }

        @Override
        public BodyBuilder header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.headers.add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public BodyBuilder allow(HttpMethod ... allowedMethods) {
            this.headers.setAllow(new HashSet<HttpMethod>(Arrays.asList(allowedMethods)));
            return this;
        }

        @Override
        public BodyBuilder contentLength(long contentLength) {
            this.headers.setContentLength(contentLength);
            return this;
        }

        @Override
        public BodyBuilder contentType(MediaType contentType) {
            this.headers.setContentType(contentType);
            return this;
        }

        @Override
        public BodyBuilder eTag(String eTag) {
            this.headers.setETag(eTag);
            return this;
        }

        @Override
        public BodyBuilder lastModified(long date) {
            this.headers.setLastModified(date);
            return this;
        }

        @Override
        public BodyBuilder location(URI location) {
            this.headers.setLocation(location);
            return this;
        }

        @Override
        public ResponseEntity<Void> build() {
            return new ResponseEntity<Object>(null, this.headers, this.status);
        }

        @Override
        public <T> ResponseEntity<T> body(T body) {
            return new ResponseEntity<T>(body, this.headers, this.status);
        }
    }

    public static interface BodyBuilder
    extends HeadersBuilder<BodyBuilder> {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        public <T> ResponseEntity<T> body(T var1);
    }

    public static interface HeadersBuilder<B extends HeadersBuilder<B>> {
        public B header(String var1, String ... var2);

        public B allow(HttpMethod ... var1);

        public B eTag(String var1);

        public B lastModified(long var1);

        public B location(URI var1);

        public ResponseEntity<Void> build();
    }
}

