/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices;

import com.avaya.ade.common.utils.security.SSLSocketFactoryHTTPClient;
import com.avaya.sce.pdc.oceanaservices.IExecuteRequest;
import com.avaya.sce.pdc.oceanaservices.IOceanaServices;
import com.avaya.sce.pdc.oceanaservices.OceanaServicesException;
import com.avaya.sce.pdc.oceanaservices.Utils;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.RuntimeCommonVersion;
import com.avaya.sce.runtimecommon.SCESession;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.http.client.utils.URIBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class OceanaServices
implements IOceanaServices {
    private static final Logger LOGGER = Logger.getLogger(OceanaServices.class.getName());
    public static final String CONTENTJSON = "application/json";
    public static final String CHAR_ENCODING = "UTF-8";
    public static final String JSON_DATA = "data";
    private static final Header CONTENT_TYPE = new Header("Content-Type", "application/json");
    public static final String CREATE_CONTEXTSCHEMA_URL = "http%s://%s/services/OceanaCoreDataService/oceana/data/context/schema";
    public static final String GET_SERVICEMAP_URL = "http%s://%s/services/OceanaCoreDataService/oceana/data/context/serviceMap/%s";
    public static final String GET_CONTEXTANDSCHEMA_URL = "http%s://%s/services/OceanaCoreDataService/oceana/data/context/%s";
    public static final String UPDATE_CONTEXTSCHEMA_URL = "http%s://%s/services/OceanaCoreDataService/oceana/data/update/context/%s";
    public static final String UPDATE_JOURNEY_URL = "http%s://%s/services/OceanaCoreDataService/oceana/data/update/journeyElement/%s?journeyElement=%s";
    private static final String GET_CURRENT_WORK_REQUEST_CUSTOMER_JOURNEY = "http%s://%s/services/ContextStoreRest/cs/contexts/audit/%s";
    private static final String GET_CUSTOMER_JOURNEY_BY_CUSTOMER_ID_URL = "http%s://%s/services/CustomerJourneyService/rest/customer/journeys/%s";
    private static final String FIND_CUSTOMER_URL = "http%s://%s/services/CustomerManagement/rest/customers/customerId?";
    private static final String GET_CUSTOMER_HISTORY_URL = "http%s://%s/services/CustomerManagement/rest/customers/history?";
    private static final String LEASE = "lease";
    private static final String PHONE = "phone";
    private static final String CUSTOMER_ID = "customerId";
    private static final String WORKREQUEST_ID = "workRequestId";
    private static final String JOURNEY_ELEMENT = "journeyElement";
    private static final String EMAIL = "email";
    private static final String CRMID = "crmid";
    private static final String ACCOUNT_TYPE = "accountType";
    private static final String ACCOUNT_ID = "accountId";
    private static final String SOCIAL = "social";
    private static final String PLATFORM = "platform";
    private static final String GROUP = "group";
    private static final String TOPIC = "topic";
    private static final String SCHEMA = "schema";
    private static final String UNABLE_TO_BUILD_URL_CORRECTLY = "Unable to build URL correctly ";
    public static final int MAJOR_VERSION_END_INDEX = 2;
    public static final int MINOR_VERSION_BEGIN_INDEX = 3;
    public static final int MINOR_VERSION_END_INDEX = 5;
    public static final int MAJOR_VERSION_MAX_LENGTH = 7;
    public static final int MINOR_VERSION_MAX_LENGTH = 20;
    public static final int DEFAULT_PORT = 443;
    public static final int LINGER = 5;
    public static final int TIMEOUT_MC = 15000;
    private static final int NUMBER_OF_RETRIES = 1;
    String useHttps = "";
    HttpClient client;

    public OceanaServices() {
        this.useHttps = "";
        this.init();
    }

    public OceanaServices(URL keystore, String password) {
        if (this.doProtocolRegistration()) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new SSLSocketFactoryHTTPClient(keystore, password), 443));
        }
        this.useHttps = "s";
        this.init();
    }

    private boolean doProtocolRegistration() {
        String ver = RuntimeCommonVersion.getVersion();
        int verMajor = Integer.parseInt(ver.substring(0, 2));
        int verMinor = Integer.parseInt(ver.substring(3, 5));
        if (verMajor > 7) {
            return false;
        }
        return verMinor < 20;
    }

    private void init() {
        this.client = new HttpClient();
        this.client.getHttpConnectionManager().getParams().setSoTimeout(15000);
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(15000);
        this.client.getHttpConnectionManager().getParams().setLinger(75000);
    }

    private String convertString(String value) {
        if (value == null) {
            return "";
        }
        try {
            byte[] bytes = new byte[value.length()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)value.charAt(i);
            }
            return new String(bytes, CHAR_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "", e);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeWithRetries(IExecuteRequest execute, String clusterIP, SCESession sceSession) throws OceanaServicesException {
        int status = 0;
        String reason = null;
        HttpMethodBase method = null;
        for (int index = 1; index <= 1; ++index) {
            block12: {
                String string;
                block13: {
                    String result;
                    block10: {
                        String string2;
                        block11: {
                            String server = clusterIP;
                            if (Utils.isStringNullOrEmpty(server)) {
                                String invalidClusterIPProvided = "Unable to create request URL as no cluster IP has been received. Please ensure that a valid cluster IP has been provided.";
                                Utils.logErrorMessage(sceSession, invalidClusterIPProvided);
                                throw new OceanaServicesException(invalidClusterIPProvided);
                            }
                            status = 0;
                            method = execute.getMethod(server);
                            Utils.logInfoMessage(sceSession, "URI used for request = " + method.getURI());
                            method.setRequestHeader(CONTENT_TYPE);
                            status = this.client.executeMethod((HttpMethod)method);
                            result = reason = method.getResponseBodyAsString();
                            if (status != 200) break block10;
                            Utils.logDebugMessage(sceSession, "status of request is OK, result: " + result);
                            string2 = this.convertString(result);
                            if (method == null) break block11;
                            method.releaseConnection();
                        }
                        return string2;
                    }
                    result = execute.isResultFatal(status, result);
                    if (result == null) break block12;
                    Utils.logDebugMessage(sceSession, "result is NOT null i.e. a NOT FOUND response for Get Customer Id. result = " + result);
                    string = this.convertString(result);
                    if (method == null) break block13;
                    method.releaseConnection();
                }
                return string;
            }
            try {
                try {
                    String errorMessage = "Error executing request [" + status + ":" + reason + "]";
                    Utils.logErrorMessage(sceSession, errorMessage);
                    throw new OceanaServicesException(errorMessage);
                }
                catch (OceanaServicesException e) {
                    throw e;
                }
                catch (Exception e) {
                    Utils.logErrorMessage(sceSession, "Error executing request. Response from target cluster [status: " + status + " reason: " + reason + "]. Number of attempts remaining = " + (1 - index) + ". Exception details: " + e);
                    if (method == null) continue;
                    method.releaseConnection();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (method != null) {
                    method.releaseConnection();
                }
                throw throwable;
            }
        }
        String unableToConnectToTargetCluster = "Unsuccessfully attempted to reach target cluster with 1 attempt(s). Please verify that the IP address provided is correct.";
        Utils.logErrorMessage(sceSession, unableToConnectToTargetCluster);
        throw new OceanaServicesException(unableToConnectToTargetCluster);
    }

    @Override
    public String createContextWithSchema(final String data, final String leaseTime, String groupId, final String journeyElement, String topic, SCESession sceSession, String contextStoreIP) throws OceanaServicesException {
        JSONObject json = new JSONObject(data);
        this.setMapToNullIfEmpty(json);
        String contextId = this.getContextId(json);
        String result = this.executeWithRetries(new IExecuteRequest(){

            @Override
            public HttpMethodBase getMethod(String server) throws UnsupportedEncodingException {
                String urlStr = String.format(OceanaServices.CREATE_CONTEXTSCHEMA_URL, OceanaServices.this.useHttps, server);
                urlStr = OceanaServices.this.urlSetUpForCreateContext(urlStr, leaseTime, journeyElement);
                PostMethod method = new PostMethod(urlStr);
                StringRequestEntity entity = new StringRequestEntity(data, OceanaServices.CONTENTJSON, OceanaServices.CHAR_ENCODING);
                method.setRequestEntity((RequestEntity)entity);
                return method;
            }

            @Override
            public String isResultFatal(int status, String result) {
                return null;
            }
        }, contextStoreIP, sceSession);
        if (result.length() > 0) {
            json = new JSONObject(result);
            contextId = this.getContextIdFromData(json);
        }
        return contextId;
    }

    private String urlSetUpForCreateContext(String urlStr, String leaseTime, String journeyElement) {
        try {
            URIBuilder uriBuilder = new URIBuilder(urlStr);
            this.addURLParameters(uriBuilder, LEASE, leaseTime);
            this.addURLParameters(uriBuilder, JOURNEY_ELEMENT, journeyElement);
            URI postUri = uriBuilder.build();
            urlStr = postUri.toString();
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.SEVERE, UNABLE_TO_BUILD_URL_CORRECTLY, ex);
            return urlStr;
        }
        return urlStr;
    }

    private URIBuilder addURLParameters(URIBuilder uriBuilder, String paramName, String paramValue) {
        if (paramValue == null || "".equals(paramValue)) {
            return uriBuilder;
        }
        uriBuilder.addParameter(paramName, paramValue);
        return uriBuilder;
    }

    private String getContextId(JSONObject json) {
        try {
            return json.getString("contextId");
        }
        catch (JSONException e) {
            LOGGER.log(Level.WARNING, "", e);
            return "";
        }
    }

    private String getContextIdFromData(JSONObject json) {
        try {
            JSONObject d = json.getJSONObject(JSON_DATA);
            return d.getString("contextId");
        }
        catch (JSONException e) {
            LOGGER.log(Level.WARNING, "", e);
            return "";
        }
    }

    @Override
    public String getContextWithSchema(final String contextId, String contextStoreIP, SCESession sceSession) throws OceanaServicesException {
        String result = this.executeWithRetries(new IExecuteRequest(){

            @Override
            public HttpMethodBase getMethod(String server) throws UnsupportedEncodingException {
                String urlStr = String.format(OceanaServices.GET_CONTEXTANDSCHEMA_URL, OceanaServices.this.useHttps, server, contextId);
                GetMethod method = new GetMethod(urlStr);
                return method;
            }

            @Override
            public String isResultFatal(int status, String result) {
                return null;
            }
        }, contextStoreIP, sceSession);
        return result;
    }

    @Override
    public void updateContextWithSchema(final String contextId, final String data, final String groupId, final String topic, String contextStoreIP, final String journeyElement, SCESession sceSession) throws OceanaServicesException {
        final SCESession mySession = sceSession;
        JSONObject json = new JSONObject(data);
        this.setMapToNullIfEmpty(json);
        this.executeWithRetries(new IExecuteRequest(){

            @Override
            public HttpMethodBase getMethod(String server) throws UnsupportedEncodingException {
                String urlStr = String.format(OceanaServices.UPDATE_CONTEXTSCHEMA_URL, OceanaServices.this.useHttps, server, contextId);
                urlStr = OceanaServices.this.urlSetUpForUpdateContext(urlStr, groupId, topic, journeyElement);
                if (mySession.isTraceEnabled()) {
                    ITraceInfo tr = mySession.getTraceOutput();
                    tr.writeln(1, "URL after returning from url setup: " + urlStr);
                }
                PutMethod method = new PutMethod(urlStr);
                StringRequestEntity entity = new StringRequestEntity(data, OceanaServices.CONTENTJSON, OceanaServices.CHAR_ENCODING);
                method.setRequestEntity((RequestEntity)entity);
                return method;
            }

            @Override
            public String isResultFatal(int status, String result) {
                return null;
            }
        }, contextStoreIP, sceSession);
    }

    private String urlSetUpForUpdateContext(String urlStr, String groupId, String topic, String journeyElement) {
        try {
            URIBuilder uriBuilder = new URIBuilder(urlStr);
            this.addURLParameters(uriBuilder, GROUP, groupId);
            this.addURLParameters(uriBuilder, TOPIC, topic);
            this.addURLParameters(uriBuilder, JOURNEY_ELEMENT, journeyElement);
            URI postUri = uriBuilder.build();
            urlStr = postUri.toString();
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.SEVERE, UNABLE_TO_BUILD_URL_CORRECTLY, ex);
            return urlStr;
        }
        return urlStr;
    }

    @Override
    public String getServiceMap(final String contextId, String contextStoreIP, SCESession sceSession) throws OceanaServicesException {
        String result = this.executeWithRetries(new IExecuteRequest(){

            @Override
            public HttpMethodBase getMethod(String server) throws UnsupportedEncodingException {
                String urlStr = String.format(OceanaServices.GET_SERVICEMAP_URL, OceanaServices.this.useHttps, server, contextId);
                GetMethod method = new GetMethod(urlStr);
                return method;
            }

            @Override
            public String isResultFatal(int status, String result) {
                return null;
            }
        }, contextStoreIP, sceSession);
        return result;
    }

    @Override
    public void updateJourney(final String contextId, final String data, String contextStoreIP, SCESession sceSession) throws OceanaServicesException {
        this.executeWithRetries(new IExecuteRequest(){

            @Override
            public HttpMethodBase getMethod(String server) throws UnsupportedEncodingException {
                String urlStr = String.format(OceanaServices.UPDATE_JOURNEY_URL, OceanaServices.this.useHttps, server, contextId, data);
                PutMethod method = new PutMethod(urlStr);
                StringRequestEntity entity = new StringRequestEntity(data, OceanaServices.CONTENTJSON, OceanaServices.CHAR_ENCODING);
                method.setRequestEntity((RequestEntity)entity);
                return method;
            }

            @Override
            public String isResultFatal(int status, String result) {
                return null;
            }
        }, contextStoreIP, sceSession);
    }

    public void setMapToNullIfEmpty(JSONObject json) {
        try {
            JSONObject data = json.getJSONObject(SCHEMA);
            String rMap = data.get("ResourceMap").toString();
            String tMap = data.get("TransferServiceMap").toString();
            String sMap = data.get("ServiceMap").toString();
            this.setMap(data, rMap, "ResourceMap");
            this.setMap(data, tMap, "TransferServiceMap");
            this.setMap(data, sMap, "ServiceMap");
        }
        catch (JSONException e) {
            LOGGER.log(Level.WARNING, "Key not found", e);
        }
    }

    public void setMap(JSONObject data, String map, String mapName) {
        if ("{}".equals(map) || map.matches("\\{\\s+\\}") || "".equals(map) || map.isEmpty()) {
            data.put(mapName, JSONObject.NULL);
        }
    }

    public static void setField(String fieldName, JSONObject json, String fieldValue) {
        try {
            if (fieldValue != null) {
                json.put(fieldName, (Object)fieldValue);
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.WARNING, "'" + fieldName + "' is null", e);
        }
    }

    @Override
    public String getCurrentWorkRequestCustomerJourney(final String contextId, String contextStoreIP, SCESession sceSession) throws OceanaServicesException {
        String result = this.executeWithRetries(new IExecuteRequest(){

            @Override
            public HttpMethodBase getMethod(String server) throws UnsupportedEncodingException {
                String urlStr = String.format(OceanaServices.GET_CURRENT_WORK_REQUEST_CUSTOMER_JOURNEY, OceanaServices.this.useHttps, server, contextId);
                GetMethod method = new GetMethod(urlStr);
                return method;
            }

            @Override
            public String isResultFatal(int status, String result) {
                return null;
            }
        }, contextStoreIP, sceSession);
        return result;
    }

    @Override
    public String findCustomerId(String email, String phone, String customerManagementIP, SCESession sceSession, String externalId, String accountType, String accountId, String handle, String platform) throws OceanaServicesException {
        String result = this.executeWithRetries(new FindCustomerExecuteRequest(email, phone, externalId, accountType, accountId, handle, platform), customerManagementIP, sceSession);
        return result;
    }

    @Override
    public String getCustomerJourneyByCustomerID(final String customerId, String customerManagementIP, SCESession sceSession) throws OceanaServicesException {
        String result = this.executeWithRetries(new IExecuteRequest(){

            @Override
            public HttpMethodBase getMethod(String server) throws UnsupportedEncodingException {
                String urlStr = String.format(OceanaServices.GET_CUSTOMER_JOURNEY_BY_CUSTOMER_ID_URL, OceanaServices.this.useHttps, server, customerId);
                GetMethod method = new GetMethod(urlStr);
                return method;
            }

            @Override
            public String isResultFatal(int status, String result) {
                return null;
            }
        }, customerManagementIP, sceSession);
        return result;
    }

    @Override
    public String getCustomerHistory(String customerId, String workRequestId, String customerManagementIP, SCESession sceSession) throws OceanaServicesException {
        String result = this.executeWithRetries(new GetCustomerHistoryExecuteRequest(customerId, workRequestId), customerManagementIP, sceSession);
        return result;
    }

    public static String getSCHEMA() {
        return SCHEMA;
    }

    class GetCustomerHistoryExecuteRequest
    implements IExecuteRequest {
        private String customerId;
        private String workRequestId;

        GetCustomerHistoryExecuteRequest(String customerId, String workRequestId) {
            this.customerId = customerId;
            this.workRequestId = workRequestId;
        }

        @Override
        public HttpMethodBase getMethod(String server) throws UnsupportedEncodingException {
            String urlStr = String.format(OceanaServices.GET_CUSTOMER_HISTORY_URL, OceanaServices.this.useHttps, server);
            urlStr = this.urlSetUp(urlStr, this.customerId, this.workRequestId);
            GetMethod method = new GetMethod(urlStr);
            return method;
        }

        private String urlSetUp(String urlStr, String customerId, String workRequestId) {
            try {
                URIBuilder uriBuilder = new URIBuilder(urlStr);
                OceanaServices.this.addURLParameters(uriBuilder, OceanaServices.WORKREQUEST_ID, workRequestId);
                OceanaServices.this.addURLParameters(uriBuilder, OceanaServices.CUSTOMER_ID, customerId);
                URI getUri = uriBuilder.build();
                urlStr = getUri.toString();
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.SEVERE, OceanaServices.UNABLE_TO_BUILD_URL_CORRECTLY, ex);
                return urlStr;
            }
            return urlStr;
        }

        @Override
        public String isResultFatal(int status, String result) {
            if (status == 404 && result.length() > 0) {
                return "";
            }
            return null;
        }
    }

    class FindCustomerExecuteRequest
    implements IExecuteRequest {
        private String email;
        private String phone;
        private String externalId;
        private String accountType;
        private String accountId;
        private String handle;
        private String platform;

        FindCustomerExecuteRequest(String email, String phone, String externalId, String accountType, String accountId, String handle, String platform) {
            this.email = email;
            this.phone = phone;
            this.externalId = externalId;
            this.accountType = accountType;
            this.accountId = accountId;
            this.handle = handle;
            this.platform = platform;
        }

        @Override
        public HttpMethodBase getMethod(String server) throws UnsupportedEncodingException {
            String urlStr = String.format(OceanaServices.FIND_CUSTOMER_URL, OceanaServices.this.useHttps, server);
            urlStr = this.urlSetUp(urlStr, this.email, this.phone, this.externalId, this.accountType, this.accountId, this.handle, this.platform);
            GetMethod method = new GetMethod(urlStr);
            return method;
        }

        private String urlSetUp(String urlStr, String email, String phone, String externalId, String accountType, String accountId, String handle, String platform) {
            try {
                URIBuilder uriBuilder = new URIBuilder(urlStr);
                OceanaServices.this.addURLParameters(uriBuilder, OceanaServices.PHONE, phone);
                OceanaServices.this.addURLParameters(uriBuilder, OceanaServices.EMAIL, email);
                OceanaServices.this.addURLParameters(uriBuilder, OceanaServices.CRMID, externalId);
                OceanaServices.this.addURLParameters(uriBuilder, OceanaServices.ACCOUNT_TYPE, accountType);
                OceanaServices.this.addURLParameters(uriBuilder, OceanaServices.ACCOUNT_ID, accountId);
                OceanaServices.this.addURLParameters(uriBuilder, OceanaServices.SOCIAL, handle);
                OceanaServices.this.addURLParameters(uriBuilder, OceanaServices.PLATFORM, platform);
                URI getUri = uriBuilder.build();
                urlStr = getUri.toString();
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.SEVERE, OceanaServices.UNABLE_TO_BUILD_URL_CORRECTLY, ex);
                return urlStr;
            }
            return urlStr;
        }

        @Override
        public String isResultFatal(int status, String result) {
            if (status == 404 && result.length() > 0) {
                return "";
            }
            return null;
        }
    }
}

