/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices;

import com.avaya.runtimecommon.platforms.Toolkit;
import com.avaya.sce.pdc.oceanaservices.IOceanaServices;
import com.avaya.sce.pdc.oceanaservices.OceanaServices;
import com.avaya.sce.runtimecommon.ICollection;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import com.avaya.sce.runtimecommon.config.IApplicationConfiguration;
import com.avaya.sce.runtimecommon.config.ICertificateKeystoreConfig;
import java.util.ArrayList;

public final class Utils {
    private static final String OCEANA_SERVICES_ACCESS = "com.avaya.sce.oceanaserviceseaccess";
    private static final String OCEANA_SERVICES = "com.avaya.sce.pdc.oceanaservices";
    public static final int THOUSAND = 1000;
    public static final int TWO = 2;
    public static final int TIMEOUT = 15000;

    private Utils() {
    }

    public static IOceanaServices getService(SCESession mySession) {
        OceanaServices oas = (OceanaServices)mySession.getProperty(OCEANA_SERVICES_ACCESS);
        if (oas == null) {
            IVariableField field = mySession.getVariableField("avayaOceanaUseSecureConnection");
            if (field.getStringValue().equalsIgnoreCase(Boolean.TRUE.toString())) {
                IApplicationConfiguration config = Toolkit.getConfig();
                ICertificateKeystoreConfig cert = config.getCertificateConfig();
                oas = new OceanaServices(cert.getKeystoreLocationURL(), cert.getKeystorePassword());
            } else {
                oas = new OceanaServices();
            }
            mySession.setProperty(OCEANA_SERVICES_ACCESS, (Object)oas);
        }
        return oas;
    }

    public static String getValueFromParameter(String varStr, String fieldStr, boolean isConstant, SCESession mySession) {
        String value = null;
        if (varStr != null && !varStr.equals("")) {
            if (isConstant) {
                value = varStr;
            } else {
                if (fieldStr != null && fieldStr.equals("")) {
                    fieldStr = null;
                }
                IVariableField field = mySession.getVariableField(new VariableName(varStr, fieldStr));
                value = field.getStringValue().trim();
            }
        }
        return value;
    }

    public static Object getValueFromParameter(String varStr, String fieldStr, boolean isConstant, SCESession mySession, boolean useArray) {
        if (varStr != null && !varStr.equals("")) {
            if (isConstant) {
                if (useArray) {
                    String[] v = new String[]{varStr};
                    return v;
                }
                return varStr;
            }
            IVariable var = mySession.getVariable(varStr);
            if (fieldStr != null && fieldStr.equals("")) {
                fieldStr = null;
            }
            IVariableField field = mySession.getVariableField(new VariableName(varStr, fieldStr));
            if (var.isCollection()) {
                ICollection collection = var.getCollection();
                ArrayList<String> values = new ArrayList<String>();
                collection.mark();
                collection.reset();
                int count = collection.size();
                for (int index = 0; index < count; ++index) {
                    collection.next();
                    values.add(field.getStringValue());
                }
                collection.resetToMark();
                return values.toArray(new String[0]);
            }
            if (useArray) {
                String[] v = new String[]{field.getStringValue().trim()};
                return v;
            }
            return field.getStringValue().trim();
        }
        return null;
    }

    public static String substituteVaraiables(SCESession mySession, String value) {
        StringBuilder text = new StringBuilder(value);
        int end = text.lastIndexOf("}_");
        while (end > -1) {
            int start = text.lastIndexOf("_{", end);
            if (start > 0 && text.charAt(start - 1) == '\\') {
                text.replace(start - 1, start, "");
                start = -1;
            }
            if (start == -1) break;
            String var = text.substring(start + 2, end);
            LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)1, (String)("Replacing variable [" + var + "] with its value in the text."));
            String varValue = Utils.getVarValue(mySession, var);
            if (varValue == null) {
                LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)3, (String)("Unable to get variable [" + var + "] value.  Text may be incomplete."));
            } else {
                text.replace(start, end + 2, varValue);
            }
            end = text.lastIndexOf("}_", start - 1);
        }
        return text.toString();
    }

    private static String getVarValue(SCESession mySession, String varName) {
        if (varName == null || varName.length() == 0) {
            return null;
        }
        IVariableField field = mySession.getVariableField(new VariableName(varName));
        if (field != null) {
            return field.getStringValue();
        }
        return null;
    }

    public static boolean isStringNullOrEmpty(String stringToCheck) {
        return stringToCheck == null || "".equals(stringToCheck);
    }

    public static String getOceanaServices() {
        return OCEANA_SERVICES;
    }

    public static void logDebugMessage(SCESession sceSession, String message) {
        if (sceSession.isTraceEnabled()) {
            ITraceInfo tr = sceSession.getTraceOutput();
            tr.writeln(1, message);
        }
    }

    public static void logErrorMessage(SCESession sceSession, String message) {
        if (sceSession.isTraceEnabled()) {
            ITraceInfo tr = sceSession.getTraceOutput();
            tr.writeln(4, message);
        }
    }

    public static void logInfoMessage(SCESession sceSession, String message) {
        if (sceSession.isTraceEnabled()) {
            ITraceInfo tr = sceSession.getTraceOutput();
            tr.writeln(2, message);
        }
    }
}

