/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.vp.admin.variables.runtime;

import com.avaya.vp.admin.variables.runtime.ValidationType;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterMetaInfo {
    public static String VALIDATE_PROP_MIN = "Min";
    public static String VALIDATE_PROP_MAX = "Max";
    public static String VALIDATE_PROP_DATEFORMAT = "DateFormat";
    public static String VALIDATE_PROP_TIMEFORMAT = "TimeFormat";
    public static String VALIDATE_PROP_EXTENSION = "FileExtensions";
    private String name;
    private String defaultValue;
    private ValidationType type;
    private Map<String, String> validationProps = new HashMap<String, String>();

    public ParameterMetaInfo(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeName = nodeList.item(i).getNodeName();
            if (nodeName.equals("FieldDefaultValue")) {
                this.defaultValue = this.getText(nodeList.item(i));
            }
            if (nodeName.equals("FieldName")) {
                this.name = this.getText(nodeList.item(i));
            }
            if (nodeName.equals("FieldType")) {
                String typeString = this.getText(nodeList.item(i));
                this.type = ValidationType.getValidationType(typeString);
            }
            if (!nodeName.equals("FieldValidation")) continue;
            this.parseValidation(nodeList.item(i));
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    private String getText(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 3) continue;
            return children.item(i).getNodeValue();
        }
        return "";
    }

    private void parseValidation(Node node) {
        Node validation = node.getFirstChild().getNextSibling();
        NodeList params = validation.getChildNodes();
        for (int i = 0; i < params.getLength(); ++i) {
            if (params.item(i).getNodeType() != 1) continue;
            String paramName = params.item(i).getNodeName();
            String paramValue = this.getText(params.item(i));
            this.validationProps.put(paramName, paramValue);
        }
    }

    public ValidationType getType() {
        return this.type;
    }

    public String getValidationParamValue(String paramName) {
        return this.validationProps.get(paramName);
    }
}

