/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.ComplexVariable;
import com.avaya.sce.runtime.tracking.Trackable;
import com.avaya.sce.runtimecommon.ICollection;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableTypeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ComplexCollection
implements ICollection {
    int index = -1;
    IVariableField[] fields;
    String[] fieldNames;
    ArrayList<Object[]> values = new ArrayList();
    String varName;
    int numFields;
    int mark = -1;

    public ComplexCollection(IComplexVariable complex, String varName) {
        this.fieldNames = complex.getFieldNames();
        this.numFields = this.fieldNames.length;
        this.fields = complex.getFields();
        this.varName = varName;
    }

    public boolean hasMore() {
        return this.index < this.values.size() && this.index != -1;
    }

    public boolean hasPrevious() {
        return this.index > 1;
    }

    public void next() throws IllegalStateException {
        try {
            int i;
            Object[] val;
            if (this.index > 0) {
                val = this.values.get(this.index - 1);
                for (i = 0; i < this.fields.length; ++i) {
                    val[i] = this.fields[i].getObjectValue();
                }
            }
            val = this.values.get(this.index);
            for (i = 0; i < val.length; ++i) {
                this.fields[i].setValue(val[i]);
            }
            ++this.index;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            Trackable.formatException(e, sb);
            throw new IllegalStateException(sb.toString());
        }
    }

    public void previous() throws IllegalStateException {
        try {
            int i;
            Object[] val;
            if (this.index > 0) {
                val = this.values.get(this.index - 1);
                for (i = 0; i < this.fields.length; ++i) {
                    val[i] = this.fields[i].getObjectValue();
                }
            }
            --this.index;
            val = this.values.get(this.index - 1);
            for (i = 0; i < val.length; ++i) {
                this.fields[i].setValue(val[i]);
            }
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            Trackable.formatException(e, sb);
            throw new IllegalStateException(sb.toString());
        }
    }

    public void reset() {
        if (this.index > 0) {
            Object[] val = this.values.get(this.index - 1);
            for (int i = 0; i < this.fields.length; ++i) {
                val[i] = this.fields[i].getObjectValue();
            }
        }
        this.index = 0;
    }

    public int size() {
        return this.values.size();
    }

    public void append() {
        Object[] fieldValues = new Object[this.numFields];
        for (int i = 0; i < fieldValues.length; ++i) {
            fieldValues[i] = this.fields[i].getObjectValue();
        }
        this.values.add(fieldValues);
        this.index = this.values.size();
    }

    public void append(String varName, IRuntimeSession mySession) {
        Object[] fieldValues;
        IVariable var = mySession.getVariable(varName);
        if (var.isComplexVariable()) {
            IComplexVariable complex = var.getComplexVariable();
            IVariableField[] fields = complex.getFields();
            fieldValues = new Object[this.numFields];
            for (int i = 0; i < fields.length; ++i) {
                Object val;
                fieldValues[i] = val = fields[i].getObjectValue();
                this.fields[i].setValue(val);
            }
        } else {
            throw new VariableTypeException("Variable [" + varName.toString() + "] is simple cannot set as complex variable");
        }
        this.values.add(fieldValues);
        this.index = this.values.size();
    }

    public void removeAll() {
        while (this.values.size() > 0) {
            this.values.remove(0);
        }
        for (IVariableField field : this.fields) {
            field.setValue("");
        }
        this.index = -1;
    }

    public void delete() {
        this.values.remove(this.index - 1);
        if (this.index > this.values.size()) {
            --this.index;
        }
        if (this.index > 0) {
            Object[] val = this.values.get(this.index - 1);
            for (int i = 0; i < val.length; ++i) {
                this.fields[i].setValue(val[i]);
            }
        }
    }

    public void insert(String varName, IRuntimeSession mySession) {
        if (this.index <= 0) {
            this.append(varName, mySession);
        } else {
            IVariable var = mySession.getVariable(varName);
            if (var.isComplexVariable()) {
                IComplexVariable complex = var.getComplexVariable();
                IVariableField[] fields = complex.getFields();
                Object[] values = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    values[i] = fields[i].getObjectValue();
                }
                this.insert(values);
            } else {
                throw new VariableTypeException("Variable [" + varName.toString() + "] is simple cannot insert into a complex variable");
            }
        }
    }

    private void insert(Object[] object) {
        if (this.numFields != object.length) {
            throw new VariableTypeException("Number of variable fields does not match the number of values");
        }
        Object[] fieldValues = new Object[this.numFields];
        for (int i = 0; i < fieldValues.length; ++i) {
            fieldValues[i] = object[i];
            this.fields[i].setValue(object[i]);
        }
        if (this.index <= 0) {
            this.append();
        } else {
            this.values.add(this.index - 1, fieldValues);
        }
    }

    public void sort(boolean descending, String fieldName, IRuntimeSession mySession) {
        IVariable destVar = mySession.getVariable(this.varName);
        IComplexVariable complex = destVar.getComplexVariable();
        if (complex == null) {
            mySession.throwRTException(this.varName + " is not a complex variable");
        }
        int fieldIndex = -1;
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equals(fieldName)) continue;
            fieldIndex = i;
            break;
        }
        if (fieldIndex == -1) {
            mySession.throwRTException(fieldName + " is not in complex variable " + this.varName);
        }
        final boolean isDescending = descending;
        final int theIndex = fieldIndex;
        boolean doNumeric = true;
        for (Object[] item : this.values) {
            try {
                Double.parseDouble(item[theIndex].toString());
            }
            catch (Exception e) {
                doNumeric = false;
                break;
            }
        }
        final boolean numericSort = doNumeric;
        Collections.sort(this.values, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                if (!numericSort) {
                    if (isDescending) {
                        return o2[theIndex].toString().compareTo(o1[theIndex].toString());
                    }
                    return o1[theIndex].toString().compareTo(o2[theIndex].toString());
                }
                double i1 = 0.0;
                double i2 = 0.0;
                i1 = Double.parseDouble(o1[theIndex].toString());
                i2 = Double.parseDouble(o2[theIndex].toString());
                if (isDescending) {
                    if (i2 > i1) {
                        return 1;
                    }
                    if (i2 == i1) {
                        return 0;
                    }
                    if (i2 < i1) {
                        return -1;
                    }
                    return 0;
                }
                if (i1 > i2) {
                    return 1;
                }
                if (i1 == i2) {
                    return 0;
                }
                if (i1 < i2) {
                    return -1;
                }
                return 0;
            }
        });
        this.index = 0;
        this.next();
    }

    public static void append(SCESession mySession, String varName, Object[] object) {
        IVariable var = mySession.getVariable(varName);
        if (!var.isComplexVariable()) {
            throw new VariableTypeException("Variable [" + varName.toString() + "] is simple cannot append to a complex variable");
        }
        ICollection collection = !var.isCollection() ? var.addCollection() : var.getCollection();
        ComplexVariable.set(mySession, varName, object);
        collection.append();
    }

    public static void insert(SCESession mySession, String varName, Object[] object) {
        IVariable var = mySession.getVariable(varName);
        if (!var.isComplexVariable()) {
            throw new VariableTypeException("Variable [" + varName.toString() + "] is simple cannot insert into a complex variable");
        }
        ComplexCollection collection = !var.isCollection() ? (ComplexCollection)var.addCollection() : (ComplexCollection)var.getCollection();
        collection.insert(object);
    }

    public static void delete(SCESession mySession, String varName) {
        IVariable var = mySession.getVariable(varName);
        if (!var.isCollection()) {
            throw new VariableTypeException("Variable [" + varName.toString() + "] is not a collection");
        }
        ICollection collection = var.getCollection();
        collection.delete();
    }

    public void dispose() {
        this.fieldNames = null;
        this.fields = null;
        this.values.clear();
        this.values = null;
        this.varName = null;
    }

    public int mark() {
        if (this.index != -1) {
            this.mark = this.index - 1;
        }
        return this.mark;
    }

    public void resetToMark() {
        int i;
        Object[] val;
        if (this.index > 0) {
            val = this.values.get(this.index - 1);
            for (i = 0; i < this.fields.length; ++i) {
                val[i] = this.fields[i].getObjectValue();
            }
        }
        if (this.mark != -1) {
            this.index = this.mark;
            val = this.values.get(this.index);
            for (i = 0; i < val.length; ++i) {
                this.fields[i].setValue(val[i]);
            }
            ++this.index;
        } else {
            this.index = 0;
        }
    }
}

