/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;
import java.math.BigDecimal;
import java.math.RoundingMode;

public abstract class Math
extends AssignmentOperation {
    static final int ADD = 1;
    static final int SUB = 2;
    static final int MUL = 3;
    static final int DIV = 4;
    static final int MOD = 5;
    String destName;
    String operand1;
    boolean op1ISConstant;
    String operand2;
    boolean op2ISConstant;

    public Math(String destName, String operand1, boolean op1IsConstant, String operand2, boolean op2IsConstant) {
        this.destName = destName;
        this.operand1 = operand1;
        this.op1ISConstant = op1IsConstant;
        this.operand2 = operand2;
        this.op2ISConstant = op2IsConstant;
    }

    public void evaluate(IRuntimeSession mySession, int op) {
        BigDecimal result = new BigDecimal(0);
        if (mySession.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer();
            switch (op) {
                case 1: {
                    sb.append("Adding [");
                    break;
                }
                case 2: {
                    sb.append("Subtracting [");
                    break;
                }
                case 3: {
                    sb.append("Multiplying [");
                    break;
                }
                case 4: {
                    sb.append("Dividing [");
                    break;
                }
                case 5: {
                    sb.append("Modulus [");
                    break;
                }
            }
            sb.append(this.operand1);
            sb.append("] and [");
            sb.append(this.operand2);
            sb.append("] to [");
            sb.append(this.destName);
            sb.append("]");
            mySession.getTraceOutput().writeln(2, sb.toString());
        }
        BigDecimal value1 = this.op1ISConstant ? new BigDecimal(this.operand1) : this.getBigDecimalValue(mySession, new VariableName(this.operand1));
        BigDecimal value2 = this.op2ISConstant ? new BigDecimal(this.operand2) : this.getBigDecimalValue(mySession, new VariableName(this.operand2));
        switch (op) {
            case 1: {
                result = value1.add(value2);
                break;
            }
            case 2: {
                result = value1.subtract(value2);
                break;
            }
            case 3: {
                result = value1.multiply(value2);
                break;
            }
            case 4: {
                result = value1.divide(value2, 20, RoundingMode.HALF_EVEN);
                break;
            }
            case 5: {
                result = value1.remainder(value2);
                break;
            }
        }
        IVariableField field = mySession.getVariableField(new VariableName(this.destName));
        this.setField(field, result, true);
    }
}

