/*
 * Decompiled with CFR 0.152.
 */
package com.isavvix.tools;

import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import com.isavvix.tools.FileInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;

public class HttpMultiPartParser {
    private final int ONE_MB = 0x100000;
    private static final String CONTENT_DISPOSITION = "Content-Disposition:";
    private static final String CONTENT_TYPE = "Content-Type:";
    private static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding:";
    private SCESession mySession;
    private boolean isWebData;

    public HttpMultiPartParser() {
        this.mySession = null;
    }

    public HttpMultiPartParser(SCESession mySession) {
        this.mySession = mySession;
        String runtimeNature = mySession.getServlet().getServletContext().getInitParameter("runtime-nature");
        if (runtimeNature != null) {
            this.isWebData = runtimeNature.equalsIgnoreCase("web");
        }
    }

    public Hashtable parseData(ServletInputStream data, String boundary, String saveInDir) throws IllegalArgumentException, IOException {
        return this.processData(data, boundary, saveInDir);
    }

    public Hashtable parseData(ServletInputStream data, String boundary) throws IllegalArgumentException, IOException {
        return this.processData(data, boundary, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Hashtable processData(ServletInputStream is, String boundary, String saveInDir) throws IllegalArgumentException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream");
        }
        if (boundary == null || boundary.trim().length() < 1) {
            throw new IllegalArgumentException("boundary");
        }
        boundary = "--" + boundary;
        StringTokenizer stLine = null;
        StringTokenizer stFields = null;
        FileInfo fileInfo = null;
        Hashtable<String, Object> dataTable = new Hashtable<String, Object>(5);
        String line = null;
        String field = null;
        String paramName = null;
        boolean saveFiles = saveInDir != null && saveInDir.trim().length() > 0;
        boolean isFile = false;
        if (saveFiles) {
            File f = new File(saveInDir);
            f.mkdirs();
        }
        if ((line = this.getLine(is)) == null || !line.startsWith(boundary)) {
            return dataTable;
        }
        while (line != null) {
            if (line == null || !line.startsWith(boundary)) {
                return dataTable;
            }
            boolean headersDone = false;
            while (!headersDone) {
                line = this.getLine(is);
                if (line == null) {
                    return dataTable;
                }
                if (line.startsWith(CONTENT_DISPOSITION)) {
                    stLine = new StringTokenizer(line, ";\r\n");
                    if (stLine.countTokens() < 2) {
                        throw new IllegalArgumentException("Bad data in second line");
                    }
                    line = stLine.nextToken().toLowerCase();
                    if (line.indexOf("form-data") < 0) {
                        throw new IllegalArgumentException("Bad data in second line");
                    }
                    stFields = new StringTokenizer(stLine.nextToken(), "=\"");
                    if (stFields.countTokens() < 2) {
                        throw new IllegalArgumentException("Bad data in second line");
                    }
                    fileInfo = new FileInfo();
                    stFields.nextToken();
                    paramName = stFields.nextToken();
                    isFile = false;
                    if (stLine.hasMoreTokens()) {
                        field = stLine.nextToken();
                        stFields = new StringTokenizer(field, "=\"");
                        if (stFields.countTokens() > 1) {
                            if (stFields.nextToken().trim().equalsIgnoreCase("filename")) {
                                fileInfo.setName(paramName);
                                String value = stFields.nextToken();
                                if (value == null || value.trim().length() <= 0) throw new IOException("Disposition filename invalid");
                                if (value.lastIndexOf(".") > 0) {
                                    fileInfo.setExtension(value.substring(value.lastIndexOf(".")));
                                }
                                fileInfo.setClientFileName(value);
                                isFile = true;
                            }
                        } else if (field.toLowerCase().indexOf("filename") >= 0) {
                            if (!this.isWebData) throw new IOException("Disposition filename missing");
                            line = this.getLine(is);
                            line = this.getLine(is);
                            line = this.getLine(is);
                            line = this.getLine(is);
                            continue;
                        }
                    }
                }
                if (line.startsWith(CONTENT_TYPE) && isFile && line.trim().length() >= 1) {
                    stLine = new StringTokenizer(line, ": ");
                    if (stLine.countTokens() < 2) {
                        throw new IllegalArgumentException("Bad data in Content-Type line");
                    }
                    stLine.nextToken();
                    fileInfo.setFileContentType(stLine.nextToken());
                }
                if (line.startsWith(CONTENT_TRANSFER_ENCODING) && isFile && line.trim().length() >= 1) {
                    stLine = new StringTokenizer(line, ": ");
                    if (stLine.countTokens() < 2) {
                        throw new IllegalArgumentException("Bad data in Content-Transfer-Encoding line");
                    }
                    stLine.nextToken();
                    fileInfo.setTransferEncoding(stLine.nextToken().toLowerCase());
                }
                if (line.length() != 0) continue;
                headersDone = true;
            }
            if (!isFile || fileInfo.getFileContentType() == null) {
                StringBuffer sb = new StringBuffer();
                line = this.getTextValue(is, sb, boundary);
                dataTable.put(paramName, sb.toString());
                if (line != null) continue;
                return dataTable;
            }
            try {
                OutputStream os = null;
                String path = null;
                if (saveFiles) {
                    IVariableField sessionField = this.mySession.getVariableField("session", "ani");
                    char[] arr = new char[]{};
                    if (sessionField != null) {
                        arr = sessionField.getStringValue().toCharArray();
                        for (int i = 0; i < sessionField.getStringValue().length(); ++i) {
                            if (arr[i] >= ' ' && arr[i] != '|' && arr[i] != '\\' && arr[i] != '?' && arr[i] != '*' && arr[i] != '<' && arr[i] != '\"' && arr[i] != ':' && arr[i] != '>' && arr[i] != '+' && arr[i] != '[' && arr[i] != ']' && arr[i] != '/') continue;
                            arr[i] = 45;
                        }
                    }
                    String tempFile = "file_" + new String(arr) + "_";
                    File outFile = File.createTempFile(tempFile, fileInfo.getExtension(), new File(saveInDir));
                    String fileName = outFile.getName();
                    path = this.getFileName(saveInDir, fileName);
                    os = new FileOutputStream(path);
                } else {
                    os = new ByteArrayOutputStream(0x100000);
                }
                boolean readingContent = true;
                byte[] previousLine = new byte[0x100000];
                byte[] temp = null;
                byte[] currentLine = new byte[0x100000];
                int read = is.readLine(previousLine, 0, previousLine.length);
                if (read == -1) {
                    return dataTable;
                }
                while (readingContent) {
                    int read3 = is.readLine(currentLine, 0, currentLine.length);
                    if (read3 == -1) {
                        line = null;
                        break;
                    }
                    if (this.compareBoundary(boundary, currentLine)) {
                        os.write(previousLine, 0, read);
                        os.flush();
                        line = new String(currentLine, 0, read3);
                        break;
                    }
                    os.write(previousLine, 0, read);
                    os.flush();
                    temp = currentLine;
                    currentLine = previousLine;
                    previousLine = temp;
                    read = read3;
                }
                os.close();
                temp = null;
                previousLine = null;
                currentLine = null;
                if (!saveFiles) {
                    ByteArrayOutputStream baos = os;
                    fileInfo.setFileContents(baos.toByteArray());
                } else {
                    fileInfo.setLocalFile(new File(path));
                    os = null;
                }
                dataTable.put(paramName, fileInfo);
            }
            catch (Exception e) {
                throw new SCERuntimeException("Error Saving Data", e);
            }
        }
        return dataTable;
    }

    private boolean compareBoundary(String boundary, byte[] ba) {
        if (boundary == null || ba == null) {
            return false;
        }
        for (int i = 0; i < boundary.length(); ++i) {
            if ((byte)boundary.charAt(i) == ba[i]) continue;
            return false;
        }
        return true;
    }

    private synchronized String getLine(ServletInputStream sis) throws IOException {
        int index;
        byte[] b = new byte[4096];
        int read = sis.readLine(b, 0, b.length);
        String line = null;
        if (read != -1 && (index = (line = new String(b, 0, read)).indexOf(10)) >= 0) {
            line = line.substring(0, index - 1);
        }
        b = null;
        return line;
    }

    private synchronized String getTextValue(ServletInputStream sis, StringBuffer sb, String boundary) throws IOException {
        int contentLength = this.mySession.getRequest().getContentLength();
        byte[] b = new byte[contentLength];
        String line = null;
        int read = sis.readLine(b, 0, b.length);
        while (read != -1 && !(line = new String(b, 0, read, "UTF-8")).startsWith(boundary)) {
            sb.append(line);
            line = null;
            read = sis.readLine(b, 0, b.length);
        }
        b = null;
        return line;
    }

    private String getFileName(String dir, String fileName) throws IllegalArgumentException {
        String path = null;
        if (dir == null || fileName == null) {
            throw new IllegalArgumentException("dir or fileName is null");
        }
        int index = fileName.lastIndexOf(47);
        String name = null;
        name = index >= 0 ? fileName.substring(index + 1) : fileName;
        if ((index = name.lastIndexOf(92)) >= 0) {
            fileName = name.substring(index + 1);
        }
        path = dir + File.separator + fileName;
        if (File.separatorChar == '/') {
            return path.replace('\\', File.separatorChar);
        }
        return path.replace('/', File.separatorChar);
    }
}

