/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.ComplexCollection;
import com.avaya.sce.runtime.VariableField;
import com.avaya.sce.runtime.variablefactory.IComplexVariableFactory;
import com.avaya.sce.runtime.variablefactory.VariableFactoryController;
import com.avaya.sce.runtimecommon.ICollection;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableTypeException;
import java.util.HashMap;
import java.util.Set;

public class ComplexVariable
implements IVariable,
IComplexVariable {
    ICollection collection = null;
    String[] fieldNames;
    IVariableField[] fields;
    String name;
    boolean transparent = false;

    protected ComplexVariable() {
    }

    ComplexVariable(String name, String[] fieldNames) {
        this.name = name;
        this.fieldNames = fieldNames;
        this.fields = new IVariableField[fieldNames.length];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new VariableField("");
        }
    }

    ComplexVariable(String name, String[] fieldNames, String[] values) {
        this.name = name;
        this.fieldNames = fieldNames;
        this.fields = new IVariableField[fieldNames.length];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new VariableField(values[i]);
        }
    }

    public void setCollection(ICollection collection) {
        this.collection = collection;
    }

    public ICollection addCollection() {
        this.collection = new ComplexCollection(this.getComplexVariable(), this.getName());
        return this.collection;
    }

    public void removeCollection() {
        this.collection = null;
    }

    public static IVariable createComplexVariable(String name, String[] fields, String[] values, String factoryId, SCESession session, boolean isCollection, boolean transparencyAllowed) {
        ComplexVariable var = null;
        IComplexVariableFactory factory = null;
        if (factoryId == null) {
            var = new ComplexVariable(name, fields, values);
        } else {
            try {
                if (session.isDDTraceEnabled()) {
                    session.getTraceOutput().writeln(1, "Creating variable [" + name + "] from factory [" + factoryId + "]");
                }
                factory = VariableFactoryController.getComplexInstance(factoryId);
            }
            catch (Exception e) {
                session.throwRTException("Unable to get instance of " + factoryId);
            }
            var = factory.createVariable(name, fields, values, (IRuntimeSession)session);
        }
        if (isCollection) {
            ICollection collection = var.addCollection();
            collection.append();
        }
        var.setTransparency(transparencyAllowed);
        return var;
    }

    public static IVariable createComplexVariable(String name, String[] fields, String factoryId, SCESession session, boolean isCollection, boolean transparencyAllowed) {
        ComplexVariable var = null;
        IComplexVariableFactory factory = null;
        if (factoryId == null) {
            var = new ComplexVariable(name, fields);
        } else {
            try {
                if (session.isDDTraceEnabled()) {
                    session.getTraceOutput().writeln(1, "Creating variable [" + name + "] from factory [" + factoryId + "]");
                }
                factory = VariableFactoryController.getComplexInstance(factoryId);
            }
            catch (Exception e) {
                session.throwRTException("Unable to get instance of " + factoryId);
            }
            var = factory.createVariable(name, fields, (IRuntimeSession)session);
        }
        if (isCollection) {
            ICollection collection = var.addCollection();
            collection.append();
        }
        var.setTransparency(transparencyAllowed);
        return var;
    }

    public ICollection getCollection() throws VariableTypeException {
        return this.collection;
    }

    public IComplexVariable getComplexVariable() throws VariableTypeException {
        return this;
    }

    public IVariableField getSimpleVariable() throws VariableTypeException {
        throw new VariableTypeException("Variable [" + this.name + "] is complex cannot convert to simple");
    }

    public boolean isCollection() {
        return this.collection != null;
    }

    public boolean isComplexVariable() {
        return true;
    }

    public boolean isSimpleVariable() {
        return false;
    }

    public IVariableField getField(String fieldName) {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!fieldName.equalsIgnoreCase(this.fieldNames[i].toLowerCase())) continue;
            return this.fields[i];
        }
        return null;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public IVariableField[] getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public static void set(SCESession mySession, String varName, Object[] object) {
        IVariable var = mySession.getVariable(varName);
        if (var.isComplexVariable()) {
            IComplexVariable complex = var.getComplexVariable();
            IVariableField[] fields = complex.getFields();
            if (fields.length != object.length) {
                throw new VariableTypeException("[" + varName + "] Number of variable fields does not match the number of values");
            }
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setValue(object[i]);
            }
        } else {
            throw new VariableTypeException("Variable [" + varName + "] is simple cannot set as complex variable");
        }
    }

    public static void set(SCESession mySession, String varName, HashMap<String, Object> values) {
        IVariable var = mySession.getVariable(varName);
        if (var.isComplexVariable()) {
            IComplexVariable complex = var.getComplexVariable();
            Set<String> keys = values.keySet();
            for (String key : keys) {
                Object o = values.get(key);
                IVariableField field = complex.getField(key);
                if (field != null) {
                    field.setValue(o);
                    continue;
                }
                throw new VariableTypeException("field [" + key + "] is not a member of  [" + varName + "]");
            }
        } else {
            throw new VariableTypeException("Variable [" + varName + "] is simple cannot set as complex variable");
        }
    }

    public void dispose() {
        this.fieldNames = null;
        this.fields = null;
        this.name = null;
        if (this.collection != null) {
            this.collection.dispose();
        }
    }

    public boolean allowsTransparency() {
        return this.transparent;
    }

    public void setTransparency(boolean value) {
        this.transparent = value;
    }

    public IVariable clone(SCESession session, String newName) {
        IVariable cloneVariable = null;
        String[] variableFields = this.getFieldNames();
        String cloneName = this.getName();
        if (newName != null) {
            cloneName = newName;
        }
        cloneVariable = ComplexVariable.createComplexVariable(cloneName, variableFields, null, session, false, this.transparent);
        IVariable sourceVar = session.getVariable(this.getName());
        IVariableField[] sourceFields = sourceVar.getComplexVariable().getFields();
        IVariable destVar = cloneVariable;
        IVariableField[] destFields = destVar.getComplexVariable().getFields();
        if (sourceVar.isCollection()) {
            ICollection sourceCollection = sourceVar.getCollection();
            destVar.addCollection();
            ICollection destCollection = destVar.getCollection();
            sourceCollection.reset();
            destCollection.reset();
            while (sourceCollection.hasMore()) {
                sourceCollection.next();
                for (int i = 0; i < sourceFields.length; ++i) {
                    destFields[i].setValue(sourceFields[i].getObjectValue());
                }
                destCollection.append();
            }
            sourceCollection.reset();
            destCollection.reset();
        } else {
            for (int i = 0; i < sourceFields.length; ++i) {
                destFields[i].setValue(sourceFields[i].getObjectValue());
            }
        }
        return cloneVariable;
    }
}

