/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.Event;
import com.avaya.sce.runtime.IGenerator;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.InputCommon;
import com.avaya.sce.runtime.OnDisconnect;
import com.avaya.sce.runtime.Submit;
import java.util.Collection;

public class Record
extends InputCommon
implements IGenerator {
    public static final String WAV_TYPE = "audio/x-wav";
    public static final String ALAW_TYPE = "audio/x-alaw-basic";
    public static final String BASIC_TYPE = "audio/basic";
    public static final String RECORDMODE_AUDIO = "audio";
    public static final String RECORDMODE_AUDIOVIDEO = "audio video";
    public static final String RECORDMODE_VIDEO = "video";
    private boolean beep;
    private String maxtime;
    private boolean modal;
    private String finalSilence;
    private boolean dtfmTerm;
    private String type;
    private Collection events;
    private String mode;

    public Record(String name, boolean beep, String maxtime, boolean modal, String finalSilence, boolean dtfmTerm, String type, String mode, Collection promptNames, Collection grammarInfos, Collection events) {
        super(name, grammarInfos, promptNames);
        this.beep = beep;
        this.maxtime = maxtime;
        this.modal = modal;
        this.dtfmTerm = dtfmTerm;
        this.type = type;
        this.events = events;
        this.finalSilence = finalSilence;
        this.mode = mode;
    }

    @Override
    public void generate(IOutputGenerator generator) {
        this.loadPrompts(generator.getMySession());
        this.loadGrammars(generator.getMySession());
        generator.recordBegin(this, this.prompts);
        this.genPrompts(generator);
        this.genGrammars(generator);
        if (this.events != null) {
            for (Event event : this.events) {
                OnDisconnect disconnectEvent;
                if (event instanceof OnDisconnect && (disconnectEvent = (OnDisconnect)event).isSubmit()) {
                    Submit disconnectSubmit = (Submit)generator.getMySession().getProperty("dd.form.completedsubmit");
                    try {
                        disconnectSubmit = (Submit)disconnectSubmit.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        disconnectSubmit = (Submit)generator.getMySession().getProperty("dd.form.completedsubmit");
                    }
                    disconnectSubmit.setNext(disconnectEvent.getNext());
                    disconnectEvent.setSubmitObject(disconnectSubmit);
                    disconnectEvent.setRecord(this);
                }
                event.generate(generator);
            }
        }
        generator.recordEnd(this);
        this.cleanup();
        if (this.events != null) {
            this.events.clear();
            this.events = null;
        }
    }

    public boolean isBeep() {
        return this.beep;
    }

    public boolean isDtfmTerm() {
        return this.dtfmTerm;
    }

    public String getMaxtime() {
        return this.maxtime;
    }

    public boolean isModal() {
        return this.modal;
    }

    public String getType() {
        return this.type;
    }

    public String getMode() {
        return this.mode;
    }

    public String getFinalSilence() {
        return this.finalSilence;
    }

    public Collection getEvents() {
        return this.events;
    }

    public void setEvents(Collection events) {
        this.events = events;
    }

    public void setBeep(boolean beep) {
        this.beep = beep;
    }

    public void setDtfmTerm(boolean dtfmTerm) {
        this.dtfmTerm = dtfmTerm;
    }

    public void setFinalSilence(String finalSilence) {
        this.finalSilence = finalSilence;
    }

    public void setMaxtime(String maxtime) {
        this.maxtime = maxtime;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

