/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import java.util.HashMap;

public class VariableField
implements IVariableField {
    Object value;
    IVariableField.VarDataType type;
    HashMap<String, Object> attributes;

    private void init() {
        this.attributes = new HashMap();
        this.attributes.put("avaya.dd.settable", true);
        this.attributes.put("avaya.dd.private", false);
    }

    protected VariableField() {
        this.init();
    }

    VariableField(String value) {
        this.value = value;
        this.type = IVariableField.VarDataType.STRING;
        this.init();
    }

    VariableField(int value) {
        this.value = new Integer(value);
        this.type = IVariableField.VarDataType.INT;
        this.init();
    }

    VariableField(Integer value) {
        this.value = value;
        this.type = IVariableField.VarDataType.INT;
        this.init();
    }

    VariableField(long value) {
        this.value = new Long(value);
        this.type = IVariableField.VarDataType.LONG;
        this.init();
    }

    VariableField(Long value) {
        this.value = value;
        this.type = IVariableField.VarDataType.LONG;
        this.init();
    }

    VariableField(byte value) {
        this.value = new Byte(value);
        this.type = IVariableField.VarDataType.BYTE;
        this.init();
    }

    VariableField(Byte value) {
        this.value = value;
        this.type = IVariableField.VarDataType.BYTE;
        this.init();
    }

    VariableField(short value) {
        this.value = new Short(value);
        this.type = IVariableField.VarDataType.SHORT;
        this.init();
    }

    VariableField(Short value) {
        this.value = value;
        this.type = IVariableField.VarDataType.SHORT;
        this.init();
    }

    VariableField(double value) {
        this.value = new Double(value);
        this.type = IVariableField.VarDataType.DOUBLE;
        this.init();
    }

    VariableField(Double value) {
        this.value = value;
        this.type = IVariableField.VarDataType.DOUBLE;
        this.init();
    }

    VariableField(float value) {
        this.value = new Float(value);
        this.type = IVariableField.VarDataType.FLOAT;
        this.init();
    }

    VariableField(Float value) {
        this.value = value;
        this.type = IVariableField.VarDataType.FLOAT;
        this.init();
    }

    VariableField(boolean value) {
        this.value = new Boolean(value);
        this.type = IVariableField.VarDataType.BOOLEAN;
        this.init();
    }

    VariableField(Boolean value) {
        this.value = value;
        this.type = IVariableField.VarDataType.BOOLEAN;
        this.init();
    }

    VariableField(Object value) {
        this.value = value;
        this.type = IVariableField.VarDataType.OBJECT;
        this.init();
    }

    public void setValue(int value) {
        this.value = new Integer(value);
        this.type = IVariableField.VarDataType.INT;
    }

    public void setValue(Integer value) {
        this.value = value;
        this.type = IVariableField.VarDataType.INT;
    }

    public void setValue(byte value) {
        this.value = new Byte(value);
        this.type = IVariableField.VarDataType.BYTE;
    }

    public void setValue(Byte value) {
        this.value = value;
        this.type = IVariableField.VarDataType.BYTE;
    }

    public void setValue(short value) {
        this.value = new Short(value);
        this.type = IVariableField.VarDataType.SHORT;
    }

    public void setValue(Short value) {
        this.value = value;
        this.type = IVariableField.VarDataType.SHORT;
    }

    public void setValue(double value) {
        this.value = new Double(value);
        this.type = IVariableField.VarDataType.DOUBLE;
    }

    public void setValue(Double value) {
        this.value = value;
        this.type = IVariableField.VarDataType.DOUBLE;
    }

    public void setValue(String value) {
        this.value = value;
        this.type = IVariableField.VarDataType.STRING;
    }

    public void setValue(long value) {
        this.value = new Long(value);
        this.type = IVariableField.VarDataType.LONG;
    }

    public void setValue(Long value) {
        this.value = value;
        this.type = IVariableField.VarDataType.LONG;
    }

    public void setValue(float value) {
        this.value = new Float(value);
        this.type = IVariableField.VarDataType.FLOAT;
    }

    public void setValue(Float value) {
        this.value = value;
        this.type = IVariableField.VarDataType.FLOAT;
    }

    public void setValue(boolean value) {
        this.value = new Boolean(value);
        this.type = IVariableField.VarDataType.BOOLEAN;
    }

    public void setValue(Boolean value) {
        this.value = value;
        this.type = IVariableField.VarDataType.BOOLEAN;
    }

    public void setValue(Object value) {
        this.value = value;
        this.type = IVariableField.VarDataType.OBJECT;
    }

    public void setValue(Object value, IVariableField.VarDataType type) {
        this.value = value;
        this.type = type;
    }

    public void updateValueForGet() {
    }

    public String getStringValue() {
        this.updateValueForGet();
        if (this.type == IVariableField.VarDataType.INT) {
            return ((Integer)this.value).toString();
        }
        if (this.type == IVariableField.VarDataType.STRING) {
            return (String)this.value;
        }
        if (this.type == IVariableField.VarDataType.LONG) {
            return ((Long)this.value).toString();
        }
        if (this.type == IVariableField.VarDataType.BYTE) {
            return ((Byte)this.value).toString();
        }
        if (this.type == IVariableField.VarDataType.SHORT) {
            return ((Short)this.value).toString();
        }
        if (this.type == IVariableField.VarDataType.DOUBLE) {
            return ((Double)this.value).toString();
        }
        if (this.type == IVariableField.VarDataType.FLOAT) {
            return ((Float)this.value).toString();
        }
        if (this.type == IVariableField.VarDataType.BOOLEAN) {
            return ((Boolean)this.value).toString();
        }
        if (this.type == IVariableField.VarDataType.OBJECT) {
            return this.value.toString();
        }
        return (String)this.value;
    }

    public int getIntValue() {
        this.updateValueForGet();
        if (this.type == IVariableField.VarDataType.INT) {
            return (Integer)this.value;
        }
        if (this.type == IVariableField.VarDataType.STRING) {
            return Integer.parseInt(((String)this.value).trim());
        }
        if (this.type == IVariableField.VarDataType.LONG) {
            return Integer.parseInt(((Long)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.BYTE) {
            return Integer.parseInt(((Byte)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.SHORT) {
            return Integer.parseInt(((Short)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.DOUBLE) {
            return Integer.parseInt(((Double)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.FLOAT) {
            return Integer.parseInt(((Float)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.BOOLEAN) {
            boolean b = (Boolean)this.value;
            if (b) {
                return 1;
            }
            return 0;
        }
        if (this.type == IVariableField.VarDataType.OBJECT) {
            return Integer.parseInt(this.value.toString().trim());
        }
        throw new SCERuntimeException("to int not supported for type " + this.type);
    }

    public long getLongValue() {
        this.updateValueForGet();
        if (this.type == IVariableField.VarDataType.INT) {
            return ((Integer)this.value).intValue();
        }
        if (this.type == IVariableField.VarDataType.STRING) {
            return Long.parseLong(((String)this.value).trim());
        }
        if (this.type == IVariableField.VarDataType.LONG) {
            return (Long)this.value;
        }
        if (this.type == IVariableField.VarDataType.BYTE) {
            return Long.parseLong(((Byte)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.FLOAT) {
            return Long.parseLong(((Float)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.SHORT) {
            return Long.parseLong(((Short)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.DOUBLE) {
            return Long.parseLong(((Double)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.BOOLEAN) {
            boolean b = (Boolean)this.value;
            if (b) {
                return 1L;
            }
            return 0L;
        }
        if (this.type == IVariableField.VarDataType.OBJECT) {
            return Long.parseLong(this.value.toString());
        }
        throw new SCERuntimeException("to long not supported for type " + this.type);
    }

    public float getFloatValue() {
        this.updateValueForGet();
        if (this.type == IVariableField.VarDataType.INT) {
            return ((Integer)this.value).intValue();
        }
        if (this.type == IVariableField.VarDataType.STRING) {
            return Float.parseFloat(((String)this.value).trim());
        }
        if (this.type == IVariableField.VarDataType.LONG) {
            return Float.parseFloat(((Long)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.BYTE) {
            return Float.parseFloat(((Byte)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.SHORT) {
            return Float.parseFloat(((Short)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.DOUBLE) {
            return Float.parseFloat(((Double)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.FLOAT) {
            return ((Float)this.value).floatValue();
        }
        if (this.type == IVariableField.VarDataType.BOOLEAN) {
            boolean b = (Boolean)this.value;
            if (b) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (this.type == IVariableField.VarDataType.OBJECT) {
            return Float.parseFloat(this.value.toString());
        }
        throw new SCERuntimeException("to float not supported for type " + this.type);
    }

    public short getShortValue() {
        this.updateValueForGet();
        if (this.type == IVariableField.VarDataType.INT) {
            return Short.parseShort(((Integer)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.STRING) {
            return Short.parseShort(((String)this.value).trim());
        }
        if (this.type == IVariableField.VarDataType.LONG) {
            return Short.parseShort(((Long)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.BYTE) {
            return Short.parseShort(((Byte)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.SHORT) {
            return (Short)this.value;
        }
        if (this.type == IVariableField.VarDataType.DOUBLE) {
            return Short.parseShort(((Double)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.FLOAT) {
            return Short.parseShort(((Float)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.BOOLEAN) {
            boolean b = (Boolean)this.value;
            if (b) {
                return 1;
            }
            return 0;
        }
        if (this.type == IVariableField.VarDataType.OBJECT) {
            return Short.parseShort(this.value.toString().trim());
        }
        throw new SCERuntimeException("to short not supported for type " + this.type);
    }

    public double getDoubleValue() {
        this.updateValueForGet();
        if (this.type == IVariableField.VarDataType.INT) {
            return Double.parseDouble(((Integer)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.STRING) {
            return Double.parseDouble(((String)this.value).trim());
        }
        if (this.type == IVariableField.VarDataType.LONG) {
            return Double.parseDouble(((Long)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.BYTE) {
            return Double.parseDouble(((Byte)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.SHORT) {
            return Double.parseDouble(((Short)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.DOUBLE) {
            return (Double)this.value;
        }
        if (this.type == IVariableField.VarDataType.FLOAT) {
            return Double.parseDouble(((Float)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.BOOLEAN) {
            boolean b = (Boolean)this.value;
            if (b) {
                return 1.0;
            }
            return 0.0;
        }
        if (this.type == IVariableField.VarDataType.OBJECT) {
            return Double.parseDouble(this.value.toString().trim());
        }
        throw new SCERuntimeException("to Integer not supported for type " + this.type);
    }

    public byte getByteValue() {
        this.updateValueForGet();
        if (this.type == IVariableField.VarDataType.INT) {
            return Byte.parseByte(((Integer)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.STRING) {
            return Byte.parseByte(((String)this.value).trim());
        }
        if (this.type == IVariableField.VarDataType.LONG) {
            return Byte.parseByte(((Long)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.BYTE) {
            return (Byte)this.value;
        }
        if (this.type == IVariableField.VarDataType.SHORT) {
            return Byte.parseByte(((Short)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.DOUBLE) {
            return Byte.parseByte(((Double)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.FLOAT) {
            return Byte.parseByte(((Float)this.value).toString().trim());
        }
        if (this.type == IVariableField.VarDataType.BOOLEAN) {
            boolean b = (Boolean)this.value;
            if (b) {
                return 1;
            }
            return 0;
        }
        if (this.type == IVariableField.VarDataType.OBJECT) {
            return Byte.parseByte(this.value.toString().trim());
        }
        throw new SCERuntimeException("to Integer not supported for type " + this.type);
    }

    public boolean getBooleanValue() {
        this.updateValueForGet();
        if (this.type == IVariableField.VarDataType.INT) {
            int i = (Integer)this.value;
            return i != 0;
        }
        if (this.type == IVariableField.VarDataType.STRING) {
            String s = (String)this.value;
            return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("1");
        }
        if (this.type == IVariableField.VarDataType.LONG) {
            long l = (Long)this.value;
            return l != 0L;
        }
        if (this.type == IVariableField.VarDataType.SHORT) {
            short s = (Short)this.value;
            return s != 0;
        }
        if (this.type == IVariableField.VarDataType.DOUBLE) {
            double d = (Double)this.value;
            return d != 0.0;
        }
        if (this.type == IVariableField.VarDataType.FLOAT) {
            float f = ((Float)this.value).floatValue();
            return f != 0.0f;
        }
        if (this.type == IVariableField.VarDataType.BOOLEAN) {
            boolean b = (Boolean)this.value;
            return b;
        }
        if (this.type == IVariableField.VarDataType.OBJECT) {
            String s = this.value.toString();
            return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("1");
        }
        throw new SCERuntimeException("to Integer not supported for type " + this.type);
    }

    public Object getObjectValue() {
        this.updateValueForGet();
        return this.value;
    }

    public Object getObjectValueFor(IVariableField.VarDataType type) {
        this.updateValueForGet();
        switch (type) {
            case INT: {
                if (this.type == type) {
                    return this.value;
                }
                return new Integer(this.getIntValue());
            }
            case STRING: {
                if (this.type == type) {
                    return this.value;
                }
                return new String(this.getStringValue());
            }
            case LONG: {
                if (this.type == type) {
                    return this.value;
                }
                return new Long(this.getLongValue());
            }
            case BYTE: {
                if (this.type == type) {
                    return this.value;
                }
                return new Byte(this.getByteValue());
            }
            case SHORT: {
                if (this.type == type) {
                    return this.value;
                }
                return new Short(this.getShortValue());
            }
            case DOUBLE: {
                if (this.type == type) {
                    return this.value;
                }
                return new Double(this.getDoubleValue());
            }
            case FLOAT: {
                if (this.type == type) {
                    return this.value;
                }
                return new Float(this.getFloatValue());
            }
            case BOOLEAN: {
                if (this.type == type) {
                    return this.value;
                }
                return new Boolean(this.getBooleanValue());
            }
            case OBJECT: {
                return this.value;
            }
        }
        throw new SCERuntimeException("type not supported " + type);
    }

    public void dispose() {
        this.value = null;
    }

    public boolean isSettable() {
        Boolean isSettable = (Boolean)this.getAttribute("avaya.dd.settable");
        return isSettable;
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public void setAttribute(String attributeName, Object value) {
        this.attributes.put(attributeName, value);
    }

    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
    }

    public String toString() {
        return this.getStringValue();
    }
}

