/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.html;

import com.avaya.ade.common.utils.xml.XML;
import com.avaya.sce.runtime.AppDocument;
import com.avaya.sce.runtime.CaptureExpression;
import com.avaya.sce.runtime.Choice;
import com.avaya.sce.runtime.CoordinationPar;
import com.avaya.sce.runtime.CoordinationSeq;
import com.avaya.sce.runtime.Disconnect;
import com.avaya.sce.runtime.DynamicGrammar;
import com.avaya.sce.runtime.Email;
import com.avaya.sce.runtime.EmailInfo;
import com.avaya.sce.runtime.Entry;
import com.avaya.sce.runtime.Event;
import com.avaya.sce.runtime.ExitAction;
import com.avaya.sce.runtime.Field;
import com.avaya.sce.runtime.Form;
import com.avaya.sce.runtime.Format;
import com.avaya.sce.runtime.Goto;
import com.avaya.sce.runtime.Grammar;
import com.avaya.sce.runtime.Handler;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IRuntimeGrammar;
import com.avaya.sce.runtime.IRuntimePrompt;
import com.avaya.sce.runtime.Invoke;
import com.avaya.sce.runtime.Link;
import com.avaya.sce.runtime.MediaElement;
import com.avaya.sce.runtime.MediaInfo;
import com.avaya.sce.runtime.MediaPage;
import com.avaya.sce.runtime.MediaPar;
import com.avaya.sce.runtime.MediaRegion;
import com.avaya.sce.runtime.MediaSeq;
import com.avaya.sce.runtime.MediaText;
import com.avaya.sce.runtime.MediaTextBlock;
import com.avaya.sce.runtime.Menu;
import com.avaya.sce.runtime.MixedInitiativeForm;
import com.avaya.sce.runtime.Parameter;
import com.avaya.sce.runtime.Phrase;
import com.avaya.sce.runtime.PhraseVariableElement;
import com.avaya.sce.runtime.PlatformObject;
import com.avaya.sce.runtime.Prompt;
import com.avaya.sce.runtime.PromptElement;
import com.avaya.sce.runtime.PropertiesGen;
import com.avaya.sce.runtime.Property;
import com.avaya.sce.runtime.Record;
import com.avaya.sce.runtime.Return;
import com.avaya.sce.runtime.ReturnError;
import com.avaya.sce.runtime.Root;
import com.avaya.sce.runtime.RuntimeVersion;
import com.avaya.sce.runtime.SMILLink;
import com.avaya.sce.runtime.SMS;
import com.avaya.sce.runtime.SMSInfo;
import com.avaya.sce.runtime.SessionVarField;
import com.avaya.sce.runtime.Submit;
import com.avaya.sce.runtime.Throw;
import com.avaya.sce.runtime.Transfer;
import com.avaya.sce.runtime.TransferOnError;
import com.avaya.sce.runtime.html.Slot;
import com.avaya.sce.runtime.html.UtterInfo;
import com.avaya.sce.runtime.internal.IconFinder;
import com.avaya.sce.runtime.tracking.Trackable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OutputGenerator
extends com.avaya.sce.runtime.OutputGenerator {
    public OutputGenerator(SCESession mySession) {
        super(mySession);
    }

    private String getQSConnector(String next) {
        if (next.indexOf(63) == -1) {
            return "?";
        }
        return "&";
    }

    private String getNextUrl(String next) {
        String qs = this.getMySession().getRequest().getQueryString();
        if (qs != null) {
            int index = qs.indexOf("sagecall");
            if (index != -1) {
                qs = qs.substring(0, index - 1);
            }
            if (qs.indexOf("___DDSESSIONID") == -1) {
                next = next + this.getQSConnector(next) + "___DDSESSIONID" + "=" + this.mySession.getEncodedSessionId();
                if (qs.startsWith("&")) {
                    return next + qs;
                }
                return next + "&" + qs;
            }
            return next + this.getQSConnector(next) + qs;
        }
        next = next + this.getQSConnector(next) + "___DDSESSIONID" + "=" + this.mySession.getEncodedSessionId();
        return next;
    }

    @Override
    public void begin(AppDocument document) {
        this.out.println("<html>");
        this.out.println("<meta name=\"author\" content=\"Avaya Aura Orchestration Designer\"/>");
        this.out.println("<meta name=\"runtime-version\" content=\"" + RuntimeVersion.getVersion() + "\"/>");
        this.out.println("<meta name=\"copyright\" content=\"Copyright (c) 2002-2017 Avaya\"/>");
        if (document != null && document.getAutoFlush()) {
            URL url = this.mySession.getFileURL("/data/ddfetchAudio.wav");
            this.out.println("<b>Property :</b> fetchaudio = " + url.toString());
        }
    }

    @Override
    public void end(AppDocument document) {
        this.out.println("</html>");
    }

    @Override
    public void setContentType(HttpServletResponse response) {
        response.setContentType("text/html; charset=UTF-8");
    }

    public void generateHeader() {
        String icon = IconFinder.getIconFinder(this.mySession.getCurrentLanguage()).resolveName("header.gif");
        URL url = this.mySession.getFileURL(icon);
        this.out.println("<p align=\"right\">");
        this.out.print("<img src=\"");
        this.out.print(url.toString());
        this.out.print("\">&nbsp;&nbsp;");
        this.out.println("</p><hr>");
    }

    @Override
    public void formBegin(Form form) {
        String name = form.getName();
        this.out.print("<head><title>");
        this.out.print("Form ");
        if (name != null) {
            this.out.print(name);
        }
        this.out.println("</title></head>");
        this.out.println("<body>");
        this.generateHeader();
        this.generateRoot();
        Submit submit = form.getSubmit(this.mySession);
        if (submit != null) {
            if (form instanceof Invoke) {
                this.out.print("<form method=\"POST\"");
                Collection fields = form.getFields(this.mySession);
                this.out.print(" onClick=\"return changeFormAction();\"");
                if (fields != null && fields.size() > 0) {
                    this.out.print(" onSubmit=\"\"");
                }
                this.out.print(" action=\"\"");
                this.out.print(this.getNextUrl(submit.getNext()));
                this.out.println("\">");
            } else {
                this.out.print("<form method=\"POST\"");
                Collection fields = form.getFields(this.mySession);
                Transfer xfer = form.getTransfer(this.mySession);
                if (!(fields == null && xfer == null || fields.size() <= 0 && xfer == null)) {
                    this.out.print(" onSubmit=\"return assignFields();\"");
                }
                this.out.print(" action=\"");
                this.out.print(this.getNextUrl(submit.getNext()));
                this.out.println("\">");
            }
        }
    }

    private void genVXMLShow() {
        String docURI = this.mySession.getRequestCopyURI();
        int index = docURI.lastIndexOf(47);
        String rootURI = "BAD URI";
        if (index != -1) {
            rootURI = docURI.substring(0, index + 1) + "AppRoot";
        }
        this.out.println("<Script language=\"JavaScript\">");
        this.out.println("    function displayDocVXML() {");
        this.out.println("        var mywin;");
        this.out.println("        mywin = window.open(\"" + docURI + "?__Dialog__Designer__VXMLINHTML=true" + "\");");
        this.out.println("        mywin.focus();");
        this.out.println("        return true;");
        this.out.println("    }");
        this.out.println("    function displayRootVXML() {");
        this.out.println("        var mywin;");
        this.out.println("        mywin = window.open(\"" + rootURI + "?__Dialog__Designer__VXMLINHTML=true" + "\");");
        this.out.println("        mywin.focus();");
        this.out.println("        return true;");
        this.out.println("    }");
        this.out.println("</Script>");
        this.out.print("<input type=\"button\" onClick=\"return displayDocVXML();\" value=\"Show Doc VXML\" /input>&nbsp;&nbsp;");
        this.out.print("<input type=\"button\" onClick=\"return displayRootVXML();\" value=\"Show Root VXML\" /input>");
        this.out.println("<br>");
    }

    @Override
    public void formEnd(Form form) {
        Submit submit = form.getSubmit(this.mySession);
        if (submit != null) {
            this.genVXMLShow();
            this.out.println("</form>");
        }
        this.out.println("</body>");
    }

    @Override
    public void menuBegin(Menu menu, Collection prompts, Collection choices) {
        String name = menu.getName();
        this.out.print("<head><title>");
        this.out.print("Menu ");
        if (name != null) {
            this.out.print(name);
        }
        this.out.println("</title></head>");
        this.out.println("<body>");
        this.generateHeader();
        this.generateRoot();
        this.out.print("<br>");
        this.out.println("<Script language=\"JavaScript\">");
        this.out.println("    function setAction( index) {");
        for (Choice choice : choices) {
            this.out.println("    if ( index == " + choice.getId() + " ) {");
            this.out.println("        document.forms[0].action = \"" + this.getNextUrl(choice.getNext()) + "\";");
            this.out.println("        document.forms[0].selchoice.value = \"" + choice.getId() + "\";");
            this.out.println("        return  true ;");
            this.out.println("    }");
        }
        this.out.println("    document.forms[0].action = \"\";");
        this.out.println("    return false;");
        this.out.println("    }");
        this.out.println("</Script>");
        this.out.println("<form method=\"POST\" onSubmit=\"return assignMenuFields();\" action=\"\">");
        this.out.println("<input type=\"hidden\" name=\"selchoice\" value=\"\"/>");
    }

    @Override
    public void menuEnd(Menu menu, Collection choices, PropertiesGen pg) {
        this.generateMenuJS(menu, choices);
        this.out.println("<br><input name=\"submit\" type=\"submit\" value=\"Continue\">");
        this.out.println("</form>");
        this.genVXMLShow();
        this.out.println("</body>");
    }

    @Override
    public void linkBegin(Link link) {
        String dtmf;
        if (link.getNext() != null) {
            this.out.print("<a href=\"");
            this.out.print(this.getNextUrl(link.getNext()));
            this.out.print("\">");
            if (link.getName().length() == 0) {
                this.out.print("unnamed link");
            } else {
                this.out.print(link.getName());
            }
            this.out.print("</a>");
        }
        if ((dtmf = link.getDtmf()) != null && link.getDtmf().length() > 0) {
            if (!link.isDtmfConstant()) {
                dtmf = this.getVariable(dtmf);
            }
            this.out.print(" <b>DTMF :</b> " + dtmf);
        }
        this.out.println();
    }

    @Override
    public void linkPostBegin(Link link) {
    }

    @Override
    public void linkPostEnd(Link link) {
    }

    @Override
    public void linkEnd(Link link) {
        this.out.println("<br>");
    }

    @Override
    public void choiceBegin(Choice choice) {
        this.out.print("<input name=\"choiceSelect input for grammar opt\" type=\"radio\" value=\"" + choice.getId() + "\" onChange=\"setAction(" + choice.getId() + ");\"/>\n");
        this.out.print(choice.getName());
        if (choice.getDtmf() != null) {
            if (choice.isDtmfConstant()) {
                this.out.print(choice.getDtmf());
            } else {
                this.out.print(this.getVariable(choice.getDtmf()));
            }
        }
        this.out.print("&nbsp;");
        this.out.print("&nbsp;");
        this.out.print("&nbsp;");
        this.out.println("&nbsp;");
    }

    @Override
    public void choiceEnd(Choice choice) {
        this.generateChoiceGrammar(choice);
        this.out.println("<br>");
    }

    @Override
    public void grammarBegin(Grammar grammar) {
        if (grammar.isBuiltin()) {
            this.out.print("<b>Builtin grammar</b> ");
            this.out.print("[mode:" + grammar.getMode() + "] : ");
            String value = "builtin:" + grammar.getBuiltinMode() + "/" + grammar.getType();
            if (grammar.getOptions() != null && grammar.getOptions().length() > 0) {
                value = value + "?" + grammar.getOptions();
            }
            this.out.println(value);
        } else {
            String name = grammar.getClass().getName();
            int index = name.lastIndexOf(".");
            if (index != -1) {
                name = name.substring(index + 1);
            }
            this.out.println("<Script language=\"JavaScript\">");
            this.out.println("    function displayGrammar" + name + "() {");
            this.out.println("        var mywin;");
            this.out.println("        mywin = window.open(\"" + grammar.getURL() + "\");");
            this.out.println("        mywin.focus();");
            this.out.println("        return true;");
            this.out.println("    }");
            this.out.println("</Script>");
            this.out.print("<b>Display grammar</b> ");
            this.out.print("[mode:" + grammar.getMode() + "] : ");
            this.out.print("<input type=\"button\" onClick=\"return displayGrammar" + name + "();\" value=\"");
            if (grammar.isExternal()) {
                ServletContext context = this.mySession.getServlet().getServletContext();
                String className = grammar.getClass().getName();
                String uri = context.getInitParameter(className);
                this.out.print(uri);
            } else {
                this.out.print(grammar.getFileName());
            }
            this.out.println("\" /input>");
            this.out.println("<br>");
        }
    }

    private void generateChoiceGrammar(Choice choice) {
        ArrayList<Slot> utteranceList = new ArrayList<Slot>();
        IRuntimeGrammar builtinGrammar = null;
        Collection<IRuntimeGrammar> grammars = choice.getGrammars();
        for (IRuntimeGrammar grammar : grammars) {
            IRuntimeGrammar gram;
            if (grammar instanceof Grammar) {
                gram = (Grammar)grammar;
                if (((Grammar)gram).getFileName() != null && ((Grammar)gram).isExternal() && !((Grammar)gram).getMediaType().equals("application/srgs+xml")) {
                    this.out.println("<b>External Grammar :</b>" + ((Grammar)gram).getFileName() + ":" + ((Grammar)gram).getMediaType() + "is not yet supported in html mode<br>");
                    continue;
                }
                if (((Grammar)gram).isBuiltin()) {
                    builtinGrammar = gram;
                    continue;
                }
                utteranceList.addAll(this.getUtterancesFromUrl(((Grammar)gram).getURL(), ((Grammar)gram).getMode()));
                continue;
            }
            if (grammar instanceof DynamicGrammar) {
                gram = (DynamicGrammar)grammar;
                utteranceList.addAll(this.getUtterancesFromString(((DynamicGrammar)gram).toString(), ((DynamicGrammar)gram).getMode()));
                continue;
            }
            this.out.print("<b>Unknown grammar :</b>" + grammar.getClass().getName());
        }
        if (choice.getDtmf() != null) {
            UtterInfo ui = new UtterInfo();
            ui.utterance = choice.getDtmf();
            ui.mode = "dtmf";
            ui.tag = choice.getDtmf();
            Slot slot = new Slot();
            slot.name = "ddbuiltindtmf" + choice.getId();
            slot.utternaces.add(ui);
            utteranceList.add(slot);
        }
        this.out.println("<b>&nbsp;&nbsp;&nbsp;&nbsp;Select input for grammar :</b>&nbsp;");
        for (Slot slot : utteranceList) {
            ArrayList<UtterInfo> utterances = slot.utternaces;
            this.out.print("<select name=\"");
            this.out.print("choice" + choice.getId() + "___select" + slot.name);
            this.out.println("\" >");
            this.out.print("<option value=\"");
            this.out.println("\">");
            for (UtterInfo info : utterances) {
                this.out.print("<option value=\"");
                this.out.print(info.utterance + "~" + this.cleanTag('\'', this.cleanTag('\"', info.tag)) + "~" + info.mode);
                this.out.print("\">");
                this.out.println(info.utterance);
            }
            this.out.println("</select>");
        }
        if (builtinGrammar != null) {
            this.out.print("<input type=\"hidden\" name=\"");
            this.out.print("choice" + choice.getId() + "___select" + "ddbigram" + "___confidence");
            this.out.println("\" value=\".90\"/>");
            this.out.println("<b>type \"" + ((Grammar)builtinGrammar).getType() + "\":</b>&nbsp;");
            this.out.print("<input type=\"text\" name=\"");
            this.out.print("choice" + choice.getId() + "___select" + "ddbigram" + "___utterance");
            this.out.println("\" value=\"\"/>");
            this.out.print("<input type=\"hidden\" name=\"");
            this.out.print("choice" + choice.getId() + "___select" + "ddbigram" + "___inputmode");
            this.out.println("\" value=\"" + ((Grammar)builtinGrammar).getMode() + "\"/>");
        }
    }

    private void generateMenuJS(Menu menu, Collection choices) {
        ArrayList<String> columns = menu.getColumns(choices);
        this.out.println("<Script language=\"JavaScript\">");
        this.out.println("    function trimString( value ) {");
        this.out.println("        var origvalue = value;");
        this.out.println("        try {");
        this.out.println("            while ( value.charAt(0) == ' ' ) {");
        this.out.println("                value = value.slice(1);");
        this.out.println("            }");
        this.out.println("            return(value);");
        this.out.println("        } catch (errMsg) {");
        this.out.println("            return(origvalue);");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    function checkValue( value, defvalue ) {");
        this.out.println("        try {");
        this.out.println("            var str = new String(value);");
        this.out.println("            var index = str.indexOf( \"undefined\" );");
        this.out.println("            if (index == -1 ) {");
        this.out.println("                return( value );");
        this.out.println("            } else {");
        this.out.println("                return( defvalue );");
        this.out.println("            }");
        this.out.println("        } catch (errMsg) {");
        this.out.println("            return(value);");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    function assignMenuFields() {");
        this.out.println("        var inputmode = \"\";");
        this.out.println("        var utterance = \"\";");
        this.out.println("        var interpretation = \"\";");
        this.out.println("        var names = new Array();");
        this.out.println("        var choice =  document.forms[0].selchoice.value;");
        this.out.println("        ");
        for (Choice choice : choices) {
            this.out.println("        if (choice == " + choice.getId() + ") {");
            Collection<String> names = choice.getUniqueColNames();
            for (String name : names) {
                this.out.println("            names.push('" + name + "');");
            }
            if (choice.getDtmf() != null) {
                this.out.println("            names.push('ddbuiltindtmf" + choice.getId() + "');");
            }
            this.out.println("            try {");
            this.out.println("                if (document.forms[0].choice" + choice.getId() + "___selectddbigram" + "___utterance" + ".value.length > 0 ) {");
            this.out.println("                    var utter = document.forms[0].choice" + choice.getId() + "___selectddbigram" + "___utterance" + ".value;");
            this.out.println("                    var mode = document.forms[0].choice" + choice.getId() + "___selectddbigram" + "___inputmode" + ".value;");
            this.out.println("                    document.forms[0]." + menu.getName() + "___utterance" + ".value = utter;");
            this.out.println("                    document.forms[0]." + menu.getName() + "___interpretation" + ".value = utter;");
            this.out.println("                    document.forms[0]." + menu.getName() + "___inputmode" + ".value = mode;");
            this.out.println("                    document.forms[0]." + menu.getName() + "___value" + ".value = utter;");
            this.out.println("                    document.forms[0]." + menu.getName() + "___confidence" + ".value = '.90';");
            this.out.println("                    return true;");
            this.out.println("                }");
            this.out.println("            } catch (bigmsg) {");
            this.out.println("            } ");
            this.out.println("        }");
        }
        this.out.println("        ");
        this.out.println("        for ( var i = 0; i < names.length; i++ ) {");
        this.out.println("            try {");
        this.out.println("                var fieldname = \"document.forms[0].choice\" + choice +\"___select\" + names[i] + \".value\";");
        this.out.println("                var values = eval(fieldname);");
        this.out.println("                var items = values.split(\"~\");");
        this.out.println("            ");
        this.out.println("                if ( i == 0 ) {");
        this.out.println("                    utterance = checkValue(items[0], \"\");");
        this.out.println("                    interpretation = checkValue(items[1], \"\");");
        this.out.println("                    inputmode = checkValue(items[2], \"voice\");");
        this.out.println("                } else {");
        this.out.println("                    utterance += \" \" + checkValue(items[0], \"\");");
        this.out.println("                    interpretation += \" \" + checkValue(items[1], \"\");");
        this.out.println("                    inputmode = checkValue(items[2], inputmode);");
        this.out.println("                }");
        this.out.println("            } catch (errMsg) {");
        this.out.println("            } ");
        this.out.println("        }");
        this.out.println("        utterance = trimString( utterance );");
        this.out.println("        interpretation = trimString( interpretation );");
        this.out.println("        ");
        this.out.println("        document.forms[0]." + menu.getName() + "___utterance" + ".value = utterance;");
        this.out.println("        document.forms[0]." + menu.getName() + "___interpretation" + ".value = interpretation;");
        this.out.println("        document.forms[0]." + menu.getName() + "___inputmode" + ".value = inputmode;");
        this.out.println("        document.forms[0]." + menu.getName() + "___value" + ".value = interpretation;");
        this.out.println("        var val, item, valname;");
        for (String name : columns) {
            this.out.println("        for ( var i = 0; i < names.length; i++ ) {");
            this.out.println("            try {");
            this.out.println("                if ( names[i].indexOf('ddbuiltindtmf') == -1 ) {");
            this.out.println("                    valname = \"document.forms[0].choice\" + choice +\"___select\" + names[i] + \".value\";");
            this.out.println("                    val = eval(valname);");
            this.out.println("                    item = val.split(\"~\");");
            this.out.println("                    document.forms[0]." + menu.getName() + "___" + name + ".value = checkValue(item[1], \"undefined\");");
            this.out.println("                } ");
            this.out.println("            } catch (errMsg) {");
            this.out.println("            } ");
            this.out.println("        } ");
        }
        this.out.println("        return true;");
        this.out.println("    }");
        this.out.println("</Script>");
        this.out.print("<input type=\"hidden\" name=\"");
        this.out.print(menu.getName() + "___confidence");
        this.out.println("\" value=\".90\"/>");
        this.out.print("<input type=\"hidden\" name=\"");
        this.out.print(menu.getName() + "___value");
        this.out.println("\" value=\"\"/>");
        this.out.print("<input type=\"hidden\" name=\"");
        this.out.print(menu.getName() + "___utterance");
        this.out.println("\" value=\"\"/>");
        this.out.print("<input type=\"hidden\" name=\"");
        this.out.print(menu.getName() + "___inputmode");
        this.out.println("\" value=\"\"/>");
        this.out.print("<input type=\"hidden\" name=\"");
        this.out.print(menu.getName() + "___interpretation");
        this.out.println("\" value=\"\"/>");
        this.out.println("<br>");
        for (String name : columns) {
            this.out.print("<input type=\"hidden\" name=\"");
            this.out.print(menu.getName() + "___" + name);
            this.out.println("\" value=\"\"/>");
            this.out.println("<br>");
        }
    }

    @Override
    public void grammarEnd(Grammar grammar) {
        this.out.println("<br>");
    }

    @Override
    public void phraseBegin(Phrase phrase) {
        this.out.print("<a href=\"");
        this.out.print(phrase.getURL());
        if (phrase.getText() == null || phrase.getText().length() == 0) {
            this.out.print("\">No text for this phrase</a>");
        } else {
            this.out.print("\">" + phrase.getText() + "</a>");
        }
    }

    @Override
    public void phraseEnd(Phrase phrase) {
        this.out.println("<br>");
    }

    @Override
    public void audioMediaPhraseBegin(Phrase phrase) {
        this.phraseBegin(phrase);
    }

    @Override
    public void audioMediaPhraseEnd(Phrase phrase) {
        this.phraseEnd(phrase);
    }

    @Override
    public void gotoBegin(Goto goTo) {
        this.out.print("<a href=\"");
        this.out.print(this.getNextUrl(goTo.getNext()));
        this.out.print("\">");
        if (goTo.getName() != null) {
            this.out.print(goTo.getName());
        } else {
            this.out.print(goTo.getNext());
        }
        this.out.print("</a>");
    }

    @Override
    public void gotoEnd(Goto goTo) {
        this.out.println("<br>");
    }

    public void promptBeginStd(Prompt prompt, int count, boolean isRandomized, int iteration, boolean isSingle) {
    }

    @Override
    public void promptMiddle(IRuntimePrompt promptIn, int count, boolean isSingle, boolean forceTag) {
        this.out.print("<b>Prompt :</b> ");
        if (promptIn != null) {
            Prompt prompt = (Prompt)promptIn;
            ArrayList<PromptElement> list = null;
            list = prompt.getElements(count);
            for (int i = 0; i < list.size(); ++i) {
                Phrase[] values;
                PromptElement element = list.get(i);
                if (!element.isEnabled()) continue;
                if (element.getType() == 1) {
                    this.out.println(element.getText());
                    continue;
                }
                if (element.getType() == 2) {
                    element.getPhrase().generate(this);
                    continue;
                }
                if (element.getType() == 9) {
                    element.getPhrase().generate(this);
                    continue;
                }
                if (element.getType() == 8) {
                    this.out.println("<i>Expression:</i>" + element.getValue());
                    continue;
                }
                if (element.getType() == 3) {
                    Format format = element.getFormats();
                    if (format != null) {
                        String fmt = format.get("format");
                        if (fmt.equals("filename") || fmt.equals("fileurl")) {
                            String value = element.getFormattedVariableText();
                            if (element.isWaveFile()) {
                                this.out.print("<a href=\"");
                                this.out.print(value);
                                this.out.print("\">" + value + "</a>");
                                continue;
                            }
                            this.out.println(value);
                            continue;
                        }
                        if (fmt.equals("digits")) {
                            this.out.println(element.getFormattedVariableText());
                            continue;
                        }
                        if (!fmt.equals("text")) continue;
                        this.out.println(element.getFormattedVariableText());
                        continue;
                    }
                    this.out.println(element.getFormattedVariableText());
                    continue;
                }
                if (element.getType() == 4) {
                    values = element.getFormattedVariableAudio();
                    for (int ix = 0; ix < values.length; ++ix) {
                        values[ix].generate(this);
                    }
                    continue;
                }
                if (element.getType() == 12) {
                    values = element.getFormattedVariableAudio();
                    for (int ix = 0; ix < values.length; ++ix) {
                        values[ix].generate(this);
                    }
                    continue;
                }
                if (element.getType() == 10) {
                    if (!(element instanceof PhraseVariableElement)) {
                        this.mySession.throwRTException("Phrase Variable types must be instance of PhraseVariableElement");
                    }
                    values = ((PhraseVariableElement)element).getPhrases();
                    for (int ix = 0; ix < values.length; ++ix) {
                        values[ix].generate(this);
                    }
                    continue;
                }
                if (element.getType() != 11) continue;
                ((MediaElement)element).generate(this);
            }
        }
        this.out.println("<br>");
    }

    @Override
    public void promptBegin(IRuntimePrompt prompt, int count, boolean isRandomized, int iteration, boolean isSingle) {
        if (prompt instanceof Prompt || prompt == null) {
            this.promptBeginStd((Prompt)prompt, count, isRandomized, iteration, isSingle);
        } else {
            this.mySession.throwRTException("Prompt type not implemented");
        }
    }

    @Override
    public void promptBegin(IRuntimePrompt prompt, int count, boolean isSingle) {
        if (prompt instanceof Prompt || prompt == null) {
            this.promptBeginStd((Prompt)prompt, count, false, -1, isSingle);
        } else {
            this.mySession.throwRTException("Prompt type not implemented");
        }
    }

    @Override
    public void promptEnd(IRuntimePrompt prompt, int count, boolean isSingle) {
        this.out.println("<br>");
    }

    @Override
    public void promptRandomize(IRuntimePrompt prompt) {
        Collection counts = prompt.getLevelNumbers();
        int index = 0;
        for (Integer count : counts) {
            this.promptBegin(prompt, count, true, index + 1, false);
            this.promptMiddle(prompt, count, false, false);
            this.promptEnd(prompt, count, false);
            ++index;
        }
    }

    @Override
    public void handlerBegin(Handler handler) {
        this.out.println("<b>Handler :</b> " + handler.getType());
    }

    @Override
    public void handlerEnd(Handler handler) {
        this.out.println("<br>");
    }

    @Override
    public void rootBegin(Root root) {
    }

    @Override
    public void rootEnd(Root root) {
        this.out.println("<hr><br>");
    }

    @Override
    public void propertyBegin(Property property) {
        this.out.println("<b>Property :</b> " + property.getName() + " = " + (property.isVariable() ? this.getVariable(property.getValue()) : property.getValue()));
    }

    @Override
    public void propertyEnd(Property property) {
        this.out.println("<br>");
    }

    @Override
    public void blockBegin() {
    }

    @Override
    public void blockEnd() {
        this.out.println("<br>");
    }

    @Override
    public void disconnectBegin(Disconnect disconnect, Collection outParams) {
        this.out.println("<b>Disconnect</b>");
        if (outParams != null && outParams.size() > 0) {
            this.out.println("<b>Output Parameters :</b> <br>");
            for (Parameter param : outParams) {
                this.out.print("&nbsp;&nbsp;");
                this.out.println(param.getName());
                this.out.println(" = [" + this.getVariable(param.getValue()) + "]<br>");
            }
        }
    }

    @Override
    public void disconnectEnd(Disconnect disconnect) {
        this.out.println("<br>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dynamicGrammarBegin(DynamicGrammar grammar) {
        String str = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" + grammar.toString();
        FileOutputStream os = null;
        try {
            String path = this.mySession.getAbsoluteTempDirPath();
            SCESession.createDirectoryStructure((File)new File(path));
            path = path + File.separator + "dyngram.txt";
            File f = new File(path);
            os = new FileOutputStream(f, false);
            os.write(str.getBytes());
        }
        catch (Exception e) {
            this.mySession.throwRTException("Error creating grammar temp file", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e2) {}
            }
        }
        String url = this.mySession.getTempFileURL("dyngram.txt").toString();
        this.out.println("<Script language=\"JavaScript\">");
        this.out.println("    function displayDynamicGrammar() {");
        this.out.println("        var mywin;");
        this.out.println("        mywin = window.open(\"" + url + "\");");
        this.out.println("        mywin.focus();");
        this.out.println("        return true;");
        this.out.println("    }");
        this.out.println("</Script>");
        this.out.println("<input type=\"button\" onClick=\"return displayDynamicGrammar();\" value=\"Display dynamic grammar\" /input><br>");
    }

    @Override
    public void dynamicGrammarEnd(DynamicGrammar grammar) {
        this.out.println("<br>");
    }

    private String getText(Element item) {
        NodeList textList = item.getChildNodes();
        String textValue = "";
        for (int k = 0; k < textList.getLength(); ++k) {
            Text text;
            Node node = textList.item(k);
            if (!(node instanceof Text) || (text = (Text)node).getData() == null) continue;
            textValue = textValue + text.getData();
        }
        return textValue.trim();
    }

    private Collection<Slot> parseGrammar(Document doc, String mode) {
        ArrayList<Slot> utteranceList = new ArrayList<Slot>();
        NodeList oneoflist = XML.getList((Document)doc, (String)"one-of");
        for (int i = 0; i < oneoflist.getLength(); ++i) {
            Element oneOf = (Element)oneoflist.item(i);
            Element rule = (Element)oneOf.getParentNode();
            NodeList itemList = XML.getList((Element)oneOf, (String)"item");
            Slot slot = new Slot();
            slot.name = rule.getAttribute("id");
            utteranceList.add(slot);
            for (int j = 0; j < itemList.getLength(); ++j) {
                UtterInfo info = new UtterInfo();
                info.mode = mode;
                Element item = (Element)itemList.item(j);
                info.utterance = this.getText(item);
                try {
                    NodeList tagList = XML.getList((Element)item, (String)"tag");
                    info.tag = this.getText((Element)tagList.item(0));
                }
                catch (Exception e) {
                    info.tag = new String(info.utterance);
                }
                slot.utternaces.add(info);
            }
        }
        return utteranceList;
    }

    private Collection<Slot> getUtterancesFromUrl(String urlName, String mode) {
        try {
            URL url = new URL(urlName);
            InputStream stream = url.openStream();
            Document doc = XML.getDocument((InputStream)stream);
            Collection<Slot> utterances = this.parseGrammar(doc, mode);
            stream.close();
            return utterances;
        }
        catch (Exception e) {
            if (this.mySession.isDDTraceEnabled()) {
                StringBuffer sb = new StringBuffer();
                Trackable.formatException(e, sb);
                this.mySession.getTraceOutput().writeln(3, "Get Utterances From URL " + sb.toString());
            }
            e.printStackTrace(this.out);
            return Collections.emptyList();
        }
    }

    private Collection<Slot> getUtterancesFromString(String data, String mode) {
        try {
            Document doc = XML.getDocumentFromXMLString((String)data);
            Collection<Slot> utterances = this.parseGrammar(doc, mode);
            return utterances;
        }
        catch (Exception e) {
            if (this.mySession.isDDTraceEnabled()) {
                StringBuffer sb = new StringBuffer();
                Trackable.formatException(e, sb);
                this.mySession.getTraceOutput().writeln(3, "Get Utterances From String " + sb.toString());
            }
            e.printStackTrace(this.out);
            return Collections.emptyList();
        }
    }

    private String cleanTag(char marker, String value) {
        try {
            String str = new String(value);
            int index = str.indexOf(marker);
            if (index == -1) {
                return value;
            }
            if ((index = (str = str.substring(index + 1)).indexOf(marker)) == -1) {
                return str;
            }
            str = str.substring(0, index);
            return str;
        }
        catch (Exception e) {
            return value;
        }
    }

    private Collection<String> makeUtteranceListUnique(ArrayList<Slot> utteranceList) {
        HashMap<String, String> unique = new HashMap<String, String>();
        for (Slot slot : utteranceList) {
            if (unique.get(slot.name) != null) {
                slot.name = slot.name + "_DUPLICATE_" + (int)(Math.random() * 1.0E7);
                continue;
            }
            unique.put(slot.name, slot.name);
        }
        return unique.values();
    }

    private void generateGrammarJSHTML(Collection grammars, String fieldName) {
        ArrayList<Slot> utteranceList = new ArrayList<Slot>();
        boolean sawBuiltin = false;
        for (IRuntimeGrammar grammar : grammars) {
            IRuntimeGrammar gram;
            if (!grammar.isEnabled()) continue;
            if (grammar instanceof Grammar) {
                gram = (Grammar)grammar;
                if (((Grammar)gram).getFileName() != null && ((Grammar)gram).isExternal() && !((Grammar)gram).getMediaType().equals("application/srgs+xml")) {
                    this.out.println("<b>External Grammar :</b>" + ((Grammar)gram).getFileName() + ":" + ((Grammar)gram).getMediaType() + "is not yet supported in html mode<br>");
                    continue;
                }
                if (((Grammar)gram).isBuiltin()) {
                    sawBuiltin = true;
                    continue;
                }
                utteranceList.addAll(this.getUtterancesFromUrl(((Grammar)gram).getURL(), ((Grammar)gram).getMode()));
                continue;
            }
            if (grammar instanceof DynamicGrammar) {
                gram = (DynamicGrammar)grammar;
                utteranceList.addAll(this.getUtterancesFromString(((DynamicGrammar)gram).toString(), ((DynamicGrammar)gram).getMode()));
                continue;
            }
            this.out.print("<b>Unknown grammar :</b>" + grammar.getClass().getName());
        }
        Collection<String> uniqueSlotNames = this.makeUtteranceListUnique(utteranceList);
        this.out.println("<Script language=\"JavaScript\">");
        this.out.println("    function trimString( value ) {");
        this.out.println("        var origvalue = value;");
        this.out.println("        try {");
        this.out.println("            while ( value.charAt(0) == ' ' ) {");
        this.out.println("                value = value.slice(1);");
        this.out.println("            }");
        this.out.println("            return(value);");
        this.out.println("        } catch (errMsg) {");
        this.out.println("            return(origvalue);");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    function checkValue( value, defvalue ) {");
        this.out.println("        try {");
        this.out.println("            var str = new String(value);");
        this.out.println("            var index = str.indexOf( \"undefined\" );");
        this.out.println("            if (index == -1 ) {");
        this.out.println("                return( value );");
        this.out.println("            } else {");
        this.out.println("                return( defvalue );");
        this.out.println("            }");
        this.out.println("        } catch (errMsg) {");
        this.out.println("            return(value);");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    function assignFields() {");
        this.out.println("        var inputmode = document.forms[0]." + fieldName + "___inputmode" + ".value;");
        this.out.println("        var utterance = document.forms[0]." + fieldName + "___utterance" + ".value;");
        this.out.println("        var interpretation = document.forms[0]." + fieldName + "___utterance" + ".value;");
        this.out.println("        var names = new Array();");
        this.out.println("        ");
        for (Slot slot : utteranceList) {
            this.out.println("        names.push('" + slot.name + "');");
        }
        this.out.println("        ");
        this.out.println("        for ( var i = 0; i < " + utteranceList.size() + "; i++ ) {");
        this.out.println("            var fieldname = \"document.forms[0]." + fieldName + "___select\" + names[i] + \".value\";");
        this.out.println("            var values = eval(fieldname);");
        this.out.println("            var items = values.split(\"~\");");
        this.out.println("            ");
        this.out.println("            utterance += \" \" + checkValue(items[0], \"\");");
        this.out.println("            interpretation += \" \" + checkValue(items[1], \"\");");
        this.out.println("            inputmode = checkValue(items[2], inputmode);");
        this.out.println("        }");
        this.out.println("        utterance = trimString( utterance );");
        this.out.println("        interpretation = trimString( interpretation );");
        this.out.println("        ");
        this.out.println("        document.forms[0]." + fieldName + "___utterance" + ".value = utterance;");
        this.out.println("        document.forms[0]." + fieldName + "___interpretation" + ".value = interpretation;");
        this.out.println("        document.forms[0]." + fieldName + "___inputmode" + ".value = inputmode;");
        this.out.println("        document.forms[0]." + fieldName + "___value" + ".value = interpretation;");
        this.out.println("        var val, item;");
        for (Slot slot : utteranceList) {
            int index = slot.name.indexOf("_DUPLICATE");
            String realName = slot.name;
            String uniqueName = slot.name;
            if (index != -1) {
                realName = realName.substring(0, index);
            }
            this.out.println("        val = document.forms[0]." + fieldName + "___select" + uniqueName + ".value;");
            this.out.println("        item = val.split(\"~\");");
            this.out.println("        document.forms[0]." + fieldName + "___" + realName + ".value += \" \" + checkValue(item[1], \"\");");
        }
        this.out.println("        ");
        for (String name : uniqueSlotNames) {
            this.out.println("        document.forms[0]." + fieldName + "___" + name + ".value = trimString(document.forms[0]." + fieldName + "___" + name + ".value);");
        }
        this.out.println("        return true;");
        this.out.println("    }");
        this.out.println("</Script>");
        this.out.println("<b>Select ");
        if (sawBuiltin) {
            this.out.println("or enter ");
        }
        this.out.println("input for grammar :</b>&nbsp;");
        for (Slot slot : utteranceList) {
            ArrayList<UtterInfo> utterances = slot.utternaces;
            this.out.print("<select name=\"");
            this.out.print(fieldName + "___select" + slot.name);
            this.out.println("\" >");
            this.out.print("<option value=\"");
            this.out.println("\">");
            for (UtterInfo info : utterances) {
                this.out.print("<option value=\"");
                this.out.print(info.utterance + "~" + this.cleanTag('\'', this.cleanTag('\"', info.tag)) + "~" + info.mode);
                this.out.print("\">");
                this.out.println(info.utterance);
            }
            this.out.println("</select>");
        }
        this.out.print("<input type=\"hidden\" name=\"");
        this.out.print(fieldName + "___confidence");
        this.out.println("\" value=\".90\"/>");
        this.out.print("<input type=\"hidden\" name=\"");
        this.out.print(fieldName + "___value");
        this.out.println("\" value=\"\"/>");
        if (sawBuiltin) {
            this.out.print("<input type=\"text\" name=\"");
            this.out.print(fieldName + "___utterance");
            this.out.println("\" value=\"\"/>");
        } else {
            this.out.print("<input type=\"hidden\" name=\"");
            this.out.print(fieldName + "___utterance");
            this.out.println("\" value=\"\"/>");
        }
        if (sawBuiltin) {
            this.out.print("<b>Input Mode :</b><input type=\"text\" name=\"");
            this.out.print(fieldName + "___inputmode");
            this.out.println("\" value=\"\"/>");
        } else {
            this.out.print("<input type=\"hidden\" name=\"");
            this.out.print(fieldName + "___inputmode");
            this.out.println("\" value=\"\"/>");
        }
        this.out.print("<input type=\"hidden\" name=\"");
        this.out.print(fieldName + "___interpretation");
        this.out.println("\" value=\"\"/>");
        this.out.println("<br>");
        for (String name : uniqueSlotNames) {
            this.out.print("<input type=\"hidden\" name=\"");
            this.out.print(fieldName + "___" + name);
            this.out.println("\" value=\"\"/>");
            this.out.println("<br>");
        }
    }

    @Override
    public void fieldBegin(Field field, Collection prompts) {
        if (field.isRecordUtterance()) {
            this.out.println("<b>Property :</b> RecordUtterance = true<br>");
            this.out.println("<br>");
        }
    }

    @Override
    public void fieldEnd(Field field) {
        Collection<IRuntimeGrammar> grammars = field.getGrammars();
        this.generateGrammarJSHTML(grammars, field.getName());
    }

    @Override
    public void submitBegin(Submit submit, Collection submitList) {
        this.out.println("<br><input name=\"submit\" type=\"submit\" value=\"Continue\">");
    }

    @Override
    public void submitEnd(Submit submit) {
        this.out.println("<br>");
    }

    @Override
    public void platformObjectBegin(PlatformObject platformObject, Collection prompts) {
        this.out.println("<i><b>Platform Object HTML generation not implemented</b></i>");
    }

    @Override
    public void platformObjectEnd(PlatformObject platformObject) {
        this.out.println("<br>");
    }

    @Override
    public void recordBegin(Record record, Collection prompts) {
        this.out.println("<i><b>Record HTML generation not implemented</b></i>");
    }

    @Override
    public void recordEnd(Record record) {
        this.out.println("<br>");
    }

    private String getAudioURLFromAudioPrompt(Prompt audioPrompt) {
        String audioURL = null;
        try {
            if (audioPrompt != null) {
                ArrayList<PromptElement> list = audioPrompt.getElements(1);
                PromptElement promptElement = list.get(0);
                Phrase phrase = promptElement.getPhrase();
                audioURL = phrase.getURL();
            }
        }
        catch (Exception e) {
            this.mySession.throwRTException("Invalid transfer audio, must be a prompt with one prompt level and one element that is a phrase", e);
        }
        return audioURL;
    }

    @Override
    public void transferBegin(Transfer transfer, Collection prompts) {
    }

    @Override
    public void transferEnd(Transfer transfer) {
        Collection<IRuntimeGrammar> grammars;
        String aai = null;
        String destNumber = null;
        if (transfer.getDestType() == 1) {
            destNumber = transfer.getDestNumber();
        } else if (transfer.getDestType() == 2) {
            destNumber = this.getVariable(transfer.getDestNumber());
        } else {
            this.mySession.throwRTException("Invalid transfer phone number type");
        }
        if (!destNumber.toLowerCase().startsWith("tel:") && !destNumber.toLowerCase().startsWith("sip:")) {
            destNumber = "tel:" + destNumber;
        }
        if (transfer.getAaiType() == 1) {
            aai = transfer.getAai();
        } else if (transfer.getAaiType() == 2) {
            aai = this.getVariable(transfer.getAai());
        } else {
            this.mySession.throwRTException("Invalid transfer aai type");
        }
        String ucidStr = "";
        if (transfer.getUcidVar() != null && transfer.getUcidVar().length() > 0) {
            ucidStr = this.getVariable(transfer.getUcidVar());
        }
        aai = transfer.checkHexEncodeAAIForAACC(aai, ucidStr);
        if (transfer.getTransferType() == Transfer.TransferType.BRIDGED) {
            this.out.println("<b>Bridged Transfer to : </b>" + destNumber + "<br>");
            this.out.println("<b>AAI : </b>" + aai + "<br>");
            grammars = transfer.getGrammars();
            this.generateGrammarJSHTML(grammars, transfer.getName());
            this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;<b>Duration : </b><input type=\"text\" name=\"");
            this.out.print(transfer.getName() + "___duration");
            this.out.println("\" value=\"0\"/><br>");
        } else if (transfer.getTransferType() == Transfer.TransferType.CONSULTATION) {
            this.out.println("<b>Consultation  Transfer to : </b>" + destNumber + "<br>");
            this.out.println("<b>AAI : </b>" + aai + "<br>");
            grammars = transfer.getGrammars();
            this.generateGrammarJSHTML(grammars, transfer.getName());
            this.out.println("<br>");
        } else {
            this.out.println("<b>Blind Transfer to : </b>" + destNumber + "<br>");
            this.out.println("<Script language=\"JavaScript\">");
            this.out.println("    function assignFields() {");
            this.out.println("        return true;");
            this.out.println("    }");
            this.out.println("</Script>");
        }
        String xferAudio = this.getAudioURLFromAudioPrompt(transfer.getXferAudio());
        String timeout = transfer.getTimeoutType() == 1 ? transfer.getConnectTimeout() : (transfer.getTimeoutType() == 2 ? this.getVariable(transfer.getConnectTimeout()) : "Invalid timeout type: " + transfer.getTimeoutType());
        this.out.println("&nbsp;&nbsp;&nbsp;&nbsp;<b>Connect timeout : </b>" + timeout);
        this.out.println("<br>");
        this.out.println("&nbsp;&nbsp;&nbsp;&nbsp;<b>Maxtime </b>: " + transfer.getMaxTime());
        this.out.println("<br>");
        if (xferAudio != null) {
            this.out.println("&nbsp;&nbsp;&nbsp;&nbsp;<b>Transferaudio : </b><a href=\"" + xferAudio + "\">" + xferAudio + "</a>");
        }
        this.out.println("<br>");
    }

    @Override
    public void eventBegin(Event event, int count, boolean isSingle) {
        this.out.println("<b>Event :</b>" + event.getType() + " - ");
    }

    @Override
    public void eventEnd(Event event) {
        this.out.println("<br>");
    }

    @Override
    public void mixedInitiativeFormBegin(MixedInitiativeForm form) {
        this.out.println("<i><b>Mixed Initiative Form HTML generation not implemented</b></i>");
    }

    @Override
    public void mixedInitiativeFormEnd(MixedInitiativeForm Form2) {
        this.out.println("<br>");
    }

    @Override
    public void programmErrorBegin(String message, Throwable e) {
        this.out.println("<b>Runtime Error : </b><br>");
        this.out.println(e.toString());
    }

    @Override
    public void programmErrorEnd(String message, Throwable e) {
        this.out.println("<br>");
    }

    @Override
    public void throwBegin(Throw event) {
        this.out.println("<b>Throw : </b>" + event.getName() + " <b>count : </b>" + event.getCount(this.getMySession()));
        if (event.getMessage() != null) {
            this.out.println("<b>message : </b>" + event.getMessageValue(this.getMySession()));
        }
    }

    @Override
    public void throwEnd(Throw event) {
        this.out.println("<br>");
    }

    @Override
    public void eventMiddle(Event event) {
        this.out.println("&nbsp;&nbsp;&nbsp;&nbsp;reprompt<br>");
    }

    @Override
    public void entryBegin(Entry entry, boolean isInitialApp) {
        if (isInitialApp) {
            this.out.println("<b>Starting application :</b> " + entry.getEntryName());
            this.out.print("<br><br>Application Startup Parameters<br><table>");
            for (SessionVarField field : Submit.sessionVarFields) {
                this.out.print("<tr><td>" + field.getDescription() + "</td><td><input type=\"text\" name=\"");
                this.out.print(field.getDDVar());
                this.out.println("\" value=\"\"/></td></tr>");
            }
            this.out.print("</table>");
        } else {
            this.out.println("<b>Entering module :</b> " + entry.getEntryName());
        }
    }

    @Override
    public void entryEnd(Entry entry, boolean isInitialApp) {
        this.out.println("<br>");
    }

    @Override
    public void invocationBegin(Invoke invoke, Collection inParams, Collection outParams) {
        String entryPoint = this.getNextUrl(invoke.getWebAppEntryPoint(this.mySession));
        if (!entryPoint.startsWith("http")) {
            entryPoint = "/" + entryPoint;
        }
        String action = entryPoint;
        action = action + "&sagecall=" + this.mySession.getCurrentLanguage() + "~" + this.mySession.getAppName() + "/" + invoke.getNext() + "~" + invoke.getName();
        this.out.println("<Script language=\"JavaScript\">");
        this.out.println("    function changeFormAction() {");
        this.out.println("        document.forms[0].action =\"" + action + "\";");
        this.out.println("        return true;");
        this.out.println("    }");
        this.out.println("</Script>");
        this.out.println("<b>Invoking Module :</b> " + invoke.getName());
        if (inParams != null) {
            for (Parameter param : inParams) {
                this.out.print("<input type=\"hidden\" name=\"");
                this.out.print(param.getName());
                this.out.print("\" ");
                int mode = param.getMode();
                if (mode == 1) {
                    this.out.print("value =\"" + param.getValue());
                } else if (mode == 3) {
                    this.out.print("value=\"" + this.getVariable(param.getValue()));
                } else if (mode == 2) {
                    this.out.print("value=\"" + param.getValue());
                }
                this.out.println("\" />");
            }
        }
        this.out.println("<input type=\"hidden\" name=\"sagecall\" value =\"" + this.mySession.getCurrentLanguage() + "~" + this.mySession.getAppName() + "/" + invoke.getNext() + "~" + invoke.getName() + "\" />");
    }

    @Override
    public void invocationEnd(Invoke invoke) {
        this.out.println("<br>");
    }

    @Override
    public void completeBegin(Return complete, boolean isLast, Collection outParams) {
        String returnName = "";
        String callerName = "";
        this.out.print("<br>");
        if (isLast) {
            this.out.print("<a href=\"");
            this.out.print(this.getNextUrl("Start"));
            this.out.print("\">");
            this.out.print(" Application has ended click the here to restart");
            this.out.println("</a><br>");
            this.mySession.setRemoveSessionPending();
        } else {
            IVariableField field = this.mySession.getVariableField("___sagecall");
            StringTokenizer temp = new StringTokenizer(field.getStringValue(), "~");
            temp.nextToken();
            returnName = temp.nextToken();
            callerName = temp.nextToken();
            this.out.println(" <b>Returning to calling application :</b> " + returnName);
            this.out.print("<form method=\"POST\"");
            this.out.print(" action=\"");
            this.out.print(this.getNextUrl(returnName));
            this.out.println("\">");
        }
        if (outParams != null && outParams.size() > 0) {
            this.out.println("<b>Output Parameters :</b> <br>");
            for (Parameter param : outParams) {
                this.out.print("&nbsp;&nbsp;");
                this.out.println(param.getName());
                if (param.getMode() == 3) {
                    this.out.println(" = [" + this.getVariableWithPrivacy(param.getValue(), IOutputGenerator.PrivacyKind.LOG) + "]<br>");
                } else if (param.getMode() == 2) {
                    this.out.println(" = [" + param.getValue() + "]<br>");
                }
                if (isLast) continue;
                this.out.print("<input type=\"hidden\" name=\"");
                this.out.print(callerName + "___" + param.getName());
                if (param.getMode() == 3) {
                    this.out.println("\" value=\"" + this.getVariableWithPrivacy(param.getValue(), IOutputGenerator.PrivacyKind.LOG) + "\"/>");
                    continue;
                }
                if (param.getMode() != 2) continue;
                this.out.println("\" value=\"" + param.getValue() + "\"/>");
            }
        }
    }

    @Override
    public void completeEnd(Return complete, boolean isLast) {
        if (!isLast) {
            this.out.println("<br><input name=\"submit\" type=\"submit\" value=\"Continue\">");
            this.out.println("</form>");
        }
        this.out.println("<br>");
    }

    @Override
    public void returnErrorBegin(ReturnError returnError, Throw throwItem, boolean isLast, boolean isPostGen) {
        String returnName = "";
        this.out.print("<br>");
        if (isLast) {
            this.out.print("<a href=\"");
            this.out.print(this.getNextUrl("Start"));
            this.out.print("\">");
            this.out.print(" Application has ended click the here to restart");
            this.out.println("</a><br>");
            this.mySession.setRemoveSessionPending();
        } else {
            IVariableField field = this.mySession.getVariableField("___sagecall");
            StringTokenizer temp = new StringTokenizer(field.getStringValue(), "~");
            temp.nextToken();
            returnName = temp.nextToken();
            temp.nextToken();
            this.out.print("<a href=\"");
            this.out.print(this.getNextUrl(returnName));
            this.out.print("\">");
            this.out.print(" Returning to calling application " + returnName + " On Error");
            this.out.println("</a><br>");
        }
    }

    @Override
    public void returnErrorEnd(ReturnError returnError, Throw throwItem, boolean isLast, boolean isPostGen) {
    }

    @Override
    public void exitActionBegin(ExitAction exitAction, boolean isPostGen) {
        this.out.print("<a href=\"");
        this.out.print(this.getNextUrl("Start"));
        this.out.print("\">");
        this.out.print(" click the here to exit/restart");
        this.out.println("</a><br>");
    }

    @Override
    public void exitActionEnd(ExitAction exitAction, boolean isPostGen) {
    }

    @Override
    public void captureExpressionBegin(CaptureExpression captureExpression) {
        this.out.print("<br>" + captureExpression.getVariableName() + ":<input type=\"text\" name=\"");
        this.out.print(captureExpression.getVariableName());
        this.out.println("\" value=\"" + captureExpression.getExpression() + "\"/>");
    }

    @Override
    public void captureExpressionEnd(CaptureExpression captureExpression) {
    }

    @Override
    public void transferOnErrorBegin(TransferOnError transferOE, Collection prompts, boolean isPostGen) {
    }

    @Override
    public void transferOnErrorEnd(TransferOnError transferOE, boolean isPostGen) {
        String destNumber = null;
        String aai = null;
        if (transferOE.getDestType() == 1) {
            destNumber = "tel:" + transferOE.getDestNumber();
        } else if (transferOE.getDestType() == 2) {
            destNumber = "tel:" + this.getVariable(transferOE.getDestNumber());
        } else {
            this.mySession.throwRTException("Invalid transfer phone number type");
        }
        if (transferOE.getAaiType() == 1) {
            aai = transferOE.getAai();
        } else if (transferOE.getAaiType() == 2) {
            aai = this.getVariable(transferOE.getAai());
        } else {
            this.mySession.throwRTException("Invalid transfer aai type");
        }
        this.out.println("<b>Transfer On Error to : </b>" + destNumber + "<br>");
        this.out.println("&nbsp;&nbsp;&nbsp;&nbsp;<b>AAI </b>: " + aai);
        this.out.println("<br>");
        this.out.println("<br>");
    }

    @Override
    public void mediaParBegin(MediaPar mediaPar) {
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&lt;par");
        if (mediaPar.getEndSync().length() > 0) {
            this.out.print(" endsync=\"" + mediaPar.getEndSync() + "\"");
        }
        if (mediaPar.getFill().length() > 0) {
            this.out.print(" fill=\"" + mediaPar.getFill() + "\"");
        }
        this.out.print("&gt");
        this.out.println("<br>");
    }

    @Override
    public void mediaSeqBegin(MediaSeq mediaSeq) {
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&lt;seq");
        if (mediaSeq.getFill().length() > 0) {
            this.out.print(" fill=\"" + mediaSeq.getFill() + "\"");
        }
        this.out.print("&gt");
        this.out.println("<br>");
    }

    @Override
    public void mediaParEnd(MediaPar mediaPar) {
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&lt;/par&gt");
        this.out.println("<br>");
    }

    @Override
    public void mediaSeqEnd(MediaSeq mediaSeq) {
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&lt;/seq&gt");
        this.out.println("<br>");
    }

    @Override
    public void mediaRegionBegin(MediaRegion mediaRegion) {
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;region");
        this.out.print(" xml:id=\"" + mediaRegion.getName() + "\"");
        if (mediaRegion.getBkgnColor().length() > 0) {
            this.out.print(" backgroundColor=\"#" + mediaRegion.getBkgnColor() + "\"");
        }
        if (mediaRegion.getTop() > 0) {
            this.out.print(" top=\"" + mediaRegion.getTop() + mediaRegion.getUnit_tblr() + "\"");
        }
        if (mediaRegion.getBottom() > 0) {
            this.out.print(" bottom=\"" + mediaRegion.getBottom() + mediaRegion.getUnit_tblr() + "\"");
        }
        if (mediaRegion.getLeft() > 0) {
            this.out.print(" left=\"" + mediaRegion.getLeft() + mediaRegion.getUnit_tblr() + "\"");
        }
        if (mediaRegion.getRight() > 0) {
            this.out.print(" right=\"" + mediaRegion.getRight() + mediaRegion.getUnit_tblr() + "\"");
        }
        if (mediaRegion.getWidth() > 0) {
            this.out.print(" width=\"" + mediaRegion.getWidth() + mediaRegion.getUnit_hw() + "\"");
        }
        if (mediaRegion.getHeight() > 0) {
            this.out.print(" height=\"" + mediaRegion.getHeight() + mediaRegion.getUnit_hw() + "\"");
        }
        if (mediaRegion.getFit().length() > 0) {
            this.out.print(" fit=\"" + mediaRegion.getFit() + "\"");
        }
        if (mediaRegion.getShowBkgn().length() > 0) {
            this.out.print(" showBackground=\"" + mediaRegion.getShowBkgn() + "\"");
        }
        if (mediaRegion.getzIndex() > 0) {
            this.out.print(" z-index=\"" + mediaRegion.getzIndex() + "\"");
        }
        if (mediaRegion.getFontFamily().length() > 0) {
            this.out.print(" textFontFamily=\"" + mediaRegion.getFontFamily() + "\"");
        }
        if (mediaRegion.getFontSize().length() > 0) {
            this.out.print(" textFontSize=\"" + mediaRegion.getFontSize() + "\"");
        }
        if (mediaRegion.getFontColor().length() > 0) {
            this.out.print(" textColor=\"#" + mediaRegion.getFontColor() + "\"");
        }
        if (mediaRegion.getFontBkgnColor().length() > 0) {
            this.out.print(" textBackgroundColor=\"#" + mediaRegion.getFontBkgnColor() + "\"");
        }
        this.out.print(" /&gt");
        this.out.println("<br>");
    }

    @Override
    public void SMILLinkBegin(SMILLink smilLink) {
        this.out.print("&lt;media");
        if (smilLink.getExternal().length() > 0) {
            this.out.print(" src=\"" + smilLink.getExternal() + "\"/");
        } else if (smilLink.getLocal().length() > 0) {
            this.out.print(" src=\"" + smilLink.getLocalURL() + "\"/");
        } else {
            this.out.print(" src=\"" + smilLink.resolveVarField() + "\"/");
        }
        this.out.print("&gt");
        this.out.println("<br>");
    }

    @Override
    public void mediaPageBegin(MediaPage mediaPage) {
        this.out.println("<br>");
        this.out.print("&lt;media type=\"" + mediaPage.getSMILType() + "\"&gt");
        this.out.println("<br>");
        this.out.print("&nbsp;&nbsp;&lt;?xml version=\"1.0\" encoding=\"UTF-8\"?&gt");
        this.out.println("<br>");
        this.out.print("\t" + mediaPage.getDoctype() + "\n");
        this.out.print("&nbsp;&nbsp;&lt;smil xmlns=\"" + mediaPage.getNamespace() + "\"&gt");
        this.out.println("<br>");
        if (mediaPage.getRegions().size() > 0 || mediaPage.getBkgnColor().length() > 0 || mediaPage.getWidth() > 0 || mediaPage.getHeight() > 0) {
            this.out.print("&nbsp;&nbsp;&nbsp;&lt;head&gt");
            this.out.println("<br>");
            this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&lt;layout&gt");
            this.out.println("<br>");
            if (mediaPage.getBkgnColor().length() > 0 || mediaPage.getWidth() > 0 || mediaPage.getHeight() > 0) {
                this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;root-layout");
                if (mediaPage.getBkgnColor().length() > 0) {
                    this.out.print(" backgroundColor=\"#" + mediaPage.getBkgnColor() + "\"");
                }
                if (mediaPage.getWidth() > 0) {
                    this.out.print(" width=\"" + mediaPage.getWidth() + mediaPage.getUnit() + "\"");
                }
                if (mediaPage.getHeight() > 0) {
                    this.out.print(" height=\"" + mediaPage.getHeight() + mediaPage.getUnit() + "\"");
                }
                this.out.print("/&gt");
                this.out.println("<br>");
            }
            for (MediaRegion region : mediaPage.getRegions()) {
                region.generate(this);
            }
            this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&lt;/layout&gt");
            this.out.println("<br>");
            this.out.print("&nbsp;&nbsp;&nbsp;&lt;/head&gt");
            this.out.println("<br>");
        }
        this.out.print("&nbsp;&nbsp;&nbsp;&lt;body&gt");
        this.out.println("<br>");
    }

    @Override
    public void mediaPageEnd(MediaPage transfer) {
        this.out.print("&nbsp;&nbsp;&nbsp;&lt/body&gt");
        this.out.println("<br>");
        this.out.print("&nbsp;&nbsp;&lt/smil&gt");
        this.out.println("<br>");
        this.out.print("&lt;/media&gt");
        this.out.println("<br>");
    }

    @Override
    public void mediaBegin(MediaInfo mediaInfo) {
        String mediaOutputType = "media";
        String srcURL = mediaInfo.getMediaURL();
        srcURL = mediaInfo.hookGetMediaURL(srcURL);
        int mediaType = mediaInfo.getMediaType();
        mediaType = mediaInfo.hookGetMediaType(mediaType, srcURL);
        switch (mediaType) {
            case 1: {
                mediaOutputType = "audio";
                break;
            }
            case 2: {
                mediaOutputType = "video";
                break;
            }
            case 3: {
                mediaOutputType = "img";
                break;
            }
            case 4: {
                mediaOutputType = "text";
            }
        }
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;" + mediaOutputType + " ");
        this.out.print("src=\"" + srcURL + "\"");
        if (mediaInfo.getRegion().length() > 0) {
            this.out.print(" region=\"" + mediaInfo.getRegion() + "\"");
        }
        if (mediaInfo.getBegin() > 0.0) {
            this.out.print(" begin=\"" + mediaInfo.getBegin() + "\"");
        }
        if (mediaInfo.getEnd() > 0.0) {
            this.out.print(" end=\"" + mediaInfo.getEnd() + "\"");
        }
        if (mediaInfo.getDuration() > 0.0) {
            this.out.print(" dur=\"" + mediaInfo.getDuration() + "\"");
        }
        if (mediaInfo.getRepeatDuration() > 0.0) {
            this.out.print(" repeatDur=\"" + mediaInfo.getRepeatDuration() + "\"");
        }
        if (mediaInfo.getRepeatCount() > 0.0) {
            this.out.print(" repeatCount=\"" + mediaInfo.getRepeatCount() + "\"");
        }
        if (mediaInfo.getClipBegin() > 0.0) {
            this.out.print(" clipBegin=\"" + mediaInfo.getClipBegin() + "\"");
        }
        if (mediaInfo.getClipEnd() > 0.0) {
            this.out.print(" clipEnd=\"" + mediaInfo.getClipEnd() + "\"");
        }
        if (mediaInfo.getFill().length() > 0) {
            this.out.print(" fill=\"" + mediaInfo.getFill() + "\"");
        }
        this.out.print(" /&gt");
        this.out.println("<br>");
    }

    @Override
    public void mediaTextBlockBegin(MediaTextBlock mediaTextBlock) {
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;smilText");
        if (mediaTextBlock.getRegion().length() > 0) {
            this.out.print(" region=\"" + mediaTextBlock.getRegion() + "\"");
        }
        if (mediaTextBlock.getBegin() > 0.0) {
            this.out.print(" begin=\"" + mediaTextBlock.getBegin() + "\"");
        }
        if (mediaTextBlock.getEnd() > 0.0) {
            this.out.print(" end=\"" + mediaTextBlock.getEnd() + "\"");
        }
        if (mediaTextBlock.getDuration() > 0.0) {
            this.out.print(" dur=\"" + (int)mediaTextBlock.getDuration() + "s\"");
        }
        if (mediaTextBlock.getRepeatDuration() > 0.0) {
            this.out.print(" repeatDur=\"" + mediaTextBlock.getRepeatDuration() + "\"");
        }
        if (mediaTextBlock.getRepeatCount() > 0.0) {
            this.out.print(" repeatCount=\"" + mediaTextBlock.getRepeatCount() + "\"");
        }
        if (mediaTextBlock.getClipBegin() > 0.0) {
            this.out.print(" clipBegin=\"" + mediaTextBlock.getClipBegin() + "\"");
        }
        if (mediaTextBlock.getClipEnd() > 0.0) {
            this.out.print(" clipEnd=\"" + mediaTextBlock.getClipEnd() + "\"");
        }
        if (mediaTextBlock.getFontFamily().length() > 0) {
            this.out.print(" textFontFamily=\"" + mediaTextBlock.getFontFamily() + "\"");
        }
        if (mediaTextBlock.getFontSize().length() > 0) {
            this.out.print(" textFontSize=\"" + mediaTextBlock.getFontSize() + "\"");
        }
        if (mediaTextBlock.getFontColor().length() > 0) {
            this.out.print(" textColor=\"#" + mediaTextBlock.getFontColor() + "\"");
        }
        if (mediaTextBlock.getFontBkgnColor().length() > 0) {
            this.out.print(" textBackgroundColor=\"#" + mediaTextBlock.getFontBkgnColor() + "\"");
        }
        if (mediaTextBlock.getTextMode().length() > 0) {
            this.out.print(" textMode=\"" + mediaTextBlock.getTextMode() + "\"");
        }
        if (mediaTextBlock.getTextWritingMode().length() > 0) {
            this.out.print(" textWritingMode=\"" + mediaTextBlock.getTextWritingMode() + "\"");
        }
        this.out.print("&gt");
        this.out.println("<br>");
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    @Override
    public void mediaTextBlockEnd(MediaTextBlock mediaTextBlock) {
        this.out.println("<br>");
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/smilText&gt");
        this.out.println("<br>");
    }

    @Override
    public void mediaTextBegin(MediaText mediaText) {
        String text = mediaText.getMediaText();
        this.out.print(text);
    }

    @Override
    public void coordinationParBegin(CoordinationPar coordinationPar) {
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&lt;par");
        if (coordinationPar.getEndSync().length() > 0) {
            this.out.print(" endsync=\"" + coordinationPar.getEndSync() + "\"");
        }
        this.out.print("&gt");
        this.out.println("<br>");
    }

    @Override
    public void coordinationSeqBegin(CoordinationSeq coordinationSeq) {
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&lt;seq");
        this.out.print("&gt");
        this.out.println("<br>");
    }

    @Override
    public void coordinationParEnd(CoordinationPar coordinationPar) {
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&lt;/par&gt");
        this.out.println("<br>");
    }

    @Override
    public void coordinationSeqEnd(CoordinationSeq coordinationSeq) {
        this.out.print("&nbsp;&nbsp;&nbsp;&nbsp;&lt;/seq&gt");
        this.out.println("<br>");
    }

    @Override
    public void emailBegin(EmailInfo emailInfo) {
        Email email = emailInfo.getEmailObject();
        this.out.print(email.getEmailBody());
    }

    @Override
    public void smsBegin(SMSInfo smsInfo) {
        SMS sms = smsInfo.getSMSObject();
        this.out.print(sms.getSMSMessage());
    }
}

