/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.internal;

import com.avaya.sce.runtime.IRuntimePrompt;
import com.avaya.sce.runtime.Prompt;
import com.avaya.sce.runtime.internal.ClassFinder;
import com.avaya.sce.runtime.internal.ItemFinder;
import com.avaya.sce.runtimecommon.SCESession;

public class PromptFinder
extends ClassFinder {
    public static final String TYPE = "PROMPT";

    private static PromptFinder getPromptFinder(String language) {
        return (PromptFinder)ItemFinder.getFinder(TYPE, language);
    }

    public static IRuntimePrompt load(String name, String language, SCESession session) {
        IRuntimePrompt prompt = null;
        if (name != null) {
            try {
                String tempLang = language.equals("") ? session.getCurrentLanguage() : language;
                prompt = (IRuntimePrompt)PromptFinder.getPromptFinder(tempLang).getInstance(name);
                prompt.setSession(session);
                if (prompt instanceof Prompt) {
                    ((Prompt)prompt).setLanguage(language);
                }
                prompt.buildPrompt();
            }
            catch (Exception e) {
                session.throwRTException("Error instantiating prompt", e);
            }
        }
        return prompt;
    }

    public static boolean veryExists(String name, String language, SCESession session) throws Exception {
        return PromptFinder.getPromptFinder(language).verify(name);
    }

    public PromptFinder(String appLanguage) {
        super(appLanguage);
    }

    @Override
    protected String resolveName(String simpleName) {
        StringBuilder className = new StringBuilder(100);
        className.append(this.appLanguage);
        className.append(".");
        className.append("prompts");
        className.append(".");
        className.append(simpleName);
        return className.toString();
    }
}

