/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices;

import com.avaya.sce.runtimecommon.ITraceInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public final class DataUtility {
    public static final int ZERO = 0;
    public static final int TWO = 2;

    private DataUtility() {
    }

    public static String maskSensitiveDataJsonString(String input, ITraceInfo logger) {
        String methodName = "maskSensitiveDataString";
        String fieldName = "data";
        String result = input;
        logger.writeln(1, methodName);
        if (input != null && input.startsWith("{")) {
            String line;
            result = line = input.replaceAll("=", ":");
            try {
                JSONObject json = new JSONObject(line);
                if (!json.isNull(fieldName)) {
                    JSONObject obj = json.getJSONObject(fieldName);
                    HashMap map = (HashMap)new ObjectMapper().readValue(obj.toString(), HashMap.class);
                    String mask = DataUtility.processDataMap(map, logger);
                    JSONObject lineFixed = json.put(fieldName, (Object)new JSONObject("{" + mask + "}"));
                    result = lineFixed.toString();
                }
            }
            catch (IOException | JSONException e) {
                logger.writeln(4, methodName + " Error of mask the key values : " + e);
                result = null;
            }
        }
        logger.writeln(1, methodName + " " + result);
        return result;
    }

    protected static String processDataMap(Map<String, Object> map, ITraceInfo logger) {
        String methodName = "processDataMap";
        StringBuilder mapString = new StringBuilder();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getKey() == null || entry.getKey().isEmpty() || entry.getKey().trim().isEmpty()) {
                    logger.writeln(4, methodName + " " + entry.getKey() + "Data received contains a null or empty key.");
                    continue;
                }
                if (!mapString.toString().isEmpty()) {
                    mapString.append(',');
                }
                mapString.replace(0, mapString.length(), DataUtility.processDataMapEntry(mapString.toString(), entry));
            }
        } else {
            logger.writeln(4, methodName + " " + null + "Data parameter received is null.");
        }
        return mapString.toString();
    }

    private static String processDataMapEntry(String mapString, Map.Entry<String, Object> entry) {
        String entryString = mapString;
        Matcher mSensitive = Pattern.compile("^(?=\\*[^\\W_])[\\w~*-]++(\\.[\\w~*-]++)*+(?<=[^\\W_])*$").matcher(entry.getKey());
        if (!(entry.getValue() instanceof Map) && !mSensitive.matches()) {
            entryString = entryString + entry.getKey() + ":" + entry.getValue();
        } else if (entry.getValue() instanceof Map && !mSensitive.matches()) {
            entryString = entryString + entry.getKey() + ":" + entry.getValue().toString().replaceAll("=", ":");
        } else if (mSensitive.matches() && !(entry.getValue() instanceof Map)) {
            entryString = entryString + entry.getKey() + ":*****";
        } else if (mSensitive.matches() && entry.getValue() instanceof Map) {
            entryString = entryString + entry.getKey() + ":{*****}";
        }
        return entryString;
    }
}

