/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices.operations;

import com.avaya.sce.pdc.oceanaservices.IOceanaServices;
import com.avaya.sce.pdc.oceanaservices.OceanaServicesException;
import com.avaya.sce.pdc.oceanaservices.Utils;
import com.avaya.sce.pdc.oceanaservices.operations.OperationsHelper;
import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;

public class GetCustomerHistory
extends Debugging
implements IPluggableExecutable {
    private static final String OP = "Get Customer History";
    private String customerManagementIpVar;
    private String customerManagementIpField;
    private boolean cmIpIsConstant;
    private String workRequestIdVar;
    private String workRequestIdField;
    private String customerIdVar;
    private String customerIdField;
    private String destVar;
    private String destField;

    public GetCustomerHistory(String customerManagementIpVar, String customerManagementIpField, boolean cmIpIsConstant, String workRequestIdVar, String workRequestIdField, String customerIdVar, String customerIdField, String destVar, String destField) {
        this.customerManagementIpVar = customerManagementIpVar;
        this.customerManagementIpField = customerManagementIpField;
        this.cmIpIsConstant = cmIpIsConstant;
        this.customerIdVar = customerIdVar;
        this.customerIdField = customerIdField;
        this.workRequestIdField = workRequestIdField;
        this.workRequestIdVar = workRequestIdVar;
        this.destVar = destVar;
        this.destField = destField;
    }

    public void execute(IRuntimeSession rtSession) {
        String resultMessage = "ERROR : ";
        SCESession mySession = (SCESession)rtSession;
        Exception ex = null;
        try {
            OperationsHelper.setFieldsToNull(this.customerIdField);
            OperationsHelper.setFieldsToNull(this.workRequestIdField);
            OperationsHelper.setFieldsToNull(this.destField);
            OperationsHelper.setFieldsToNull(this.customerManagementIpField);
            String customerManagementIp = Utils.getValueFromParameter(this.customerManagementIpVar, this.customerManagementIpField, this.cmIpIsConstant, mySession);
            String customerId = "";
            if (this.customerIdVar.length() > 0) {
                customerId = mySession.getVariableField(new VariableName(this.customerIdVar, this.customerIdField)).getStringValue();
            }
            String workRequestId = "";
            if (this.workRequestIdVar.length() > 0) {
                workRequestId = mySession.getVariableField(new VariableName(this.workRequestIdVar, this.workRequestIdField)).getStringValue();
            }
            if (mySession.isTraceEnabled()) {
                ITraceInfo tr = mySession.getTraceOutput();
                tr.writeln(2, "Customer Management cluster IP/FQDN: " + customerManagementIp + ", customerId: " + customerId + ", workRequestId: " + workRequestId);
            }
            IVariableField dest = mySession.getVariableField(new VariableName(this.destVar, this.destField));
            IOceanaServices oas = OperationsHelper.getOceanaServices(mySession, null, OP);
            String result = oas.getCustomerHistory(customerId, workRequestId, customerManagementIp, mySession);
            OperationsHelper.traceOperationSuccess(mySession, OP, result);
            dest.setValue(result);
            return;
        }
        catch (OceanaServicesException e) {
            resultMessage = resultMessage + "Fail Get Customer History : " + e;
            ex = e;
        }
        catch (Exception e) {
            resultMessage = resultMessage + "Could not Get Customer History : " + e;
            ex = e;
        }
        mySession.throwRTException(resultMessage, ex);
    }

    public String getId() {
        return Utils.getOceanaServices();
    }

    public String getTraceMessage() {
        return "Get Customer History ->" + this.customerIdVar + ":" + this.customerIdField;
    }
}

