/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices.operations;

import com.avaya.sce.pdc.oceanaservices.Utils;
import com.avaya.sce.pdc.oceanaservices.operations.OperationsHelper;
import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONBuilder
extends Debugging
implements IPluggableExecutable {
    private static final Logger LOGGER = Logger.getLogger(JSONBuilder.class.getName());
    private String destVar;
    private String destField;
    private String pathVar;
    private String pathField;
    private boolean pathIsConstant;
    private String valueVar;
    private String valueField;
    private boolean valueIsConstant;
    private boolean useArray;
    private static final String OP = "Build JSON";

    public JSONBuilder(String destVar, String destField, String pathVar, String pathField, boolean pathIsConstant, String valueVar, String valueField, boolean valueIsConstant, boolean useArray) {
        this.destVar = destVar;
        this.destField = destField;
        this.pathVar = pathVar;
        this.pathField = pathField;
        this.pathIsConstant = pathIsConstant;
        this.valueVar = valueVar;
        this.valueField = valueField;
        this.valueIsConstant = valueIsConstant;
        this.useArray = useArray;
    }

    public String getId() {
        return Utils.getOceanaServices();
    }

    public String getTraceMessage() {
        return "Build JSON ->" + this.destVar + ":" + this.destField;
    }

    public void execute(IRuntimeSession rtSession) {
        String resultMessage = "ERROR : ";
        SCESession mySession = (SCESession)rtSession;
        try {
            OperationsHelper.setFieldsToNull(this.destField);
            OperationsHelper.setFieldsToNull(this.pathField);
            OperationsHelper.setFieldsToNull(this.valueField);
            IVariableField dest = mySession.getVariableField(new VariableName(this.destVar, this.destField));
            String path = Utils.getValueFromParameter(this.pathVar, this.pathField, this.pathIsConstant, mySession);
            Object value = Utils.getValueFromParameter(this.valueVar, this.valueField, this.valueIsConstant, mySession, this.useArray);
            if (rtSession.isTraceEnabled()) {
                rtSession.getTraceOutput().writeln(1, "Path : " + path);
            }
            path = Utils.substituteVaraiables(mySession, path);
            if (rtSession.isTraceEnabled()) {
                rtSession.getTraceOutput().writeln(1, "True Path : " + path);
            }
            String jsonStr = dest.getStringValue();
            JSONObject json = this.getJsonObject(mySession, jsonStr);
            this.buildJson(dest, path, value, json);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "", e);
            resultMessage = resultMessage + "Could not Build JSON : " + e;
            Exception ex = e;
            mySession.throwRTException(resultMessage, ex);
        }
    }

    private JSONObject getJsonObject(SCESession mySession, String jsonStr) {
        JSONObject json;
        block2: {
            try {
                json = new JSONObject(jsonStr);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "", e);
                json = new JSONObject();
                if (!mySession.isTraceEnabled()) break block2;
                ITraceInfo tr = mySession.getTraceOutput();
                tr.writeln(1, "Value was not a JSON string, initializing to empty");
            }
        }
        return json;
    }

    private void buildJson(IVariableField dest, String path, Object value, JSONObject json) {
        JSONObject jsonMain = json;
        String[] segments = path.split("/");
        for (int i = 0; i < segments.length; ++i) {
            JSONObject temp;
            if (i == segments.length - 1) {
                if (value.getClass().isArray()) {
                    value = new JSONArray(value);
                }
                json.put(segments[i], value);
                continue;
            }
            try {
                temp = json.getJSONObject(segments[i]);
            }
            catch (JSONException e) {
                temp = new JSONObject();
                json.put(segments[i], (Object)temp);
                LOGGER.log(Level.WARNING, "", e);
            }
            json = temp;
        }
        dest.setValue(jsonMain.toString());
    }
}

