/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model;

import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidQueryResource;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ValidQueryResource
public class QueryResourceRequest {
    @ApiModelProperty(value="Ordering to use when querying resources", required=true, allowableValues="LEAST_OCCUPIED, AVAILABILITY, PROFICIENCY", position=1)
    @NotNull(message="The ordering cannot be null")
    @Pattern(regexp="LEAST_OCCUPIED|AVAILABILITY|PROFICIENCY", message="The provided ordering key must be one of LEAST_OCCUPIED, AVAILABILITY or PROFICIENCY")
    private String ordering;
    @ApiModelProperty(value="Service we want to query against", required=true, notes="must not be null", position=2)
    @NotNull(message="The service cannot be null")
    @Valid
    private Map<Integer, Service> serviceMap;

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public Map<Integer, Service> getServiceMap() {
        return this.serviceMap;
    }

    public void setServiceMap(Map<Integer, Service> serviceMap) {
        this.serviceMap = serviceMap;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

