/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.MatchRequestSync;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidMultiResource;
import com.avaya.ingensg.ce.wa.imrest.common.utils.MatchType;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidMultiResourceValidator
implements ConstraintValidator<ValidMultiResource, MatchRequestSync> {
    private static final String MULTI_RESOURCE = "MULTI_RESOURCE";
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(ValidMultiResourceValidator.class);
    public static final int TOTAL_PERMITTED_RESOURCE_COUNT = 50;
    public static final int MAX_RESOURCE_COUNT_PER_SERVICE = 10;

    public void initialize(ValidMultiResource constraintAnnotation) {
    }

    public boolean isValid(MatchRequestSync matchRequestSync, ConstraintValidatorContext context) {
        String methodName = "isValid";
        if (null == matchRequestSync) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        Boolean valid = true;
        String taskType = matchRequestSync.getTaskType();
        String matchType = matchRequestSync.getMatchType();
        Map<Integer, Service> serviceMap = matchRequestSync.getServiceMap();
        this.setMatchType(matchRequestSync, taskType, matchType);
        if (MULTI_RESOURCE.equals(taskType) && null != serviceMap) {
            String workRequestId = matchRequestSync.getWorkRequestId();
            if (this.isWorkRequestIdEmpty(workRequestId)) {
                valid = false;
                LOG.error("isValid", "", "For a SINGLE_RESOURCE workRequestId must not be null or empty {}", new Object[]{matchRequestSync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidMultiResource.workRequestId}").addConstraintViolation();
            }
            if (serviceMap.size() != 1) {
                valid = false;
                LOG.error("isValid", "", "The MULTI_RESOURCE request serviceMap must contain only 1 service. {}", new Object[]{matchRequestSync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidMultiResource.serviceMapSize}").addConstraintViolation();
            } else if (!this.isValidServices(serviceMap, matchRequestSync, context)) {
                valid = false;
            }
        }
        if (this.isNotValidMatchTypeForMultiResource(taskType, matchType)) {
            valid = false;
            LOG.error("isValid", "", " The provided match type must be one of PARTIAL or FULL", new Object[]{matchRequestSync});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidMultiResource.matchType}").addConstraintViolation();
        }
        return valid;
    }

    private boolean isWorkRequestIdEmpty(String workRequestId) {
        return workRequestId == null || workRequestId.isEmpty();
    }

    private boolean isValidServices(Map<Integer, Service> serviceMap, MatchRequestSync matchRequestSync, ConstraintValidatorContext context) {
        String methodName = "isValidServices";
        boolean valid = true;
        Integer totalResourceCount = 0;
        for (Service service : serviceMap.values()) {
            Integer resourceCount = service.getResourceCount();
            Integer priority = service.getPriority();
            Integer rank = service.getRank();
            if (null == resourceCount) {
                valid = false;
                LOG.error("isValidServices", "", "For a MULTI_RESOURCE request priority must not be specified. {}", new Object[]{matchRequestSync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidMultiResource.resourceCount}").addConstraintViolation();
            } else {
                totalResourceCount = totalResourceCount + resourceCount;
            }
            if (null != priority) {
                valid = false;
                LOG.error("isValidServices", "", "For a MULTI_RESOURCE request priority must not be specified. {}", new Object[]{matchRequestSync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidMultiResource.priority}").addConstraintViolation();
            }
            if (null != rank) {
                valid = false;
                LOG.error("isValidServices", "", "For a MULTI_RESOURCE request rank must not be specified. {}", new Object[]{matchRequestSync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidMultiResource.rank}").addConstraintViolation();
            }
            if (totalResourceCount <= 50) continue;
            valid = false;
            LOG.error("isValidServices", "", "The MULTI_RESOURCE request resourceCount exceeds the max 50. {}", new Object[]{matchRequestSync});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidMultiResource.maxResourceCount}").addConstraintViolation();
        }
        return valid;
    }

    private boolean isNotValidMatchTypeForMultiResource(String taskType, String matchType) {
        return MULTI_RESOURCE.equals(taskType) && null != matchType && MatchType.findMatchTypeString(matchType) == null;
    }

    private void setMatchType(MatchRequestSync matchRequestSync, String taskType, String matchType) {
        if (MULTI_RESOURCE.equals(taskType) && matchType == null) {
            matchRequestSync.setMatchType("FULL");
        }
    }
}

