/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.MatchRequestAsync;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidSingleResourceValidator
implements ConstraintValidator<ValidSingleResource, MatchRequestAsync> {
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(ValidSingleResourceValidator.class);

    public void initialize(ValidSingleResource constraintAnnotation) {
    }

    public boolean isValid(MatchRequestAsync matchRequestAsync, ConstraintValidatorContext context) {
        String methodName = "isValid";
        if (null == matchRequestAsync) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        Boolean valid = true;
        String taskType = matchRequestAsync.getTaskType();
        Map<Integer, Service> serviceMap = matchRequestAsync.getServiceMap();
        if ("SINGLE_RESOURCE".equals(taskType) && null != serviceMap) {
            String workRequestId = matchRequestAsync.getWorkRequestId();
            if (workRequestId == null || workRequestId.isEmpty()) {
                valid = false;
                LOG.error("isValid", "", "For a SINGLE_RESOURCE workRequestId must not be null or empty {}", new Object[]{workRequestId});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource.workRequestId}").addConstraintViolation();
            }
            if (!this.isValidService(serviceMap, matchRequestAsync, context)) {
                valid = false;
            }
        }
        return valid;
    }

    private boolean isValidService(Map<Integer, Service> serviceMap, MatchRequestAsync matchRequestAsync, ConstraintValidatorContext context) {
        String methodName = "isValidService";
        boolean valid = true;
        for (Service service : serviceMap.values()) {
            Integer resourceCount = service.getResourceCount();
            Integer priority = service.getPriority();
            Integer rank = service.getRank();
            if (rank != null && rank < 1) {
                valid = false;
                LOG.error("isValidService", "", "For a SINGLE_RESOURCE request rank must be null or a value between 1 - 2^31-1 {}", new Object[]{matchRequestAsync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource.rank}").addConstraintViolation();
            }
            if (null != resourceCount && resourceCount != 1) {
                valid = false;
                LOG.error("isValidService", "", "For a SINGLE_RESOURCE request resourceCount must be null or 1. {}", new Object[]{matchRequestAsync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource.resourceCount}").addConstraintViolation();
            }
            if (null == priority) {
                valid = false;
                LOG.error("isValidService", "", "For a SINGLE_RESOURCE request a priority must be specified. {}", new Object[]{matchRequestAsync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource.priority}").addConstraintViolation();
            }
            if (valid) continue;
            break;
        }
        return valid;
    }
}

