/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc;

import java.util.HashMap;
import java.util.Map;

public enum OperationType {
    GET_AUDIT_DATA("Get Audit Data"),
    GET_AUDIT_DATA_BY_ALIASID("Get Audit Data By Alias Id"),
    GET_DATA("Get Data"),
    GET_DATA_BY_ALIASID("Get Data By Alias Id"),
    GET_VALUE("Get Value"),
    GET_VALUE_BY_ALIASID("Get Value By Alias Id"),
    GET_CONTEXT_IDS("Get Context Ids"),
    PUT_DATA("Put Data"),
    PUT_DATA_BY_ALIASID("Put Data By Alias Id"),
    PUT_VALUE("Put Value"),
    PUT_VALUE_BY_ALIASID("Put Value By Alias Id"),
    PUT_ALIASID("Put Alias Id By Context Id"),
    PUT_ALIASID_BY_ALIASID("Put Alias Id By Alias Id"),
    UPSERT_CONTEXT("Upsert Context"),
    UPSERT_CONTEXT_BY_ALIASID("Upsert Context By Alias Id"),
    POST_CONTEXT("Post Context"),
    POST_CONTEXT_WITH_ALIASID("Post Context With Alias Id"),
    DELETE_CONTEXT("Delete Context"),
    DELETE_CONTEXT_BY_ALIASID("Delete Context By Alias Id"),
    DELETE_VALUE("Delete Value"),
    DELETE_VALUE_BY_ALIASID("Delete Value By Alias Id"),
    DELETE_ALIASID("Delete Alias Id");

    private static final Map<String, OperationType> CONVERT_MAP;
    private final String description;

    private OperationType(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    public static OperationType byDescription(String description) {
        return CONVERT_MAP.get(description);
    }

    static {
        CONVERT_MAP = new HashMap<String, OperationType>();
        CONVERT_MAP.put(GET_AUDIT_DATA.description(), GET_AUDIT_DATA);
        CONVERT_MAP.put(GET_AUDIT_DATA_BY_ALIASID.description(), GET_AUDIT_DATA_BY_ALIASID);
        CONVERT_MAP.put(GET_DATA.description(), GET_DATA);
        CONVERT_MAP.put(GET_DATA_BY_ALIASID.description(), GET_DATA_BY_ALIASID);
        CONVERT_MAP.put(GET_VALUE.description(), GET_VALUE);
        CONVERT_MAP.put(GET_VALUE_BY_ALIASID.description(), GET_VALUE_BY_ALIASID);
        CONVERT_MAP.put(GET_CONTEXT_IDS.description(), GET_CONTEXT_IDS);
        CONVERT_MAP.put(PUT_DATA.description(), PUT_DATA);
        CONVERT_MAP.put(PUT_DATA_BY_ALIASID.description(), PUT_DATA_BY_ALIASID);
        CONVERT_MAP.put(PUT_VALUE.description(), PUT_VALUE);
        CONVERT_MAP.put(PUT_VALUE_BY_ALIASID.description(), PUT_VALUE_BY_ALIASID);
        CONVERT_MAP.put(PUT_ALIASID.description(), PUT_ALIASID);
        CONVERT_MAP.put(PUT_ALIASID_BY_ALIASID.description(), PUT_ALIASID_BY_ALIASID);
        CONVERT_MAP.put(UPSERT_CONTEXT.description(), UPSERT_CONTEXT);
        CONVERT_MAP.put(UPSERT_CONTEXT_BY_ALIASID.description(), UPSERT_CONTEXT_BY_ALIASID);
        CONVERT_MAP.put(POST_CONTEXT.description(), POST_CONTEXT);
        CONVERT_MAP.put(POST_CONTEXT_WITH_ALIASID.description(), POST_CONTEXT_WITH_ALIASID);
        CONVERT_MAP.put(DELETE_CONTEXT.description(), DELETE_CONTEXT);
        CONVERT_MAP.put(DELETE_CONTEXT_BY_ALIASID.description(), DELETE_CONTEXT_BY_ALIASID);
        CONVERT_MAP.put(DELETE_VALUE.description(), DELETE_VALUE);
        CONVERT_MAP.put(DELETE_VALUE_BY_ALIASID.description(), DELETE_VALUE_BY_ALIASID);
        CONVERT_MAP.put(DELETE_ALIASID.description(), DELETE_ALIASID);
    }
}

