/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc.service;

import com.avaya.cs.pdc.Config;
import com.avaya.cs.pdc.service.AbstractOperation;
import com.avaya.cs.pdc.service.Response;
import com.avaya.cs.pdc.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSimulatorOperation
extends AbstractOperation {
    public static final String DEFAULT_MACHINE = "localhost";
    public static final int DEFAULT_PORT = 6601;
    public static final int THREE = 3;
    public static final int FOUR = 4;
    public static final String BYE = "bye";
    public static final String MESSAGE_RETURN_SUCCESS = "Success";
    public static final String MESSAGE_RETURN_NOT_FOUND = "Not Found";
    public static final String MESSAGE_RETURN_NOT_VALID = "Validation Error";
    public static final String MESSAGE_RETURN_UNAUTHORIZED = "Authentication Error";
    public static final String MESSAGE_RETURN_CONTEXT_ALREADY_EXISTS = "Context Id already exists";

    public AbstractSimulatorOperation(Config config, String ip, String id, String rid, String key, String json, String touchpoint, String groupId, Boolean aliasRequest) {
        super(config, ip, id, rid, key, json, touchpoint, groupId, aliasRequest);
    }

    abstract Response treatResponse(String var1, String var2, String var3);

    @Override
    public Response execute() {
        Pair<Boolean, List<String>> validate = this.validate();
        if (validate.getP1().booleanValue()) {
            List<String> result = this.sendCommand();
            String id = result.size() > 0 ? StringUtils.defaultString((String)result.get(0)) : "";
            String key = result.size() > 1 ? StringUtils.defaultString((String)result.get(1)) : "";
            String sso = result.size() > 2 ? StringUtils.defaultString((String)result.get(2)) : "";
            String user = result.size() > 3 ? StringUtils.defaultString((String)result.get(3)) : "";
            String password = result.size() > 4 ? StringUtils.defaultString((String)result.get(4)) : "";
            return this.respondBasedOnVerfiedCredentials(user, password, id, key, sso);
        }
        return new Response(500, MESSAGE_RETURN_NOT_VALID, StringUtils.join((Iterable)validate.getP2(), (String)"\r\n"));
    }

    private Response respondBasedOnVerfiedCredentials(String user, String password, String id, String key, String sso) {
        if (this.verifyCredential(user, password)) {
            return this.treatResponse(id, key, sso);
        }
        return new Response(401, MESSAGE_RETURN_UNAUTHORIZED, null);
    }

    private boolean verifyCredential(String user, String password) {
        Config config = this.getConfig();
        if (config == null) {
            return false;
        }
        return StringUtils.equals((CharSequence)config.getUser(), (CharSequence)user) && StringUtils.equals((CharSequence)config.getPassword(), (CharSequence)password);
    }

    private List<String> sendCommand() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Socket client = SocketFactory.getDefault().createSocket(DEFAULT_MACHINE, 6601);
            try (PrintWriter out = new PrintWriter(client.getOutputStream(), true);
                 BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8"));){
                String line;
                out.println(BYE);
                while ((line = in.readLine()) != null) {
                    if (line.equals(BYE)) {
                        break;
                    }
                    result.add(line);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception occurred while making request to Simulator Server.", e);
        }
        return result;
    }
}

