/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc.util;

import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.ITraceInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class Logger {
    protected Logger() {
    }

    public static void info(IRuntimeSession session, String message) {
        if (Logger.checkSession(session)) {
            ITraceInfo tr = session.getTraceOutput();
            tr.writeln(2, message);
        }
    }

    protected static boolean checkSession(IRuntimeSession session) {
        return session != null && session.isTraceEnabled();
    }

    public static void error(IRuntimeSession session, String message, Throwable t) {
        if (Logger.checkSession(session)) {
            ITraceInfo tr = session.getTraceOutput();
            String erroMessage = message;
            if (t != null) {
                erroMessage = erroMessage + "[" + Logger.getStackTrace(t) + "]";
            }
            tr.writeln(4, erroMessage);
        }
    }

    public static void error(IRuntimeSession session, String message) {
        Logger.error(session, message, null);
    }

    public static String getStackTrace(Throwable t) {
        return ExceptionUtils.getStackTrace((Throwable)t);
    }
}

