/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.restws;

import com.avaya.sce.runtimecommon.ICollection;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;

public class VariableAccess {
    public static void storeSimple(IRuntimeSession mySession, VariableName varName, Object value, String baseType) {
        IVariableField var = mySession.getVariableField(varName);
        if (var == null) {
            mySession.throwRTException("Variable " + varName + " does not exist");
        }
        if (baseType.equals("int")) {
            var.setValue(value, IVariableField.VarDataType.INT);
        } else if (baseType.equals("boolean")) {
            var.setValue(value, IVariableField.VarDataType.BOOLEAN);
        } else if (baseType.equals("long")) {
            var.setValue(value, IVariableField.VarDataType.LONG);
        } else if (baseType.equals("float")) {
            var.setValue(value, IVariableField.VarDataType.FLOAT);
        } else if (baseType.equals("string")) {
            var.setValue(value, IVariableField.VarDataType.STRING);
        } else if (baseType.equals("short")) {
            var.setValue(value, IVariableField.VarDataType.SHORT);
        } else if (baseType.equals("double")) {
            var.setValue(value, IVariableField.VarDataType.DOUBLE);
        } else if (baseType.equals("byte")) {
            var.setValue(value, IVariableField.VarDataType.BYTE);
        } else if (baseType.equals("integer")) {
            var.setValue((Object)((BigInteger)value).toString(), IVariableField.VarDataType.STRING);
        } else if (baseType.equals("decimal")) {
            var.setValue((Object)((BigDecimal)value).toString(), IVariableField.VarDataType.STRING);
        } else if (baseType.equals("dateTime")) {
            var.setValue((Object)((Calendar)value).toString(), IVariableField.VarDataType.STRING);
        } else {
            var.setValue(value, IVariableField.VarDataType.OBJECT);
        }
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(1, "Storing [" + value + "] to: " + varName);
        }
    }

    private static void setFieldValue(IVariableField field, Object value) {
        if (value instanceof Integer) {
            field.setValue(((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            field.setValue(((Boolean)value).booleanValue());
        } else if (value instanceof String) {
            field.setValue(((String)value).toString());
        } else if (value instanceof Float) {
            field.setValue(((Float)value).floatValue());
        } else if (value instanceof Double) {
            field.setValue(((Double)value).doubleValue());
        } else if (value instanceof Long) {
            field.setValue(((Long)value).longValue());
        } else if (value instanceof Short) {
            field.setValue(((Short)value).shortValue());
        } else if (value instanceof Byte) {
            field.setValue(((Byte)value).byteValue());
        } else {
            field.setValue(value);
        }
    }

    public static void storeSimpleArray(IRuntimeSession mySession, VariableName varName, Object value) {
        IVariable var = mySession.getVariable(varName.getVarName());
        IVariableField field = var.getSimpleVariable();
        ICollection collection = var.addCollection();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            Object val = Array.get(value, i);
            VariableAccess.setFieldValue(field, val);
            collection.append();
            if (!mySession.isTraceEnabled()) continue;
            mySession.getTraceOutput().writeln(1, "Storing [" + val + "] to: " + varName + "[" + i + "]");
        }
        collection.reset();
        if (collection.size() > 0) {
            collection.next();
        }
    }

    public static void storeBeanArray(IRuntimeSession mySession, VariableName varName, Object value) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        ArrayList<Object> values;
        IVariable var = mySession.getVariable(varName.getVarName());
        ICollection collection = var.addCollection();
        if (!(value instanceof ArrayList)) {
            Class<?> c = value.getClass();
            if (c.isArray()) {
                int length = Array.getLength(value);
                values = new ArrayList();
                for (int i = 0; i < length; ++i) {
                    values.add(Array.get(value, i));
                }
            } else {
                values = new ArrayList<Object>();
                values.add(value);
            }
        } else {
            values = (ArrayList<Object>)value;
        }
        int length = values.size();
        for (int i = 0; i < length; ++i) {
            Object val = values.get(i);
            BeanInfo bi = Introspector.getBeanInfo(val.getClass());
            PropertyDescriptor[] pd = bi.getPropertyDescriptors();
            for (int j = 0; j < pd.length; ++j) {
                Method rm = pd[j].getReadMethod();
                Object fieldValue = rm.invoke(val, (Object[])null);
                IVariableField field = mySession.getVariableField(varName.getVarName(), pd[j].getName());
                if (field == null) continue;
                VariableAccess.setFieldValue(field, fieldValue);
                if (!mySession.isTraceEnabled()) continue;
                mySession.getTraceOutput().writeln(1, "Storing [" + fieldValue + "] to: " + varName + ":" + pd[j].getName());
            }
            collection.append();
        }
        collection.reset();
        if (collection.size() > 0) {
            collection.next();
        }
    }

    public static void storeBean(IRuntimeSession mySession, VariableName varName, Object value) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        BeanInfo bi = Introspector.getBeanInfo(value.getClass());
        PropertyDescriptor[] pd = bi.getPropertyDescriptors();
        for (int j = 0; j < pd.length; ++j) {
            Method rm = pd[j].getReadMethod();
            if (rm == null) continue;
            Object fieldValue = rm.invoke(value, (Object[])null);
            IVariableField field = mySession.getVariableField(varName.getVarName(), pd[j].getName());
            if (field == null) continue;
            VariableAccess.setFieldValue(field, fieldValue);
            if (!mySession.isTraceEnabled()) continue;
            mySession.getTraceOutput().writeln(1, "Storing [" + fieldValue + "] to: " + varName + ":" + pd[j].getName());
        }
    }

    public static void storeObject(IRuntimeSession mySession, VariableName varName, Object value) {
        IVariableField var = mySession.getVariableField(varName);
        if (var == null) {
            mySession.throwRTException("Variable " + varName + " does not exist");
        }
        var.setValue(value, IVariableField.VarDataType.OBJECT);
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(1, "Storing [" + value + "] to: " + varName);
        }
    }

    public static String getSimple(IRuntimeSession mySession, VariableName varName) {
        Object varValue;
        IVariableField var = mySession.getVariableField(varName);
        if (var == null) {
            mySession.throwRTException("Variable " + varName + " does not exist");
        }
        if ((varValue = var.getObjectValue()) == null) {
            mySession.throwRTException("Variable " + varName + " is not set");
        }
        return var.getStringValue();
    }

    public static Object getObject(IRuntimeSession mySession, VariableName varName) throws Exception {
        IVariableField var = mySession.getVariableField(varName);
        Object value = var.getObjectValue();
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(1, "Collecting [" + value + "] from:" + varName);
        }
        return value;
    }

    public static void setDDNull(IRuntimeSession mySession, VariableName varName) {
        VariableAccess.storeSimple(mySession, varName, "__DD_NULL", "string");
    }
}

