/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.clientutils.jsonmapper;

import com.avaya.ingensg.ce.wa.imrest.common.model.MatchRequest;
import com.avaya.ingensg.ce.wa.imrest.common.model.MatchRequestAsync;
import com.avaya.ingensg.ce.wa.imrest.common.model.MatchRequestSync;
import com.avaya.ingensg.ce.wa.imrest.common.model.MatchUpdateRequest;
import com.avaya.ingensg.ce.wa.imrest.common.model.MetricsRequest;
import com.avaya.ingensg.ce.wa.imrest.common.model.QueryResourceRequest;
import com.avaya.ingensg.ce.wa.imrest.common.model.Resource;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class RequestJsonBuilder {
    private static final String STRIP_UNKNOWN_ATTRIBUTES = "after stripping unknown attributes : {}";
    private static final String STRIP_INVALID_ATTRIBUTES = "after stripping invalid attributes : {}";
    private static final String EXCEP_SERIAL_JSON = "Exception while serialising jason string";
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(RequestJsonBuilder.class);
    private static volatile RequestJsonBuilder requestBuilder;
    private static ObjectMapper objectMapper;
    private static volatile Object lock;
    private static Map<REQUEST_TYPE, Class<?>> supportedTypes;

    private RequestJsonBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestJsonBuilder getBuilder() {
        if (requestBuilder == null) {
            Object object = lock;
            synchronized (object) {
                if (requestBuilder == null) {
                    requestBuilder = new RequestJsonBuilder();
                    objectMapper = new ObjectMapper();
                    objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    supportedTypes = new HashMap();
                    supportedTypes.put(REQUEST_TYPE.ASYNC, MatchRequestAsync.class);
                    supportedTypes.put(REQUEST_TYPE.SYNC, MatchRequestSync.class);
                    supportedTypes.put(REQUEST_TYPE.METRICS, MetricsRequest.class);
                    supportedTypes.put(REQUEST_TYPE.UPDATE, MatchUpdateRequest.class);
                    supportedTypes.put(REQUEST_TYPE.QUERY_RESOURCE, QueryResourceRequest.class);
                    supportedTypes.put(REQUEST_TYPE.SERVICE, Map.class);
                }
            }
        }
        return requestBuilder;
    }

    public String createRequestJsonString(REQUEST_TYPE requestTye, String jsonStringInput) throws IOException {
        String methodName = "createRequestJsonString";
        LOG.trace("createRequestJsonString", "", "creating a request JSonString from : {}", new Object[]{jsonStringInput});
        Class<?> classTypeToCreate = supportedTypes.get((Object)requestTye);
        if (classTypeToCreate == null) {
            throw new IllegalArgumentException("[ " + (Object)((Object)requestTye) + " ] is not a supported type. Type should be one of " + Arrays.asList(REQUEST_TYPE.values()));
        }
        try {
            Object requestObject = objectMapper.readValue(jsonStringInput, classTypeToCreate);
            String jsonWithoutUnknownAttributes = objectMapper.writeValueAsString(requestObject);
            LOG.trace("createRequestJsonString", "", STRIP_UNKNOWN_ATTRIBUTES, new Object[]{jsonWithoutUnknownAttributes});
            this.checkForInValidAttributes(requestObject);
            String resultantJsonString = objectMapper.writeValueAsString(requestObject);
            LOG.trace("createRequestJsonString", "", STRIP_INVALID_ATTRIBUTES, new Object[]{resultantJsonString});
            return resultantJsonString;
        }
        catch (IOException e) {
            LOG.error("createRequestJsonString", "", "createRequestJsonString", new Object[]{EXCEP_SERIAL_JSON});
            throw e;
        }
    }

    public String createServiceJsonString(SERVICE_TYPE taskType, String jsonStringInput) throws IOException {
        String methodName = "createServiceJsonString";
        LOG.trace("createServiceJsonString", "", "creating a Service JSonString for {} from : {}", new Object[]{taskType.name(), jsonStringInput});
        try {
            Map mapObject = (Map)objectMapper.readValue(jsonStringInput, (TypeReference)new TypeReference<Map<Integer, Service>>(){});
            LOG.trace("createServiceJsonString", "", STRIP_UNKNOWN_ATTRIBUTES, new Object[]{mapObject});
            for (Map.Entry service : mapObject.entrySet()) {
                this.stripInvalidServiceAttributes(taskType.name(), (Service)service.getValue());
            }
            String resultantJsonString = objectMapper.writeValueAsString((Object)mapObject);
            LOG.trace("createServiceJsonString", "", STRIP_INVALID_ATTRIBUTES, new Object[]{resultantJsonString});
            return resultantJsonString;
        }
        catch (IOException e) {
            LOG.error("createServiceJsonString", "", "createServiceJsonString", new Object[]{EXCEP_SERIAL_JSON});
            throw e;
        }
    }

    public String createResourceJsonString(String jsonStringInput) throws IOException {
        String methodName = "createResourceJsonString";
        LOG.trace("createResourceJsonString", "", "creating a Resource JSonString from : {}", new Object[]{jsonStringInput});
        try {
            Map mapObject = (Map)objectMapper.readValue(jsonStringInput, (TypeReference)new TypeReference<Map<Integer, Resource>>(){});
            LOG.trace("createResourceJsonString", "", STRIP_UNKNOWN_ATTRIBUTES, new Object[]{mapObject});
            String resultantJsonString = objectMapper.writeValueAsString((Object)mapObject);
            LOG.trace("createResourceJsonString", "", STRIP_INVALID_ATTRIBUTES, new Object[]{resultantJsonString});
            return resultantJsonString;
        }
        catch (IOException e) {
            LOG.error("createResourceJsonString", "", "createResourceJsonString", new Object[]{EXCEP_SERIAL_JSON});
            throw e;
        }
    }

    private void checkForInValidAttributes(Object pojo) throws IOException {
        if (pojo instanceof MatchRequest) {
            this.stripInValidAttributes((MatchRequest)pojo);
        } else if (pojo instanceof QueryResourceRequest) {
            this.stripInValidAttributes((QueryResourceRequest)pojo);
        } else if (pojo instanceof MatchUpdateRequest) {
            this.stripInValidAttributes((MatchUpdateRequest)pojo);
        }
    }

    private void stripInValidAttributes(MatchRequest matchRequest) throws IOException {
        String methodName = "stripInValidAttributes:MatchRequest";
        if ("MULTI_RESOURCE".equals(matchRequest.getTaskType()) || "GROUP_RESOURCE".equals(matchRequest.getTaskType())) {
            for (Service service : matchRequest.getServiceMap().values()) {
                this.stripInvalidServiceAttributes(matchRequest.getTaskType(), service);
            }
        } else if ("SINGLE_RESOURCE".equals(matchRequest.getTaskType())) {
            Map<Integer, Service> serviceMap = matchRequest.getServiceMap();
            for (Service service : serviceMap.values()) {
                Integer resourceCount = service.getResourceCount();
                if (null == resourceCount || resourceCount == 1) continue;
                LOG.trace("stripInValidAttributes:MatchRequest", "", " setting 'null' to ResourceCount since {} is not a valid value for 'SINGLE_RESOURCE'", new Object[]{resourceCount});
                service.setResourceCount(null);
            }
            if (matchRequest instanceof MatchRequestSync) {
                LOG.trace("stripInValidAttributes:MatchRequest", "", " removing 'matchType'since this MatchRequestSync is a 'SINGLE_RESOURCE'", new Object[0]);
                ((MatchRequestSync)matchRequest).setMatchType(null);
            }
        }
    }

    private void stripInValidAttributes(QueryResourceRequest queryResource) throws IOException {
        for (Service service : queryResource.getServiceMap().values()) {
            this.stripInvalidServiceAttributes(SERVICE_TYPE.QUERY_RESOURCE.name(), service);
        }
    }

    private void stripInValidAttributes(MatchUpdateRequest matchUpdateRequest) throws IOException {
        for (Service service : matchUpdateRequest.getServiceMap().values()) {
            this.stripInvalidServiceAttributes(SERVICE_TYPE.UPDATE.name(), service);
        }
    }

    private void stripInvalidServiceAttributes(String taskType, Service service) {
        String methodName = "stripInvalidServiceAttributes";
        if (taskType.equals(SERVICE_TYPE.MULTI_RESOURCE.name()) || taskType.equals(SERVICE_TYPE.GROUP_RESOURCE.name())) {
            LOG.trace("stripInvalidServiceAttributes", "", " removing 'priority' and 'rank' since this is a 'MULTI_RESOURCE' or 'GROUP_RESOURCE'", new Object[0]);
            service.setPriority(null);
            service.setRank(null);
        } else if (taskType.equals(SERVICE_TYPE.QUERY_RESOURCE.name())) {
            LOG.trace("stripInvalidServiceAttributes", "", " removing 'priority' and 'rank' since this is a QueryResourceRequest", new Object[0]);
            service.setPriority(null);
            service.setRank(null);
        } else if (taskType.equals(SERVICE_TYPE.UPDATE.name())) {
            LOG.trace("stripInvalidServiceAttributes", "", " removing 'rank' from this MatchUpdate", new Object[0]);
            service.setRank(null);
        }
    }

    static {
        lock = new Object();
    }

    public static enum SERVICE_TYPE {
        SINGLE_RESOURCE,
        UPDATE,
        MULTI_RESOURCE,
        GROUP_RESOURCE,
        QUERY_RESOURCE;

    }

    public static enum REQUEST_TYPE {
        ASYNC,
        SYNC,
        METRICS,
        UPDATE,
        QUERY_RESOURCE,
        SERVICE;

    }
}

