/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model;

import com.avaya.ingensg.ce.wa.imrest.common.model.Resource;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.EnumValue;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidService;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource;
import com.avaya.ingensg.wa.common.im.RejectReason;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ValidSpecifiedResource
public class MatchReject {
    @ApiModelProperty(value="CorrelationId used to correlate a request witha response", required=false, position=7)
    private String correlationId;
    @ApiModelProperty(value="Resource we want to reject", required=true, notes="min = 1, max = 1", position=3)
    @NotNull(message="The resourceMap cannot be null")
    @Size(min=1, max=1, message="Only a single entry is permitted in the resource map. This is to specify the resource being rejected")
    @Valid
    private Map<Integer, Resource> resourceMap;
    @ApiModelProperty(value="Ordered Map of Services we want to update", required=true, notes="min = 1, max = 6", position=4)
    @Size(min=0, max=6, message="A maximum of {max} services are permitted within the service map")
    @ValidService
    private Map<Integer, Service> serviceMap;
    @ApiModelProperty(value="Reason code used in reject API calls", required=true, allowableValues="NO_REASON, RESOURCE_BUSY, RESOURCE_DECLINE, NO_ANSWER, ROUTE_FAILED", position=6)
    @EnumValue(enumClass=RejectReason.class)
    private String reason;

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public Map<Integer, Resource> getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(Map<Integer, Resource> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public Map<Integer, Service> getServiceMap() {
        return this.serviceMap;
    }

    public void setServiceMap(Map<Integer, Service> serviceMap) {
        this.serviceMap = serviceMap;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

