/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidProficiencyRange;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidProficiencyRangeValidator
implements ConstraintValidator<ValidProficiencyRange, Map<Integer, Service>> {
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(ValidProficiencyRangeValidator.class);
    public static final String MINIMUM_EXCEEDS_MAXIMUM_ERROR_MESSAGE = "Service with Id %d has a wrong preferred minimum proficiency %d which exceeds the preferred maximum proficiency %d";
    public static final String INVALID_RANGE_ERROR_MESSAGE = "Service with Id %d in the request has an invalid Preferred Proficiency. Proficiency value should be in between 1 to 16.";
    private static final int VALID_MAX_PROFICIENCY = 16;
    private static final int VALID_MIN_PROFICIENCY = 1;

    public void initialize(ValidProficiencyRange constraintAnnotation) {
    }

    public boolean isValid(Map<Integer, Service> serviceMap, ConstraintValidatorContext context) {
        String methodName = "isValid";
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (serviceMap != null) {
            for (Map.Entry<Integer, Service> serviceMapEntry : serviceMap.entrySet()) {
                String errorMessage;
                int serviceId = serviceMapEntry.getKey();
                Service service = serviceMapEntry.getValue();
                int minProficiency = this.findMinProficiency(service);
                int maxProficiency = this.findMaxProficiency(service);
                if (minProficiency < 1 || minProficiency > 16 || maxProficiency < 1 || maxProficiency > 16) {
                    errorMessage = String.format(INVALID_RANGE_ERROR_MESSAGE, serviceId);
                    LOG.error("isValid", "", errorMessage, new Object[0]);
                    context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
                    isValid = false;
                    continue;
                }
                if (minProficiency >= maxProficiency) continue;
                errorMessage = String.format(MINIMUM_EXCEEDS_MAXIMUM_ERROR_MESSAGE, serviceId, minProficiency, maxProficiency);
                LOG.error("isValid", "", errorMessage, new Object[0]);
                context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
                isValid = false;
            }
        }
        return isValid;
    }

    private int findMinProficiency(Service service) {
        return service != null && service.getMinProficiency() != null ? service.getMinProficiency() : 16;
    }

    private int findMaxProficiency(Service service) {
        return service != null && service.getMaxProficiency() != null ? service.getMaxProficiency() : 1;
    }
}

