/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.MatchReject;
import com.avaya.ingensg.ce.wa.imrest.common.model.MatchRequest;
import com.avaya.ingensg.ce.wa.imrest.common.model.MatchUpdateRequest;
import com.avaya.ingensg.ce.wa.imrest.common.model.Resource;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource;
import com.avaya.ingensg.wa.common.im.ResourceKeys;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;

public class ValidSpecifiedResourceValidator
implements ConstraintValidator<ValidSpecifiedResource, Object> {
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(ValidSpecifiedResourceValidator.class);
    private static final int MAX_SPECIFIED_RESOURCES = 3;

    public void initialize(ValidSpecifiedResource constraintAnnotation) {
    }

    public boolean isValid(Object request, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        int sizeOfServices = 0;
        int sizeOfResources = 0;
        Map<Integer, Resource> resourceMap = null;
        Map<Integer, Service> serviceMap = null;
        if (request instanceof MatchRequest) {
            MatchRequest matchRequest = (MatchRequest)request;
            resourceMap = matchRequest.getResourceMap();
            serviceMap = matchRequest.getServiceMap();
        } else if (request instanceof MatchUpdateRequest) {
            MatchUpdateRequest matchUpdateRequest = (MatchUpdateRequest)request;
            resourceMap = matchUpdateRequest.getResourceMap();
            serviceMap = matchUpdateRequest.getServiceMap();
        } else if (request instanceof MatchReject) {
            MatchReject matchReject = (MatchReject)request;
            resourceMap = matchReject.getResourceMap();
            serviceMap = matchReject.getServiceMap();
        }
        sizeOfResources = resourceMap != null ? resourceMap.size() : 0;
        int n = sizeOfServices = serviceMap != null ? serviceMap.size() : 0;
        if (!this.isMapSizeIsCorrect(request, sizeOfServices, sizeOfResources, context)) {
            return false;
        }
        if (resourceMap != null && !resourceMap.isEmpty()) {
            return this.isValidResourceMap(resourceMap, context);
        }
        return true;
    }

    private boolean isMapSizeIsCorrect(Object request, int sizeOfServices, int sizeOfResources, ConstraintValidatorContext context) {
        String methodName = "isMapSizeIsCorrect";
        boolean valid = true;
        if (sizeOfServices == 0) {
            valid = sizeOfResources > 0;
        } else if (sizeOfResources == 0) {
            boolean bl = valid = sizeOfServices > 0;
        }
        if (!valid) {
            LOG.error("isMapSizeIsCorrect", "", "Either serviceMap or resourceMap must contain at least 1 entry : {}", new Object[]{request});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource.mapSize}").addConstraintViolation();
        }
        return valid;
    }

    private boolean isValidResourceMap(Map<Integer, Resource> resourceMap, ConstraintValidatorContext context) {
        String methodName = "isKeysValid";
        if (resourceMap == null || resourceMap.isEmpty() || resourceMap.size() > 3) {
            LOG.error("isKeysValid", "", "Invalid resourceMap. ResourceMap for a specified resource must contain max of 3 resource entries", new Object[0]);
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource.resourceMapSize}").addConstraintViolation();
            return false;
        }
        for (Map.Entry<Integer, Resource> entrySet : resourceMap.entrySet()) {
            Integer key = entrySet.getKey();
            Resource resource = entrySet.getValue();
            if (key < 1 || key > 3) {
                LOG.error("isKeysValid", "", "Invalid key {} in the resourceMap. Keys in the ResourceMap for a specified resource should be in the range 1-3 ", new Object[]{key});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource.resourceKey}").addConstraintViolation();
                return false;
            }
            Map<String, String> resourceDataMap = resource.getResource();
            if (resourceDataMap == null || resourceDataMap.isEmpty()) {
                LOG.error("isKeysValid", "", "The resourceMap entries must contain resource data", new Object[0]);
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource.resourceMapEntry}").addConstraintViolation();
                return false;
            }
            if (!resourceDataMap.keySet().contains(ResourceKeys.NativeResourceId.name())) {
                LOG.error("isKeysValid", "", "Invalid resourceMap. ResourceMap must contain an entry for the NativeResourceId", new Object[0]);
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource.nativeResourceId}").addConstraintViolation();
                return false;
            }
            if (!resourceDataMap.keySet().contains(ResourceKeys.SourceName.name())) {
                LOG.error("isKeysValid", "", "Invalid resourceMap. ResourceMap must contain an entry for the SourceName", new Object[0]);
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource.sourceName}").addConstraintViolation();
                return false;
            }
            for (Map.Entry<String, String> resourceDataMapEntrySet : resourceDataMap.entrySet()) {
                String dataKey = resourceDataMapEntrySet.getKey();
                String dataValue = resourceDataMapEntrySet.getValue();
                if (!StringUtils.isBlank((String)dataKey) && !StringUtils.isBlank((String)dataValue)) continue;
                LOG.error("isKeysValid", "", "Invalid resourceMap. Keys and values cannot be null or empty", new Object[0]);
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource.blankKeyOrValue}").addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

