/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.runtime.platforms;

import com.avaya.sce.runtime.ILanguage;
import com.avaya.sce.runtime.ILocaleFormatter;
import com.avaya.sce.runtime.internal.ASRTTSFinder;
import com.avaya.sce.runtime.internal.LocaleFinder;
import com.avaya.sce.runtimecommon.IPlatformClientToolkit;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.vp.ws.EPMWebServicesClientBase;
import com.avaya.vp.ws.EPMWebServicesClientFactory;
import javax.servlet.http.HttpServletRequest;

public class Toolkit {
    private static ILanguage getLangClass(String language) {
        ILanguage langClass = null;
        try {
            langClass = (ILanguage)ASRTTSFinder.getASRTTSFinder(language).getInstance("ASR_TTS_Language");
        }
        catch (Exception e) {
            throw new SCERuntimeException("Language [" + language + "] does not exits", e);
        }
        return langClass;
    }

    public static String getCurrentLanguageTTS(SCESession mySession) {
        if (mySession.getCurrentLanguage() == null) {
            mySession.setDefaultLanguage();
        }
        return Toolkit.getLangClass(mySession.getCurrentLanguage()).getTTSLanguage();
    }

    public static String getCurrentLanguageLocalization(SCESession mySession) {
        if (mySession.getCurrentLanguage() == null) {
            mySession.setDefaultLanguage();
        }
        return Toolkit.getLangClass(mySession.getCurrentLanguage()).getLocalizationLanguage();
    }

    public static String getLanguageLocalization(String language) {
        if (language != null) {
            return Toolkit.getLangClass(language).getLocalizationLanguage();
        }
        return null;
    }

    public static String getCurrentLanguageASR(SCESession mySession) {
        if (mySession.getCurrentLanguage() == null) {
            mySession.setDefaultLanguage();
        }
        return Toolkit.getLangClass(mySession.getCurrentLanguage()).getASRLanguage();
    }

    public static ILocaleFormatter getFormatter(SCESession mySession) {
        ILocaleFormatter formatter = null;
        try {
            formatter = (ILocaleFormatter)LocaleFinder.getLocaleFinder(Toolkit.getCurrentLanguageLocalization(mySession).toLowerCase()).getInstance("FormatLocale");
        }
        catch (Exception e1) {
            formatter = null;
        }
        return formatter;
    }

    public static ILocaleFormatter getFormatterByLanguage(String language) {
        ILocaleFormatter formatter = null;
        try {
            formatter = (ILocaleFormatter)LocaleFinder.getLocaleFinder(Toolkit.getLanguageLocalization(language).toLowerCase()).getInstance("FormatLocale");
        }
        catch (Exception e1) {
            formatter = null;
        }
        return formatter;
    }

    public static IPlatformClientToolkit getPlatformClientToolkit(String platform) {
        if ("Experience Portal".equals(platform) || "Voice Portal".equals(platform)) {
            return new IPlatformClientToolkit(){

                public EPMWebServicesClientBase initializeClient(HttpServletRequest request) {
                    EPMWebServicesClientBase client = EPMWebServicesClientFactory.createEPMWebServicesClient((HttpServletRequest)request);
                    return client;
                }
            };
        }
        return null;
    }
}

